//////////////////////////////////////
//  Program Name: SNAKO.CPP
//  Programmer: Charlie Calvert
//  Description: A windows game
//  Date: 08/05/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <string.h>
#include <stdlib.h>
#include "snako.h"
#include "score.h"
#include "grunt.h"
#include "snakutil.h"
#pragma warning (disable : 4068)
#pragma warning (disable : 4100)

static char szAppName[] = "Snako";
static char szScoreClass[] = "ScoreKeeper";

HWND MainWindow;

// Varialbles
HINSTANCE hInstance;
HWND hScoreWindow;
TSNAKEMAP SMap;
PGAMEINFO G, SaveGame;
//---------------------------------------------------------
// Setup
//---------------------------------------------------------

#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  }
  return Msg.wParam;
}

//////////////////////////////////////
// Save hInstance, Create window,
//  Show window maximized
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName,
                   "A Snake and its Tail",
                   WS_POPUP, CW_USEDEFAULT, CW_USEDEFAULT,
                   CW_USEDEFAULT, CW_USEDEFAULT,
                   NULL, NULL, hInst, NULL);

  if (hWindow == NULL)
    return hWindow;

  nCmdShow = SW_SHOWMAXIMIZED;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

//////////////////////////////////////
// Register window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(BLACK_BRUSH);
  WndClass.lpszMenuName   = NULL;
  WndClass.lpszClassName  = szAppName;

  if (!RegisterClass (&WndClass))
    return FALSE;

  WndClass.lpfnWndProc    = ScoreWndProc;
  WndClass.hIcon          = NULL;
  WndClass.hbrBackground  = NULL;
  WndClass.lpszClassName  = szScoreClass;

  return RegisterClass (&WndClass);
}

// -------------------------------------------------
// The Implementation
// -------------------------------------------------

// -------------------------------------------------
// WndProc
// -------------------------------------------------
LRESULT CALLBACK __export WndProc(HWND hwnd, UINT Message,
                              WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Snake_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Snake_OnDestroy);
    HANDLE_MSG(hwnd, WM_CHAR, Snake_OnChar);
    HANDLE_MSG(hwnd, WM_KEYDOWN, Snake_OnKey);
    HANDLE_MSG(hwnd, WM_PAINT, Snake_OnPaint);
    HANDLE_MSG(hwnd, WM_TIMER, Snake_OnTimer);
    HANDLE_MSG(hwnd, WM_START, Snake_OnStart);
    HANDLE_MSG(hwnd, WM_SIZE, Snake_OnSize);
    default: return Snake_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Snake_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  if((G = (PGAMEINFO)malloc(sizeof(TGAMEINFO))) == NULL)
  {
     MessageBox(hwnd, "Memory is hosed!", "Closing Snako", MB_OK);
     return FALSE;
  }

  InitializeSections();

  G->Dat.Speed = 250;
  int XScreen = GetSystemMetrics(SM_CXSCREEN);

  if (XScreen == 1024)
  {
    G->Dat.GrassX = G->Dat.SizeX = 32;
    G->Dat.GrassY = G->Dat.SizeY = 32;
  }

  if (XScreen == 800)
  {
    G->Dat.GrassX = G->Dat.SizeX = 25;
    G->Dat.GrassY = G->Dat.SizeY = 25;
  }

  if (XScreen == 640)
  {
    G->Dat.GrassX = G->Dat.SizeX = 20;
		G->Dat.GrassY = G->Dat.SizeY = 20;
  }

  G->Dat.MaxScore = 3 * G->Dat.GrassX;
  G->Dat.MenuSpace = 3;
  G->Dat.TotalClicks = 0;

  SMap.Grass = LoadBitmap(hInstance, "Grass");
  SMap.Road = LoadBitmap(hInstance, "Road");
  SMap.Road2 = LoadBitmap(hInstance, "Road2");
  if ((!SMap.Grass) || (!SMap.Road) || (!SMap.Road2))
  {
    MessageBox(hwnd, "No Grass! No Road! No Road2!", 
               "Fatal Error", MB_OK | MB_ICONSTOP);
    return FALSE;
  }

  SMap.Head = LoadBitmap(hInstance, "Head");
  if (!SMap.Head)
  {
    MessageBox(hwnd, "No head", "Fatal Error", MB_OK);
    return FALSE;
  }

  SMap.Body = LoadBitmap(hInstance, "Body");
  if (!SMap.Body)
  {
    MessageBox(hwnd, "No body", "Fatal Error", MB_OK);
    return FALSE;
  }

  hScoreWindow = CreateWindow(szScoreClass, "Score",
                   WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS,
                   10, 10, 100, 100, hwnd,
                   HMENU(50), hInstance, NULL);

  if(!hScoreWindow)
		return FALSE;

  G->ScoreRep.Level = 1;
  ReadArray(hwnd);
  SaveGame = NULL;

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Snake_OnDestroy(HWND hwnd)
{
  if (SMap.Head) DeleteObject(SMap.Head);
  if (SMap.Body) DeleteObject(SMap.Body);
  if (SMap.Grass) DeleteObject(SMap.Grass);
  if (SMap.Road) DeleteObject(SMap.Road);
  if (SMap.Road2) DeleteObject(SMap.Road2);
  free(G);
  if (SaveGame)
    free(SaveGame);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_CHAR -- Stub code to implement
// a pause feature by pressing the p key
//////////////////////////////////////
#pragma argsused
void Snake_OnChar(HWND hwnd, UINT ch, int cRepeat)
{
  switch (ch)
  {
    case 'p':
      KillTimer(hwnd, SNAKETIMER);
      break;
    case 's':
      SendMessage(hwnd, WM_START, 0, 0L);
      break;
    case 'r':
      SendMessage(hScoreWindow, WM_COMMAND, ID_SCORE, 0);
      break;
    case 'f':
      SendMessage(hScoreWindow, WM_COMMAND, ID_FINI, 0);
      break;
  }
}

//////////////////////////////////////
// Handle WM_KEYDOWN
//////////////////////////////////////
#pragma argsused
void Snake_OnKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT 
flags)
{
  switch(vk)
  {
    case VK_DOWN:
      SetNewDir(DOWN);
      MoveBitMap(hwnd);
      break;
    case VK_UP:
      SetNewDir(UP);
      MoveBitMap(hwnd);
      break;
    case VK_LEFT:
      SetNewDir(LEFT);
      MoveBitMap(hwnd);
      break;
    case VK_RIGHT:
      SetNewDir(RIGHT);
      MoveBitMap(hwnd);
      break;
  }

  // In case you hit no accidentally
  if (G->Dat.NewScreenStarted == 2)
  {
    G->Dat.NewScreenStarted = FALSE;
    SetTimer(hwnd, SNAKETIMER, G->Dat.Speed, NULL);
    InvalidateRect(hwnd, NULL, TRUE);
  }
}

//////////////////////////////////////
// -- Snake_OnPaint --
// Repaint the playing board
//////////////////////////////////////
void Snake_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);
  PaintPlayingField(PaintDC);
  EndPaint(hwnd, &PaintStruct);

  G->SectInfo[0].DirChange = FALSE;
  InvalidateRect(hScoreWindow, NULL, FALSE);
}

//////////////////////////////////////
// Set the position of the score window
//////////////////////////////////////
void Snake_OnSize(HWND hwnd, UINT state, int cx, int cy)
{
  MoveWindow(hScoreWindow, 0, 0, cx, G->Dat.MaxScore - 1, FALSE);
  FORWARD_WM_SIZE(hwnd, state, cx, cy, Snake_DefProc);
}


//////////////////////////////////////
// Handle the user defined WM_START message
// when the start button is pressed
//////////////////////////////////////
void Snake_OnStart(HWND hwnd)
{
  HDC PaintDC;

  SetFocus(hwnd);
  InitializeSections();
  ReadArray(hwnd);
  PaintDC = GetDC(hwnd);
  PaintPlayingField(PaintDC);
  ReleaseDC(hwnd, PaintDC);
  SetUpWindow(hwnd);
  InvalidateRect(hScoreWindow, NULL, TRUE);
}

//////////////////////////////////////
// -- Snake_OnTimer --
// Gets called when the timer runs out.
// Call MoveBitMap to move the snake.
// If the Timer has been called 15 times in
// a row, then add a new section to the Snake
//////////////////////////////////////
#pragma argsused
void Snake_OnTimer(HWND hwnd, UINT id)
{
  MoveBitMap(hwnd);
  G->Dat.TotalClicks++;
  //  QuickScan(); // debug routine found in SnakUtil
  SendMessage(hScoreWindow, WM_SETNUMSEGS, 0, (LPARAM)&G->ScoreRep);

  if (G->ScoreRep.NumPrizes > 60000) G->ScoreRep.NumPrizes = 0;

  #ifdef _DEBUG
    if (G->ScoreRep.NumPrizes <= 20)
      if(G->Map[BRIDGEX1][G->Dat.MaxCols - 1] != ROADMAP)
        MakeGateWay(hwnd);
  #else
    if (G->ScoreRep.NumPrizes <= 0)
      if((G->Map[BRIDGEX1][G->Dat.MaxCols - 1] != ROADMAP) ||
         (G->ScoreRep.ScreenNum == 4))
        MakeGateWay(hwnd);
  #endif

  if ((G->Dat.TotalClicks % 15) == 0)
    AddSection();

  G->ScoreRep.NumSects = G->Dat.Sections;

  if (G->Dat.NewScreenStarted == 2)
  {
    G->Dat.NewScreenStarted = FALSE;
    SetTimer(hwnd, SNAKETIMER, G->Dat.Speed, NULL);
    InvalidateRect(hwnd, NULL, TRUE);
  }
}
