//////////////////////////////////////
// Program Name: SNAKOUTIL.CPP
// Programmer: Charlie Calvert
// Description: Miscellaneous routines
// Date: 08/05/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "snako.h"

extern PGAMEINFO SaveGame;
extern PGAMEINFO G;

//////////////////////////////////////
//  Save Game from Memory
//////////////////////////////////////
BOOL ReadGameFromMemory(void)
{
  memcpy(G, SaveGame, sizeof(TGAMEINFO));
  return TRUE;
}

//////////////////////////////////////
//  Save Game to Memory
//////////////////////////////////////
BOOL SaveGameToMemory(HWND hwnd)
{
  if (!SaveGame)
  {
    free(SaveGame);
    SaveGame = NULL;
  }

  if((SaveGame = (PGAMEINFO)malloc(sizeof(TGAMEINFO))) == NULL)
  {
    MessageBox(hwnd,"Memory is hosed!","Closing Snako",MB_OK);
    return FALSE;
  }
  memcpy(SaveGame, G, sizeof(TGAMEINFO));
  return TRUE;
}


//////////////////////////////////////
// Stretch the bitmaps to fit users
// screen resolution
//////////////////////////////////////
HDC GetScaledDC(HDC PaintDC, TSAVEBITMAPARY SB,
                HBITMAP Bmp, int Num)
{
  SB[Num].CompDC = CreateCompatibleDC(PaintDC);
  SB[Num].TCompDC = CreateCompatibleDC(PaintDC);
  SB[Num].CompBmp = CreateCompatibleBitmap(PaintDC,
                      G->Dat.GrassX, G->Dat.GrassY);
  SB[Num].OldBmp = SelectBitmap(SB[Num].CompDC, Bmp);
  SB[Num].OldTBmp = SelectBitmap(SB[Num].TCompDC,
                      SB[Num].CompBmp);

  StretchBlt(SB[Num].TCompDC,
             0, 0, G->Dat.GrassX, G->Dat.GrassY,
               SB[Num].CompDC, 0, 0, XWIDTH, YHEIGHT, SRCCOPY);

  return SB[Num].TCompDC;
}

//////////////////////////////////////
// Dispose resources created in GetScaledDC
//////////////////////////////////////
BOOL DisposeScaledDC(TSAVEBITMAPARY SB, int Num)
{
  SelectBitmap(SB[Num].CompDC, SB[Num].OldBmp);
  SelectBitmap(SB[Num].TCompDC, SB[Num].OldTBmp);
  DeleteBitmap(SB[Num].CompBmp);
  DeleteDC(SB[Num].CompDC);
  DeleteDC(SB[Num].TCompDC);
  return TRUE;
}

//////////////////////////////////////
// Called whenever a new game is started
//////////////////////////////////////
void InitializeSections(void)
{
  int i, StartCol, StartRow;

  StartCol = -1;
  StartRow = 0;
  G->Dat.XPos = 0;
  G->Dat.Sections = 1;
  G->Dat.MaxCols = 32;
  G->Dat.MinCols = 0;
  G->Dat.NewScreenStarted = FALSE;

  G->ScoreRep.ScreenNum = 1;
  G->ScoreRep.TotalScore = 0;
  G->ScoreRep.NumPrizes = 0;
  G->ScoreRep.Level = 1;

  for (i = 0; i < 2; i++)
  {
    G->SectInfo[i].Dir = RIGHT;
    G->SectInfo[i].DirChange = FALSE;
    G->SectInfo[i].Col = StartCol - i;
    G->SectInfo[i].Row = StartRow;
    G->SectInfo[i].OldCol = G->SectInfo[i].Col;
    G->SectInfo[i].OldRow = G->SectInfo[i].Row;
  }
}

//////////////////////////////////////
// So you made it level two...
//////////////////////////////////////
void InitializeNewLevel(void)
{
  int i, StartCol, StartRow;

  StartCol = -1;
  StartRow = 0;
  G->Dat.XPos = 0;
  G->Dat.MaxCols = 32;
  G->Dat.MinCols = 0;
  G->ScoreRep.ScreenNum = 1;

  // line 'em up off screen one behind next
  for (i = 0; i <= G->Dat.Sections; i++)
  {
    G->SectInfo[i].Dir = RIGHT;
    G->SectInfo[i].DirChange = FALSE;
    G->SectInfo[i].Col = StartCol - i;
    G->SectInfo[i].Row = StartRow;
    G->SectInfo[i].OldCol = G->SectInfo[i].Col;
    G->SectInfo[i].OldRow = G->SectInfo[i].Row;
  }
}

//////////////////////////////////////
// Crossing the border..
//////////////////////////////////////
void StartNewScreen(HWND hwnd)
{
  InitializeNewLevel();
  ReadArray(hwnd);
  InvalidateRect(hwnd, NULL, FALSE);
}

//////////////////////////////////////
// Read screen arrays into memory
// Change case statement to add levels
//////////////////////////////////////
int ReadArray(HWND hwnd)
{
  FILE * fp;
  char FileName[50];

  switch (G->ScoreRep.Level)
  {
    case 1: strcpy(FileName, "Screen.Dta"); break;
    case 2: strcpy(FileName, "Screen1.Dta"); break;
  }

  if ((fp = fopen(FileName, "r")) == NULL)
  {
    MessageBox(hwnd, "No Stream", "NULL", MB_OK);
    return FALSE;
  }

  if((fread(G->Map, sizeof(G->Map), 1, fp)) == 0)
  {
    MessageBox(hwnd, "No map", "Grunt", MB_OK);
    return FALSE;
  }

  fclose(fp);

  return TRUE;
}

//////////////////////////////////////
// If you ever get caught on a level
// and can't get out even though
// you've eaten all dots, call this
// from third line of Snako_OnTimer
//////////////////////////////////////
void QuickScan(void)
{
  G->ScoreRep.NumPrizes = 0;
  int TotalX = G->Dat.MinCols + JUMPSPACE;

  for (int i = 0; i < MAXY; i++)
    for (int j = G->Dat.MinCols; j < TotalX; j++)
      if(G->Map[i][j] == PRIZEMAP)
        G->ScoreRep.NumPrizes++;
}

//////////////////////////////////////
// Perform setup => initialize Timer
//////////////////////////////////////
BOOL SetUpWindow(HWND hwnd)
{
  if (!SetTimer(hwnd, SNAKETIMER, 175, NULL))
  {
    MessageBox(hwnd, "No Timers Available", "Snako", MB_OK);
    return FALSE;
  }
	return TRUE;
}
