//////////////////////////////////////
//  Program Name: SYSINFO.CPP
//  Programmer: Charlie Calvert
//  Description: What I did on my system's vacation
//  Date: 08/09/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "SysInfo.h"

#pragma warning (disable: 4068)
#pragma warning (disable: 4100)

// ----------------------------------------
// Interface
// ----------------------------------------

static char szAppName[] = "SysInfo";
static HWND MainWindow;
static HINSTANCE hInstance;

// ----------------------------------------
// Initialization
// ----------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = "MENU_1";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// ---------------------------------------
// WndProc and Implementation
// ---------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_DESTROY, SysInfo_OnDestroy);
    HANDLE_MSG(hWindow, WM_COMMAND, SysInfo_OnCommand);
    HANDLE_MSG(hWindow, WM_PAINT, SysInfo_OnPaint);
    default:
      return SysInfo_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void SysInfo_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

#pragma argsused
void SysInfo_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify)
{
  switch(id)
  {
    case CM_ABOUT:
      FARPROC AboutBox =
        MakeProcInstance((FARPROC)AboutDlgProc, hInstance);
      DialogBox(hInstance, "About", hwnd, (DLGPROC)AboutBox);
      FreeProcInstance(AboutBox);
      break;
  }
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void SysInfo_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  SYSHEAPINFO Info;
  char S[100];

  Info.dwSize = sizeof(SYSHEAPINFO);
  SystemHeapInfo(&Info);
  DWORD FreeSpace = GetFreeSpace(0) / 1024;

  PaintDC = BeginPaint(hwnd, &PaintStruct);
  sprintf(S, "Percent free in the USER heap: %d",
          Info.wUserFreePercent);
  TextOut(PaintDC, 10, 10, S, strlen(S));
  sprintf(S, "Percent free in the GDI heap: %d",
          Info.wGDIFreePercent);
  TextOut(PaintDC, 10, 35, S, strlen(S));
  sprintf(S, "Kilobytes free on Global heap: %ld", FreeSpace);
  TextOut(PaintDC, 10, 60, S, strlen(S));
  EndPaint(hwnd, &PaintStruct);
}

// -----------------------------------------------
// SysInfo Dialog
// -----------------------------------------------

//////////////////////////////////////
//  The SysInfo Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK AboutDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      return TRUE;

    case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
      {
        EndDialog(hDlg, TRUE);
        return TRUE;
      }
      break;
  }
  return FALSE;
}
