//////////////////////////////////////
//  Module Name: SYSMOD.CPP
//  Programmer: Charlie Calvert
//  Description: Part of SysInfo Application
//  Date: 08/09/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "sysinfo.h"
#pragma warning (disable: 4068)

extern HBRUSH BlueBrush;

//////////////////////////////////////
// SetModuleContents
//////////////////////////////////////
BOOL SetModuleContents(HWND hDlg)
{
  MODULEENTRY Module;
  BOOL Result = TRUE;

  HWND hModBox = GetDlgItem(hDlg, ID_MODULELISTBOX);
  SetWindowFont(hModBox, GetStockObject(ANSI_FIXED_FONT), 0);
  Module.dwSize = sizeof(MODULEENTRY);
  ModuleFirst(&Module);
  while (Result)
  {
    ListBox_AddString(hModBox, Module.szModule);
    Result = ModuleNext(&Module);
  }
  return TRUE;
}

//////////////////////////////////////
// FillModuleBox
//////////////////////////////////////
FillModuleBox(HWND hDlg, LPSTR S)
{
  MODULEENTRY Module;
  BOOL Result = TRUE;

  HWND hEdWnd = GetDlgItem(hDlg, ID_MODULEEDIT);
  SetWindowFont(hEdWnd, GetStockObject(ANSI_FIXED_FONT), 0);
  Module.dwSize = sizeof(MODULEENTRY);
  ModuleFirst(&Module);
  if (!strcmp(Module.szModule, S))
    SetWindowText(hEdWnd, Module.szExePath);

  while (Result)
  {
    Result = ModuleNext(&Module);
    if (!strcmp(Module.szModule, S))
      SetWindowText(hEdWnd, Module.szExePath);
  }
  return TRUE;
}

//////////////////////////////////////
// HandleSysColor
//////////////////////////////////////
BOOL HandleSysColor(WPARAM wParam, LPARAM lParam)
{
  if (GetDlgCtrlID((HWND)LOWORD(lParam)) == -1)
  {
    SetTextColor((HDC)wParam, RGB(0, 0, 255));
    SetBkMode((HDC)wParam, TRANSPARENT);
    return (BOOL) GetStockBrush(GRAY_BRUSH);
  }

  switch(HIWORD(lParam))
  {
    case CTLCOLOR_STATIC:
    case CTLCOLOR_LISTBOX:
      SetTextColor((HDC)wParam, RGB(255, 255, 0));
      SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL) BlueBrush;

    case CTLCOLOR_DLG:
      return (BOOL) GetStockBrush(GRAY_BRUSH);
  }
  return FALSE;
}
//////////////////////////////////////
// The SysInfo Module Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK ModuleDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  int Index;
  char S[100];

  switch(Message)
  {
    case WM_INITDIALOG:
      SetModuleContents(hDlg);
      return TRUE;

    case WM_CTLCOLOR:
      return HandleSysColor(wParam, lParam);

    case WM_COMMAND:
      switch (wParam)
      {
        case IDOK:
        case IDCANCEL:
          EndDialog(hDlg, TRUE);
          return TRUE;

        case ID_MODULELISTBOX:
          if (HIWORD(lParam) == LBN_SELCHANGE)
          {
            HWND hListBox = (HWND)LOWORD(lParam);
            Index = ListBox_GetCurSel(hListBox);

            strcpy(S, "Trouble");
            if (Index != LB_ERR)
            {
              ListBox_GetText(hListBox, Index, S);
              FillModuleBox(hDlg, S);
            }
          }
        return TRUE;
      }
    }
    return FALSE;
}
