//////////////////////////////////////
//  Module Name: SYSTASK.CPP
//  Programmer: Charlie Calvert
//  Description: Part of SysInfo Application
//  Date: 08/09/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "sysinfo.h"
#pragma warning (disable: 4068)
#pragma warning (disable: 4100)

static HWND hTaskWnd, hLBWnd, hEdWnd;

//////////////////////////////////////
// SetTaskContents
//////////////////////////////////////
BOOL SetTaskContents(void)
{
  TASKENTRY Task;
  BOOL Result = TRUE;

  Task.dwSize = sizeof(TASKENTRY);
  TaskFirst(&Task);
  while (Result)
  {
    ListBox_AddString(hTaskWnd, Task.szModule);
    Result = TaskNext(&Task);
  }
  return TRUE;
}

//////////////////////////////////////
// GetModule
//////////////////////////////////////
HMODULE GetModule(LPSTR S)
{
  MODULEENTRY Module;
  BOOL Result = TRUE;

  Module.dwSize = sizeof(MODULEENTRY);
  ModuleFirst(&Module);
  if (!strcmp(Module.szModule, S))
  {
    SetWindowText(hEdWnd, Module.szExePath);
    return Module.hModule;
  }

  while (Result)
  {
    Result = ModuleNext(&Module);
    if (!strcmp(Module.szModule, S))
    {
      SetWindowText(hEdWnd, Module.szExePath);
      return Module.hModule;
    }
  }
  return NULL;
}

//////////////////////////////////////
// ShowWindowClasses
//////////////////////////////////////
BOOL ShowWindowClasses(HMODULE hModule)
{
  CLASSENTRY Class;
  BOOL Result = TRUE;

  ListBox_ResetContent(hLBWnd);

  Class.dwSize = sizeof(CLASSENTRY);
  ClassFirst(&Class);
  if (hModule == Class.hInst)
    ListBox_AddString(hLBWnd, Class.szClassName);

  while (Result)
  {
    Result = ClassNext(&Class);
    if (hModule == Class.hInst)
      ListBox_AddString(hLBWnd, Class.szClassName);
  }
  return NULL;
}

//////////////////////////////////////
// The FillTaskBox
//////////////////////////////////////
#pragma argsused
BOOL FillTaskBox(HWND hDlg, LPSTR S)
{
  HMODULE hModule = GetModule(S);
  ShowWindowClasses(hModule);
  return TRUE;
}

//////////////////////////////////////
// The SysInfo Task Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK TaskDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  char S[100];
  int Index;

  switch(Message)
  {
    case WM_INITDIALOG:
      hTaskWnd = GetDlgItem(hDlg, ID_TASKLISTBOX);
      hLBWnd = GetDlgItem(hDlg, ID_TASKCLASSLIST);
      hEdWnd = GetDlgItem(hDlg, ID_TASKEDIT);
      SetWindowFont(hTaskWnd,GetStockObject(ANSI_FIXED_FONT), 0);
      SetWindowFont(hLBWnd, GetStockObject(ANSI_FIXED_FONT), 0);
      SetWindowFont(hEdWnd, GetStockObject(ANSI_FIXED_FONT), 0);
      SetTaskContents();
      ListBox_SetCurSel(GetDlgItem(hDlg, ID_TASKLISTBOX), 0);
      return TRUE;

    case WM_CTLCOLOR:
      return HandleSysColor(wParam, lParam);

    case WM_COMMAND:
      switch (wParam)
      {
        case IDOK:
        case IDCANCEL:
          EndDialog(hDlg, TRUE);
          return TRUE;

        case
          ID_TASKLISTBOX:
            if (HIWORD(lParam) == LBN_SELCHANGE)
            {
              HWND hListBox = (HWND)LOWORD(lParam);
              Index = ListBox_GetCurSel(hListBox);

              strcpy(S, "Trouble");
              if (Index != LB_ERR)
              {
                ListBox_GetText(hListBox, Index, S);
                FillTaskBox(hDlg, S);
              }
            }
            return TRUE;
      }
  }
  return FALSE;
}
