//////////////////////////////////////
//  Program Name: SYSWALK.CPP
//  Programmer: Charlie Calvert
//  Description: What I did on my system's vacation
//  Date: 08/09/93
//////////////////////////////////////
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "SysInfo.h"
#pragma warning (disable: 4068)
char *GDITypes[] = {"Normal",
    "Pen", "Brush", "Font",
    "Palette", "Bitmap", "RGN",
    "DC", "Disabled_DC",
    "MetaDC", "Metafile", "Free"};

char *WFlags[] = {"-", "Fixed",
                  "Free", "-",
                  "Moveable"};

void FillLocalDlg(HWND hDlg)
{
  SYSHEAPINFO Info;
  LOCALENTRY LocalEntry;
  int Result = TRUE;
  char S[150];
  char *T = "Type: ";
  char *R = "Size: ";
  char *F = "Flags: ";

  HWND hLocalList = GetDlgItem(hDlg, ID_LOCALLIST);
  SetWindowFont(hLocalList, GetStockObject(ANSI_FIXED_FONT), 0);
  Info.dwSize = sizeof(SYSHEAPINFO);
  if (!SystemHeapInfo(&Info)) return;
  LocalEntry.dwSize = sizeof(LocalEntry);
  LocalFirst(&LocalEntry, Info.hGDISegment);
  while (Result)
  {
    if (LocalEntry.wType < 12)
      sprintf(S, "%5s%-8s  %s%-6u %s%s", T,
              GDITypes[LocalEntry.wType],
              R, LocalEntry.wSize, F,
              WFlags[LocalEntry.wFlags]);
    else
      sprintf(S, "%5s%-8s  %s%-6u %s%s", T,
              GDITypes[11],
              R, LocalEntry.wSize, F,
              WFlags[LocalEntry.wFlags]);
    ListBox_AddString(hLocalList, S);
    Result = LocalNext(&LocalEntry);
  }
}
//////////////////////////////////////
// The SysInfo Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK LocalDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      FillLocalDlg(hDlg);
      return TRUE;

    case WM_CTLCOLOR:
      return HandleSysColor(wParam, lParam);

    case WM_COMMAND:
      switch(wParam)
      {
        case IDOK:
        case IDCANCEL:
          EndDialog(hDlg, TRUE);
          return TRUE;
      }
      break;
  }
  return FALSE;
}
