//////////////////////////////////////
// Program Name: Window1
// Programmer: Charlie Calvert
// Description: Example Windows program.
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
#pragma warning (disable: 4100)
 
static char szAppName[] = "Window1";
static HWND MainWindow;

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// ===================================
// INITIALIZATION
// ===================================

//////////////////////////////////////
// The WinMain function is the program entry point.
// Register the Window, Create it, enter the Message Loop.
// If either step fails, exit without creating the window
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style       = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc = WndProc;
  WndClass.cbClsExtra  = 0;
  WndClass.cbWndExtra  = 0;
  WndClass.hInstance   = hInst;
  WndClass.hIcon        = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor      = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName    = NULL;
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInstance, int nCmdShow)
{
  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// =====================================
// IMPLEMENTATION
// =====================================
#define Window1_DefProc    DefWindowProc
void Window1_OnDestroy(HWND hwnd);

//////////////////////////////////////
// The window proc is where messages get processed
//////////////////////////////////////
LRESULT CALLBACK __export WndProc(HWND hWindow, UINT Message,
                                  WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_DESTROY, Window1_OnDestroy);
    default:
      return Window1_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_DESTROY message
//////////////////////////////////////
#pragma argsused
void Window1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}
