//////////////////////////////////////
// WINSIZE.H
// Programmer: Charlie Calvert
// Date: 7/15/93
//////////////////////////////////////

// Constants
#define WM_SETDATA       (WM_USER + 1)
#define CM_EXIT          101
#define CM_SIZEBOX       1000
#define CM_MAKESHAPE     1001
#define RECTSIZE         2000
#define ID_MMLEFT        2101
#define ID_MMRIGHT       2102
#define ID_MMTOP         2103
#define ID_MMBOTTOM      2104
#define ID_LMLEFT        2201
#define ID_LMRIGHT       2202
#define ID_LMTOP         2203
#define ID_LMBOTTOM      2204
#define ID_HMLEFT        2301
#define ID_HMRIGHT       2302
#define ID_HMTOP         2303
#define ID_HMBOTTOM      2304
#define ID_LELEFT        2401
#define ID_LERIGHT       2402
#define ID_LETOP         2403
#define ID_LEBOTTOM      2404
#define ID_HELEFT        2501
#define ID_HERIGHT       2502
#define ID_HETOP         2503
#define ID_HEBOTTOM      2504
#define ID_TLEFT         2601
#define ID_TRIGHT        2602
#define ID_TTOP          2603
#define ID_TBOTTOM       2604
#define ID_RTEXT         3101
#define ID_RLOMETRIC     3102
#define ID_RHIMETRIC     3103
#define ID_RLOENGLISH    3104
#define ID_RHIENGLISH    3105
#define ID_RTWIPS        3106
#define ID_RISOTROPIC    3107
#define ID_RANSITROPIC   3108
#define ID_RLEFT         3110
#define ID_RRIGHT        3111
#define ID_RTOP          3112
#define ID_RBOTTOM       3113
#define ID_DRAW          3115
#define ID_COMPCORDS     3117
#define ID_USERCORDS     3118
#define ID_ORGUPLEFT     3120
#define ID_ORGLOWLEFT    3121
#define ID_ORGCENTER     3122
#define ID_RECT          4001
#define ID_CIRCLE        4002

// Types
typedef RECT TSIZEDATA[6];
enum TModeCase {TEXT, LOMETRIC, HIMETRIC, LOENGLISH,
                HIENGLISH, TWIPS, ISOTROPIC, ANSITROPIC};
enum TOriginMode {ORG_UPLEFT, ORG_LOWLEFT, ORG_CENTER};
enum TShape {RECTANGLE, CIRCLE};
int Modes[] = {MM_TEXT, MM_LOMETRIC, MM_HIMETRIC,
               MM_LOENGLISH, MM_HIENGLISH, MM_TWIPS,
               MM_ISOTROPIC, MM_ANISOTROPIC};

// Declarations for class Generic
#define WinSize_DefProc    DefWindowProc
BOOL WinSize_OnCreate(HWND hwnd,
                      CREATESTRUCT FAR* lpCreateStruct);
void WinSize_OnDestroy(HWND hwnd);
void WinSize_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify);
void WinSize_OnPaint(HWND hwnd);
void WinSize_OnSize(HWND hwnd, UINT state, int cx, int cy);

// Variables
FARPROC lpfnSizeBox;
FARPROC lpfnMakeShape;
HBRUSH BlueBrush, GreenBrush;
HWND hSizeBox;
TModeCase ModeCase = TEXT;
TOriginMode OriginMode = ORG_UPLEFT;
int RLeft = 10;
int RTop = 10;
int RRight = 100;
int RBottom = 100;
TShape Shape;
BOOL UseCompCords = TRUE;

// procs
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
BOOL CALLBACK _export MakeShapeProc(HWND hWindow, WORD Msg,
                                    WORD wParam, LONG lParam);
BOOL CALLBACK _export SizeBoxProc(HWND hWindow, WORD Msg,
                                  WORD wParam, LONG lParam);
