#if !defined(WINBASE_H)
class WindowRegClass {
    WORD style;
    LONG (FAR PASCAL *wndproc)( HWND, WORD, WORD, LONG );
    int clsExtra;
	int wndExtra;
	HANDLE hinst;
    HANDLE hprev;
    HICON hicon;
    HCURSOR hcursor;
	HBRUSH backgrd;
	LPSTR menuname;
	LPSTR classname;

public:
    WindowRegClass(LPSTR ClassName, HANDLE hInst, HANDLE hPrev,
                         long (FAR PASCAL *proc)(HWND, WORD, WORD, LONG )) {
        style          = CS_HREDRAW | CS_VREDRAW;
	    wndproc        = proc;
        clsExtra       = 0;
	    wndExtra       = 0;
	    hinst          = hInst;
        hprev          = hPrev;
        hicon          = LoadIcon(NULL, IDI_APPLICATION);
        hcursor        = LoadCursor(NULL, IDC_ARROW);
	    backgrd        = COLOR_WINDOW + 1;
	    menuname       = NULL;
	    classname      = ClassName;
    }
    void SetClassStyle(unsigned newstyle) { style =newstyle; }
    void AddClassStyle(unsigned addstyle) { style |=addstyle; }
    void SetClassBckrnd(HBRUSH newbckrnd) { backgrd =newbckrnd; }
    void SetClassMenu(LPSTR newmenu) { menuname =newmenu; }
    void SetClassWinXbytes(int xtrabytes) { wndExtra=xtrabytes; }
    void SetClassClsXbytes(int xtrabytes) { clsExtra=xtrabytes; }
    void SetClassIcon(LPSTR iconname) {
        if (hinst)
            hicon=LoadIcon(hinst,iconname);
    }
    void SetClassCursor(LPSTR cursorname) {
        if (hinst)
            hcursor=LoadCursor(hinst, cursorname);
    }
    void SetClassName(LPSTR clsname) { classname = clsname; }
    LPSTR GetClassName(void) { return classname; }
    void Register(void);
};

void WindowRegClass::Register(void) {
    WNDCLASS wndclass;

    if (!hprev)
    {
        wndclass.style          = style;
        wndclass.lpfnWndProc    = wndproc;
        wndclass.cbClsExtra     = clsExtra;
        wndclass.cbWndExtra     = wndExtra;
        wndclass.hInstance      = hinst;
        wndclass.hIcon          = hicon;
        wndclass.hCursor        = hcursor;
        wndclass.hbrBackground  = backgrd;
        wndclass.lpszMenuName   = menuname;
        wndclass.lpszClassName  = classname;

        RegisterClass(&wndclass);
    }
}

class Window {
     MSG msg;
     HWND hwnd;
     LPSTR classname;
     LPSTR windowname;
     DWORD winstyle;
     int upper_left_x;
     int upper_left_y;
     int winwidth;
     int winheight;
     HWND winParent;
     HMENU menu;
     HANDLE hInstan;
     LPSTR lpParam;

public:
     Window(LPSTR clsname, LPSTR winname, HANDLE hinst) {
        classname = clsname;
        windowname = winname;
        winstyle = 0;
        upper_left_x=upper_left_y=winwidth=winheight=CW_USEDEFAULT;
        winParent = NULL;
        menu = NULL;
        hInstan = hinst;
        lpParam = NULL;
    }

    void Display(void) { ShowWindow(GetHandle(), SW_SHOWNORMAL); }
    void Display(HANDLE hinst, int disp) { ShowWindow(hinst, disp); }
    void Update(void) { UpdateWindow(GetHandle()); }
    HWND GetHandle(void)   { return hwnd; }
    void Paint(void) {
        PAINTSTRUCT ps;
        RECT rect;
        BeginPaint(GetHandle(), &ps);
        EndPaint(GetHandle(), &ps);
    }
    MessageLoop(void) {
        while (GetMessage(&msg,NULL,0,0))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        return msg.wParam;
    }
    HWND Create(void) {
        hwnd=CreateWindow(classname,
                          windowname,
                          winstyle,
                          upper_left_x,
                          upper_left_y,
                          winwidth,
                          winheight,
                          winParent,
                          menu, hInstan,
                          lpParam);
        return(hwnd);
    }
    void SetWinName(LPSTR winname)      { windowname=winname;   }
    void SetWinStyle(DWORD dword)       { winstyle=dword;       }
    void AddWinStyle(DWORD dword)       { winstyle |=dword;     }
    void SetWinX(int x)                 { upper_left_x=x;       }
    void SetWinY(int y)                 { upper_left_y=y;       }
    void SetWinWidth(int width)         { winwidth=width;       }
    void SetWinHeight(int height)       { winheight=height;     }
    void SetWinInstance(HANDLE hinst)   { hInstan=hinst;      }
    void SetTitle(LPSTR newtitle)       { SetWindowText(hwnd, newtitle); }
};
#define WINBASE_H
#endif
