//*********************************************************
//* 
//* wndproc.c: the main windows processing function
//*
//*********************************************************

#define	NOCOMM
#define	_WINDOWS

#include	<windows.h>
#include <stdio.h>
#include	"rodsapp.h"
#include "dlls.h"

LONG FAR PASCAL MainWndProc(HWND hWnd, unsigned message, WORD wParam,
									LONG lParam)
{
	/* local variables */
	static HANDLE	hInstance;
	static FARPROC	lpProcAbout;

	switch(message) {

		case WM_CREATE:

			hInstance= GetWindowWord(hWnd, GWW_HINSTANCE);
			return(0);

		case WM_COMMAND:
		
			switch(wParam) {

				case IDM_STEPONE:

					StepOne(hWnd);
					break;

				case IDM_STEPTWO:

					StepTwo(hWnd);
					break;

				case IDM_ABOUT:

					lpProcAbout= MakeProcInstance(About, hInstance);

					if((DialogBox(hInstance,
						MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, lpProcAbout)) == -1) {

						MessageBeep(0);
						MessageBox(hWnd, "Could not create dialog box!", "WARNING", MB_OK);

					}

					/* free dialog instance */
					FreeProcInstance(lpProcAbout);

					break;

				default:
					return(DefWindowProc(hWnd, message, wParam, lParam));

			}

			return(0);

		case WM_DESTROY:

			PostQuitMessage(0);
			return(0);

		default:
			return(DefWindowProc(hWnd, message, wParam, lParam));

	}

	return(0L);

} /* MainWndProc */
