#if	!defined( lint )
static	char *sccsid = "@(#)dos.c	(C) Yves Roumazeilles	95/03/02";
#endif
#pragma	warning(disable:4001)

/*
//   Test program for DOS libs
//
//   Just compile it with the appropriate model (corresponding to the one
//   used by the library you selected:
//	SYGREP.LIB (Microsoft) and SYGREPB.LIB (Borland) are Small model;
//	CYGREP.LIB (Microsoft) and CYGREPB.LIB (Borland) are Compact model;
//	MYGREP.LIB (Microsoft) and MYGREPB.LIB (Borland) are Medium model;
//	LYGREP.LIB (Microsoft) and LYGREPB.LIB (Borland) are Large model;
//	HYGREP.LIB (Microsoft) is Huge model.
//
//   Version 2.1
*/

#define	STRICT	
#include	<windows2.h>
#include	<stdio.h>
#include	<malloc.h>
#include	"ygrep.h"


#define	CHECK(a,b,s)	if((a)!=(b)) {fprintf(stderr,"\n---"s"->(%d)\n",(a));return(-1);} else{fprintf(stderr,".");}



LPCSTR	test[] = {
	/*0*/	"include",
	/*1*/	"includi",
	/*2*/	"includeINCLUDE",
	/*3*/	"toto",
	/*4*/	"tototo",
	/*5*/	"totototo",
	/* */	"" };


main()
{
	int		iVal;
/*	AGREPINFO	aGI;	*/
	LPAGREPINFO	pGI;
	LPRGREPINFO	pRGI;
	char*		pTemp;
	char*		pSubs = "012345678901234567890123456789";
	char*		pDest = "012345678901234567890123456789";

	printf("*** YGrep Search Engine diags level 1/2/3 ***\n\n");
	printf("YGrepVersion: 0x%04x\n", YGrepVersion());
	printf("Starting!\n");

	pGI = (LPAGREPINFO)calloc(1, sizeof(AGREPINFO));
/*	pGI = &aGI;	*/

	/* Level 1 */
	/***********/
	CHECK( AGrepInit(pGI), TRUE, "init" );
	
	// k=0 mismatch...
	CHECK( CompileAGrep((LPCSTR)test[1], 0, TRUE, pGI), AGERR_NO_ERROR, "cmp0" );
	// ...0 matche(s)
	CHECK( AGrep((LPCSTR)test[2], pGI), 0, "ag0" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );

	// k=1 mismatch...
	CHECK( CompileAGrep((LPCSTR)test[1], 1, TRUE,  pGI), AGERR_NO_ERROR, "cmp1" );
	// ...1 matche(s)
	CHECK( AGrep((LPCSTR)test[2], pGI), 1, "ag1" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );

	// k=1 mismatch, but no case...
	CHECK( CompileAGrep((LPCSTR)test[1], 1, FALSE, pGI), AGERR_NO_ERROR, "cmp2" );
	// ...2 matche(s)
	CHECK( AGrep((LPCSTR)test[2], pGI), 2, "ag2" );
	CHECK( AGrepSubsBuild("-&-", pSubs, 30, pGI), AGERR_NO_ERROR, "su0" );
	CHECK( strcmp(pSubs,"-include-"), 0, "su1" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );

	// ElectUnltd bug?
	CHECK( CompileAGrep((LPCSTR)"Bob", 5, FALSE, pGI), AGERR_NO_ERROR, "cmp2" );
	//fprintf( stderr, "%3d", AGrep((LPCSTR)"Ben", pGI) );
	//fprintf( stderr, "%3d", AGrep((LPCSTR)test[2], pGI) );
	//fprintf( stderr, "%3d", AGrep((LPCSTR)"Ben a alors, tiens !", pGI) );
	CHECK( AGrep((LPCSTR)"Ben", pGI), 3, "eu1" );
	CHECK( AGrep((LPCSTR)test[2], pGI), 14, "eu2" );
	CHECK( AGrep((LPCSTR)"Ben a alors, tiens !", pGI), 21, "eu3" );
#define	LONGUEUR	2300
	pTemp = (char*)calloc(LONGUEUR,sizeof(char));
	if( pTemp==NULL )
		fprintf(stderr, "!");
	else {
		for( iVal=0; iVal<LONGUEUR-1; iVal++ )
			pTemp[iVal] = '!';
		pTemp[LONGUEUR-1]='\0';
		/*fprintf(stderr,"*");*/
		CHECK( AGrep((LPCSTR)pTemp, pGI), (int)strlen(pTemp), "eu4" );
	}
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );

	CHECK( CompileAGrep((LPCSTR)"Bob", 1, FALSE, pGI), AGERR_NO_ERROR, "cmp2" );
	CHECK( AGrep((LPCSTR)pTemp, pGI), 0, "eu5" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );
	free(pTemp);

	// January bug check
	CHECK( CompileAGrep((LPCSTR)test[3], 0, TRUE, pGI), AGERR_NO_ERROR, "cmp3" );
	CHECK( AGrep((LPCSTR)test[4], pGI), 2, "to1" );
	CHECK( AGrep((LPCSTR)test[5], pGI), 3, "to2" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );
	CHECK( CompileAGrep((LPCSTR)test[4], 0, TRUE, pGI), AGERR_NO_ERROR, "cmp4" );
	CHECK( AGrep((LPCSTR)test[5], pGI), 2, "to3" );
	CHECK( AGrepEmpty(pGI), TRUE, "emp" );

	// Feb AEK.XL bug check
	CHECK( CompileAGrep((LPCSTR)test[0], 0, FALSE, pGI), AGERR_NO_ERROR, "cmp5" );
	CHECK( AGrep((LPCSTR)test[2], pGI), 2, "axl1" );

	free(pGI);

	/* Level 2 */
	/***********/
	CHECK( SAGrepInit(), TRUE, "s1" );
	CHECK( SCompileAGrep((LPCSTR)test[1], 0, TRUE), AGERR_NO_ERROR, "s2" );
	CHECK( SAGrep((LPCSTR)test[2]), 0, "s3" );
	CHECK( SAGrepEmpty(), TRUE, "s4" );
	CHECK( SCompileAGrep((LPCSTR)test[1], 1, TRUE), AGERR_NO_ERROR, "s5" );
	CHECK( SAGrep((LPCSTR)test[2]), 1, "s6" );
	CHECK( SAGrepEmpty(), TRUE, "s7" );
	CHECK( SCompileAGrep((LPCSTR)test[1], 1, FALSE), AGERR_NO_ERROR, "s8" );
	CHECK( SAGrep((LPCSTR)test[2]), 2, "s9" );
	CHECK( SAGrepSubsBuild("-&-", pSubs, 30), AGERR_NO_ERROR, "s10" );
	CHECK( strcmp(pSubs,"-include-"), 0, "s11" );
	CHECK( SAGrepEmpty(), TRUE, "s12" );
	CHECK( SCompileAGrep((LPCSTR)"Bob", 5, FALSE), AGERR_NO_ERROR, "s13" );
	CHECK( SAGrep((LPCSTR)"Ben"), 3, "s14" );
	CHECK( SAGrep((LPCSTR)test[2]), 14, "s15" );
	CHECK( SAGrep((LPCSTR)"Ben a alors, tiens !"), 21, "s16" );
#define	LONGUEUR	2300
	pTemp = (char*)calloc(LONGUEUR,sizeof(char));
	if( pTemp==NULL )
		fprintf(stderr, "!");
	else {
		for( iVal=0; iVal<LONGUEUR-1; iVal++ )
			pTemp[iVal] = '!';
		pTemp[LONGUEUR-1]='\0';
		/*fprintf(stderr,"*");*/
		CHECK( SAGrep((LPCSTR)pTemp), (int)strlen(pTemp), "s17" );
	}
	CHECK( SAGrepEmpty(), TRUE, "s18" );
	CHECK( SCompileAGrep((LPCSTR)"Bob", 1, FALSE), AGERR_NO_ERROR, "s19" );
	CHECK( SAGrep((LPCSTR)pTemp), 0, "s20" );
	CHECK( SAGrepEmpty(), TRUE, "s21" );
	free(pTemp);
	CHECK( SCompileAGrep((LPCSTR)test[3], 0, TRUE), AGERR_NO_ERROR, "s22" );
	CHECK( SAGrep((LPCSTR)test[4]), 2, "s23" );
	CHECK( SAGrep((LPCSTR)test[5]), 3, "s24" );
	CHECK( SAGrepEmpty(), TRUE, "s25" );
	CHECK( SCompileAGrep((LPCSTR)test[4], 0, TRUE), AGERR_NO_ERROR, "s26" );
	CHECK( SAGrep((LPCSTR)test[5]), 2, "s27" );
	CHECK( SAGrepEmpty(), TRUE, "s28" );

	/* Level 3 */
	/***********/
	pRGI = (LPRGREPINFO)calloc(1, sizeof(RGREPINFO));
	CHECK( CompileRGrep((LPCSTR)"i\\(n[Cc][Ll]+\\)u", TRUE, pRGI), AGERR_NO_ERROR, "rcp0" );
	CHECK( RGrep((LPCSTR)test[1], pRGI), 1, "rg0" );
	CHECK( CompileRGrep((LPCSTR)"inclu", FALSE, pRGI), AGERR_NO_ERROR, "rcp1" );
	CHECK( RGrep((LPCSTR)test[2], pRGI), 1, "rg1" );
	CHECK( CompileRGrep((LPCSTR)test[4], FALSE, pRGI), AGERR_NO_ERROR, "rcp2" );
	CHECK( RGrep((LPCSTR)test[2], pRGI), 0, "rg2" );
	free(pRGI);

	
	printf("\nEnding!\n");
	return 0;
}


/*
//	Some comments. Without any order...
*/

/*
//	Nobody ever reads what is in the sample source code. However, you
//	will be able to know why there is no AGREPINFO variable built in
//	an automatic variable inside main(). It would have been nice and
//	simpler than allocating it from the heap with calloc(). Well...
//	Yes but there is quite a problem with large data structures like
//	this one when they are built from the stack. E.g. with Borland C++
//	v4.0, you would have to increase manually the stack for the simplest
//	program - like this one - to operate smoothly.
//	In the original version, I was building an AGREPINFO aGI variable
//	as an automatic variable (it may still be present as a code comment),
//	but this had a too large impact on code and data size for some of the
//	memory models. See below.
*/

/*
//	You must also remember that the YGrep Search Engine is a rather large
//	set of routines and data. For real world applications it is highly
//	improbable that you will be able to use the Small or Compact memory
//	models. The data segment is too small for that.
//	This size limitation can also appear when compiling applications with
//	full debug information. E.g. Borland C++ 4.0 insisted on producing a
//	stack overflow on entering main() [before reaching the first C code
//	line.]
*/
