unit Datedemo;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, SysUtils, AdDate,
  TabNotBk, Spin;

type
  TTAdrockDatesForm = class(TForm)
    ScrollBox1: TScrollBox;
    Label56: TLabel;
    Panel2: TPanel;
    Label3: TLabel;
    WorkDateField: TEdit;
    RefreshButton: TBitBtn;
    SpinButton1: TSpinButton;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    PrevBusinessDayLabel: TLabel;
    IsHolidayLabel: TLabel;
    IsBusinessHolidayLabel: TLabel;
    NextBusinessDayLabel: TLabel;
    isBusinessDayLabel: TLabel;
    Panel3: TPanel;
    HolidaylistBox: TListBox;
    GroupBox3: TGroupBox;
    Bevel4: TBevel;
    Bevel9: TBevel;
    Bevel8: TBevel;
    Label34: TLabel;
    DaysBetweenDatesLabel: TLabel;
    Label38: TLabel;
    WeeksBetweenDatesLabel: TLabel;
    Label40: TLabel;
    MonthsBetweenDatesLabel: TLabel;
    Label42: TLabel;
    YearsBetweenDatesLabel: TLabel;
    Label36: TLabel;
    BoundryWeeksBetweenDatesLabel: TLabel;
    Label39: TLabel;
    BoundryMonthsBetweenDatesLabel: TLabel;
    Label43: TLabel;
    BoundryYearsBetweenDatesLabel: TLabel;
    Label45: TLabel;
    BoundryQuartersBetweenDatesLabel: TLabel;
    Label64: TLabel;
    QuartersBetweenDatesLabel: TLabel;
    Label4: TLabel;
    BusinessDaysBetweenDatesLabel: TLabel;
    Label31: TLabel;
    DaysAgoLabel: TLabel;
    Label33: TLabel;
    WeeksAgoLabel: TLabel;
    Label35: TLabel;
    MonthsAgoLabel: TLabel;
    Label37: TLabel;
    YearsAgoLabel: TLabel;
    Label46: TLabel;
    QuartersAgoLabel: TLabel;
    GroupBox4: TGroupBox;
    Bevel6: TBevel;
    Label22: TLabel;
    SelectedDateLabel: TLabel;
    Label23: TLabel;
    SelectedDayLabel: TLabel;
    Label25: TLabel;
    SelectedMonthLabel: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    DayOfWeekLabel: TLabel;
    DayOfYearLabel: TLabel;
    Label32: TLabel;
    Label28: TLabel;
    WeekOfYearLabel: TLabel;
    WeekOfMonthLabel: TLabel;
    Label30: TLabel;
    Label24: TLabel;
    CenturyLabel: TLabel;
    Quarter: TLabel;
    QuarterLabel: TLabel;
    Label29: TLabel;
    DayThLabel: TLabel;
    Label41: TLabel;
    DelphiDayOfWeekLabel: TLabel;
    Label44: TLabel;
    Label1: TLabel;
    DaysLeftInYearLabel: TLabel;
    Label63: TLabel;
    DayOfMonthLabel: TLabel;
    Label65: TLabel;
    Label62: TLabel;
    DaysLeftInMonthLabel: TLabel;
    SelectedYearLabel: TLabel;
    GroupBox6: TGroupBox;
    Label51: TLabel;
    AddDateLabel: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    DateDiffLabel: TLabel;
    SelectedDatelabel1: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    Label66: TLabel;
    AddDateType: TEdit;
    AddDateNumber: TEdit;
    DateDiffType: TEdit;
    UpdateAddDateButton: TBitBtn;
    UpdateDateDiffButton: TBitBtn;
    GroupBox1: TGroupBox;
    Label48: TLabel;
    SelectedDatePlus1DayLabel: TLabel;
    Label50: TLabel;
    Label47: TLabel;
    Label54: TLabel;
    SelectedDatePlus1WeekLabel: TLabel;
    SelectedDatePlus1MonthLabel: TLabel;
    SelectedDatePlus1YearLabel: TLabel;
    Label49: TLabel;
    SelectedDateMinus1DayLabel: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label55: TLabel;
    SelectedDateMinus1WeekLabel: TLabel;
    SelectedDateMinus1MonthLabel: TLabel;
    SelectedDateMinus1YearLabel: TLabel;
    Bevel5: TBevel;
    Panel1: TPanel;
    Label14: TLabel;
    Label13: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    Label20: TLabel;
    Label11: TLabel;
    Label5: TLabel;
    Label74: TLabel;
    Label80: TLabel;
    Label82: TLabel;
    Label84: TLabel;
    Label92: TLabel;
    Label93: TLabel;
    Label94: TLabel;
    Panel4: TPanel;
    GroupBox5: TGroupBox;
    VerbalLabel: TLabel;
    GroupBox7: TGroupBox;
    Bevel2: TBevel;
    Bevel1: TBevel;
    Bevel3: TBevel;
    Label10: TLabel;
    isMondayLabel: TLabel;
    Label12: TLabel;
    isWednesdayLabel: TLabel;
    Label15: TLabel;
    isThursdayLabel: TLabel;
    Label17: TLabel;
    isSaturdayLabel: TLabel;
    Label19: TLabel;
    isSundayLabel: TLabel;
    Label21: TLabel;
    isWeekendLabel: TLabel;
    Label69: TLabel;
    isWeekDayLabel: TLabel;
    Label71: TLabel;
    IsFridaylabel: TLabel;
    Label73: TLabel;
    isTuesdayLabel: TLabel;
    Label75: TLabel;
    isChristmasDayLabel: TLabel;
    Label77: TLabel;
    isNewYearsDayLabel: TLabel;
    Label79: TLabel;
    isJanuaryLabel: TLabel;
    Label81: TLabel;
    isMarchLabel: TLabel;
    Label83: TLabel;
    isFebruarylabel: TLabel;
    Label67: TLabel;
    Label88: TLabel;
    Label89: TLabel;
    Label90: TLabel;
    Label91: TLabel;
    Label68: TLabel;
    Label85: TLabel;
    Label86: TLabel;
    Label87: TLabel;
    isAprilLabel: TLabel;
    isMayLabel: TLabel;
    isJulylabel: TLabel;
    isAugustLabel: TLabel;
    isSeptemberLabel: TLabel;
    isOctoberLabel: TLabel;
    IsDecemberLabel: TLabel;
    isNovemberLabel: TLabel;
    isJuneLabel: TLabel;
    Bevel7: TBevel;
    Label70: TLabel;
    Label72: TLabel;
    FirstOfAWeekLabel: TLabel;
    Label78: TLabel;
    LastOfAWeekLabel: TLabel;
    Label76: TLabel;
    Label95: TLabel;
{    procedure UpdateAddDateButtonClick(Sender: TObject);}
    procedure FormCreate(Sender: TObject);
    procedure UpdateDateDiffButtonClick(Sender: TObject);
    procedure RefreshButtonClick(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure UpdateAddDateButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Function ReturnYesNo(State : Boolean) : String;
    procedure Refresh;
  end;

var
  TAdrockDatesForm: TTAdrockDatesForm;
  CellsImage  : Array [1..42] of String;
  Cells       : Array [1..42] of String;

implementation

{$R *.DFM}



procedure TTAdrockDatesForm.FormCreate(Sender: TObject);
Var
  Pos : Integer;
begin
  WorkDateField.Text := DateToStr(Date);
  Refresh;
end;



procedure TTAdrockDatesForm.Refresh;
Var
 WorkDate : TDateTime;
begin
  if (IsEmptyDate(WorkDateField.text) = TRUE) then
   begin
    MessageDlg('You must specify a date, please enter a valid date!', mtWarning, [mbOK],0);
    exit;
   end;

 if (IsValidDate(WorkDateField.text) = FALSE) then
   begin
    MessageDlg('The date "'+WorkDateField.Text+'" is not a date that can be recognised, please re-enter a valid date!',
      mtWarning, [mbOK],0);
    exit;
   end;

     { The functions that are using 2 mean that the starting ssay of the week is a }
     { monday, Since 1=Sunday, 2=Monday, etc.. }

     { Set the holiday string list.This string list contains dates that refer to holidays, the IsHoliday function uses
       the holiday list if it is found to test for holidays, and the business functions except for IsBusinessDay also
       use the holidays string list, it is has been defined.
     }
     SetHolidayStringList(HolidaylistBox.Items);

     WorkDate := StrToDate(WorkDateField.text);
     SelectedDateLabel.Caption := DateToStr(WorkDate);
     SelectedDayLabel.Caption := IntToStr(ReturnDayOfMonth(WorkDate));
     SelectedMonthLabel.Caption := IntToStr(ReturnMonth(WorkDate));
     SelectedYearLabel.Caption := IntToStr(ReturnYear(WorkDate));

     DayOfWeekLabel.Caption := IntToStr(ReturnDayOfWeek(2, WorkDate))+
                            ', '+ReturnWeekDayName(2,
                             ReturnDayOfWeek(2, WorkDate));

     DelphiDayOfWeekLabel.Caption := IntToStr(ReturnDelphiDayOfWeek(2,
        ReturnDayOfWeek(2, WorkDate)));

     DayOfYearLabel.Caption := IntToStr(ReturnDayOfYear(WorkDate));
     DaysLeftInyearLabel.Caption := IntToStr(DaysLeftInyear(WorkDate));
     DayOfMonthLabel.Caption := IntToStr(ReturnDayOfMonth(WorkDate));
     DaysLeftInMonthLabel.Caption := IntToStr(DaysLeftInMonth(WorkDate));
     WeekOfMonthLabel.Caption := IntToStr(ReturnWeekofMonth(2, WorkDate));
     WeekOfYearLabel.Caption := IntToStr(ReturnWeekofYear(2, WorkDate));
     QuarterLabel.Caption := IntToStr(ReturnQuarter(WorkDate));
     CenturyLabel.Caption := IntToStr(ReturnCentury(WorkDate));

     DayThLabel.Caption := ReturnDayTh(WorkDate)+',  '+
       IntToStr(ReturnDayOfMonth(WorkDate))+
       ReturnDayTh(WorkDate);

     DaysAgoLabel.Caption := ReturnDaysAgo(WorkDate);
     WeeksAgoLabel.Caption := ReturnWeeksAgo(2, WorkDate);
    MonthsAgoLabel.Caption := ReturnMonthsAgo(WorkDate);
     QuartersAgoLabel.Caption := ReturnQuartersAgo(WorkDate);
     YearsAgoLabel.Caption := ReturnYearsAgo(WorkDate);

     DaysBetweenDatesLabel.Caption := IntToStr(ReturnDaysBetweenDates(WorkDate, Date));
     BusinessDaysBetweenDatesLabel.Caption :=
         IntToStr(ReturnBusinessDaysBetweenDates(WorkDate, Date));
     WeeksBetweenDatesLabel.Caption := IntToStr(ReturnWeeksBetweenDates(WorkDate, Date));
     MonthsBetweenDatesLabel.Caption := IntToStr(ReturnMonthsBetweenDates(WorkDate, Date));
     QuartersBetweenDatesLabel.Caption := IntToStr(ReturnQuartersBetweenDates(WorkDate, Date));
     YearsBetweenDatesLabel.Caption := IntToStr(ReturnYearsBetweenDates(WorkDate, Date));

     BoundryWeeksBetweenDatesLabel.Caption :=
         IntToStr(ReturnBoundaryWeeksBetweenDates(2, WorkDate, Date));
     BoundryMonthsBetweenDatesLabel.Caption :=
         IntToStr(ReturnBoundaryMonthsBetweenDates(WorkDate, Date));
     BoundryQuartersBetweenDatesLabel.Caption :=
         IntToStr(ReturnBoundaryQuartersBetweenDates(WorkDate, Date));
     BoundryYearsBetweenDatesLabel.Caption :=
         IntToStr(ReturnBoundaryYearsBetweenDates(WorkDate, Date));

     SelectedDatelabel1.Caption      := DateToStr(Date);
     SelectedDatePlus1DayLabel.Caption    := DateToStr(AddDays(1, WorkDate));
     SelectedDatePlus1WeekLabel.Caption   := DateToStr(AddWeeks(1, WorkDate));
     SelectedDatePlus1MonthLabel.Caption  := DateToStr(AddMonths(1, WorkDate));
     SelectedDatePlus1YearLabel.Caption   := DateToStr(AddYears(1, WorkDate));

     SelectedDateMinus1DayLabel.Caption    := DateToStr(AddDays(-1, WorkDate));
     SelectedDateMinus1WeekLabel.Caption   := DateToStr(AddWeeks(-1, WorkDate));
     SelectedDateMinus1MonthLabel.Caption  := DateToStr(AddMonths(-1, WorkDate));
     SelectedDateMinus1YearLabel.Caption   := DateToStr(AddYears(-1, WorkDate));

     isBusinessDayLabel.Caption                 := ReturnYesNo(IsBusinessDay(WorkDate));
     IsHolidayLabel.Caption                     := ReturnyesNo(IsHoliday(WorkDate));
     isBusinessHolidayLabel.Caption             := ReturnyesNo(isBusinessHoliday(WorkDate));

     isMondayLabel.Caption                 := ReturnYesNo(IsMonday(WorkDate));
     isTuesdayLabel.Caption                := ReturnYesNo(IsTuesday(WorkDate));
     isWednesdayLabel.Caption              := ReturnYesNo(IsWednesday(WorkDate));
     isThursdayLabel.Caption               := ReturnYesNo(IsThursday(WorkDate));
     isFridayLabel.Caption                 := ReturnYesNo(IsFriday(WorkDate));
     isSaturdayLabel.Caption               := ReturnYesNo(IsSaturday(WorkDate));
     isSundayLabel.Caption                 := ReturnYesNo(IsSunday(WorkDate));

     isWeekendLabel.Caption                := ReturnYesNo(IsWeekend(WorkDate));
     isWeekdayLabel.Caption                := ReturnYesNo(IsWeekday(WorkDate));

     isChristmasDayLabel.Caption           := ReturnYesNo(IsChristmasDay(WorkDate));
     isNewYearsDayLabel.Caption            := ReturnYesNo(IsNewYearsDay(WorkDate));

     isJanuaryLabel.Caption                := ReturnYesNo(IsJanuary(WorkDate));
     isFebruaryLabel.Caption               := ReturnYesNo(IsFebruary(WorkDate));
     isMarchLabel.Caption                  := ReturnYesNo(IsMarch(WorkDate));
     isAprilLabel.Caption                  := ReturnYesNo(IsApril(WorkDate));
     isMayLabel.Caption                    := ReturnYesNo(IsMay(WorkDate));
     isJuneLabel.Caption                   := ReturnYesNo(IsJune(WorkDate));
     isJulyLabel.Caption                   := ReturnYesNo(IsJuly(WorkDate));
     isAugustLabel.Caption                 := ReturnYesNo(IsAugust(WorkDate));
     isSeptemberLabel.Caption              := ReturnYesNo(IsSeptember(WorkDate));
     isOctoberLabel.Caption                := ReturnYesNo(IsOctober(WorkDate));
     isNovemberLabel.Caption               := ReturnYesNo(IsNovember(WorkDate));
     isDecemberLabel.Caption               := ReturnYesNo(IsDecember(WorkDate));

     NextBusinessDayLabel.Caption := DateToStr(NextBusinessDay(WorkDate));
     PrevBusinessDayLabel.Caption := DateToStr(PrevBusinessDay(WorkDate));

     VerbalLabel.Caption := VerbalDate(WorkDate);

     FirstOfAWeekLabel.Caption := DateToStr(ReturnFirstOfAWeek(2, WorkDate));
     LastOfAWeekLabel.Caption  := DateToStr(ReturnLastOfAWeek(2, WorkDate));

     UpdateAddDateButtonClick(Self);
     UpdateDateDiffButtonClick(Self);
end;

Function TTAdrockDatesForm.ReturnYesNo(State : Boolean) : String;
begin
 if (State = TRUE) then
   Result := 'Yes'
 else
   Result := 'No';
end;

procedure TTAdrockDatesForm.UpdateDateDiffButtonClick(Sender: TObject);
begin
  SetHolidayStringList(HolidayListBox.Items);
  DateDiffLabel.Caption := IntToStr(DateDiff(DateDiffType.Text, 2, StrToDate(WorkDateField.Text),Date));
end;


procedure TTAdrockDatesForm.RefreshButtonClick(Sender: TObject);
begin
     Refresh;
end;

procedure TTAdrockDatesForm.SpinButton1DownClick(Sender: TObject);
begin
     WorkDateField.Text := DateToStr(StrToDate(WorkDateField.Text)-1);
     Refresh;
end;

procedure TTAdrockDatesForm.SpinButton1UpClick(Sender: TObject);
begin
     WorkDateField.Text := DateToStr(StrToDate(WorkDateField.Text)+1);
     Refresh;
end;

procedure TTAdrockDatesForm.UpdateAddDateButtonClick(Sender: TObject);
begin
  AddDateLabel.Caption :=DateToStr(AddDate(AddDateType.Text, StrToInt(AddDateNumber.Text),
    StrToDate(WorkDateField.Text)));
end;

end.

