unit FDBUpdate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CGIEng, CGIUtl, CgiDBUtl, DB, DBTables;

type
  TForm1 = class(TForm)
    CGIDBGrid1: TCGIDBGrid;
    CGIMaster1: TCGIMaster;
    CGIEngine1: TCGIEngine;
    Table1: TTable;
    Table1Name: TStringField;
    Table1Diff: TFloatField;
    Table1Bid: TFloatField;
    Table1Ask: TFloatField;
    Table1Pay: TFloatField;
    Table1Date: TDateField;
    procedure CGIEngine1CGIRequest(Sender: TObject);
    procedure CGIMaster1HtmlBody;
    procedure CGIDBGrid1CustomiseRow(Sender: TObject; var TextColor,
      BGColor: TColor);
    procedure CGIDBGrid1CustomiseField(Sender: TObject; Field: TField;
      var FieldString, Link: string; var TextColor, BGColor: TColor;
      var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
  private
    { Private declarations }
    function ReplaceChars(S : String;FromChar,ToChar : Char ):String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.ReplaceChars(S : String;FromChar,ToChar : Char ):String;
var I : Integer;
begin
  for I:=1 to Length(S) do
    if S[I]=FromChar then
      S[I]:=ToChar;
  result:=S;
end;


procedure TForm1.CGIEngine1CGIRequest(Sender: TObject);
begin
  CGIMaster1.Put;
end;

procedure TForm1.CGIMaster1HtmlBody;
var
  S : String;
begin
  with CGIEngine1 do
  begin
    PutLine('To run this application you have to create an alias named "CGITestDB" pointing at the path where the shares.db file is situated.<BR><BR>');
    PutLine('<CENTER>');
    S:=AnsiUpperCase(CGIQueryString);
    if S>'' then
    begin
      S:=ReplaceChars(S,'_',' ');
      Table1.FindKey([S]);
      PutLine('<TABLE BORDER CELLSPACING=10><TR><TD><BR>');
      PutLine('<FORM METHOD=POST ACTION="dbupdate.exe?">');
      PutLine('Name :<B> '+S+'</B><BR><BR>');
      PutLine('<INPUT NAME="NAME" ALIGN=LEFT TYPE=hidden VALUE="'+S+'">');
      PutLine('Diff : <INPUT NAME="DIFF" ALIGN=LEFT TYPE=text VALUE="'+Table1Diff.AsString+'" SIZE=5 MAXLENGTH=10>');
      PutLine('   Bid : <INPUT NAME="BID" ALIGN=LEFT TYPE=text VALUE="'+Table1BID.AsString+'" SIZE=6 MAXLENGTH=10>');
      PutLine('   Ask : <INPUT NAME="ASK" ALIGN=LEFT TYPE=text VALUE="'+Table1ASK.AsString+'" SIZE=6 MAXLENGTH=10>');
      PutLine('   Pay : <INPUT NAME="PAY" ALIGN=LEFT TYPE=text VALUE="'+Table1PAY.AsString+'" SIZE=6 MAXLENGTH=10><BR><BR>');
      PutLine('<CENTER><INPUT NAME="UPDATE" TYPE=submit SIZE=20 VALUE="Update record"><CENTER>');
      PutLine('</FORM>');
      PutLine('</TD></TR></TABLE><BR>');
    end
    else
    begin
      if GetFormString('UPDATE')='Update record' then
      begin
        try
          PutLine('RecordUpdated');
          Table1.FindKey([GetFormString('NAME')]);
          Table1.Edit;
          Table1Diff.Value:=StrToFloat(GetFormString('DIFF'));
          Table1Bid.Value:=StrToFloat(GetFormString('BID'));
          Table1Ask.Value:=StrToFloat(GetFormString('ASK'));
          Table1Pay.Value:=StrToFloat(GetFormString('PAY'));
          Table1.Post;
        except
          PutLine('Illgal input');
          Table1.Cancel;
        end;
      end;
      CGIDBGrid1.Put;
    end;
    PutLine('</CENTER>');
  end;
end;


procedure TForm1.CGIDBGrid1CustomiseRow(Sender: TObject; var TextColor,
  BGColor: TColor);
begin
  if Table1.FieldByName('Diff').AsFloat>0 then
    TextColor:=clBlue
  else if Table1.FieldByName('Diff').AsFloat<0 then
    TextColor:=clRed;
end;

procedure TForm1.CGIDBGrid1CustomiseField(Sender: TObject; Field: TField;
  var FieldString, Link: string; var TextColor, BGColor: TColor;
  var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
begin
  if Field.FieldName='Name' then
  begin
    Link:='dbUpdate.exe?'+ReplaceChars(FieldString,' ','_');
    FontSize:=fsSize5;
  end;
end;

end.
