unit controlr;

(*

A Delphi 2.0 component that represents an
industrial process controller.

Version 1.0
April 20, 1997

Mark S. Bohn
Compuserve 75051,3240

*)

interface

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  ExtCtrls,StdCtrls,Buttons;

type

  TController = class(TCustomPanel)
  private
    { Private declarations }
    fLEDPanel:TPanel;
    fspVal:TLabel;
    fpvVal:TLabel;
    fspLabel:TLabel;
    fpvLabel:TLabel;
    fcaptionLabel:Tlabel;
    fupButton:TSpeedButton;
    fdnButton:TSpeedButton;
    fmodeButton:TSpeedButton;
    fRepeatTimer:TTimer;
    fChangeTimer:TTimer;
    fUpButtonPushed:boolean;
    fIncCounter:integer;
    fspIncrement:double;
    fMaxSp:double;
    fMinSp:double;
    fPV:double;
    fSP:double;
    fDigits:integer;
    fCaption:string;
    fLEDColor:TColor;
    fOnModeClick:TNotifyEvent;
    fOnChange:TNotifyEvent;
    procedure ResizeSubcomponents;
    procedure SetPV(value:double);
    procedure SetSP(value:double);
    procedure SetCaption(value:string);
    procedure SetDigits(value:integer);
    procedure SetLEDColor(value:Tcolor);
    procedure TimerExpired(sender:Tobject);
    procedure ButtonUp (Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
    procedure ButtonDown (Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
    procedure ButtonClick(Sender:TObject);

  protected
    { Protected declarations }
    procedure Resize;override;
    procedure Paint;override;
    procedure Loaded;override;
    procedure ModeClick(sender:TObject);
    procedure Change(sender:Tobject);
  public
    { Public declarations }
    constructor Create(AOwner:Tcomponent);override;
    destructor Destroy;override;

  published
    { Published declarations }
    property Align;
    property Enabled;
    property ShowHint;
    property PopupMenu;
    property TabOrder;
    property Visible;
    property SPincrement:double read fsPincrement write fspIncrement ;
    property MaxSp:double read fMaxSp write fMaxSp ;
    property MinSp:double read fMinSp write fMinSp ;
    property PV:double read fPV write SetPV;
    property SP:double read fSP write SetSP;
    property Caption:string read fCaption write SetCaption;
    property Digits:integer read fDigits write SetDigits default 1;
    property LEDColor:TColor read fLEDColor write SetLEDColor default clRed;

    property OnModeClick:TNotifyEvent read fOnModeClick write fOnModeClick;
    property OnChange:TNotifyEvent read fOnChange write fOnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnMouseDown;
    property OnMouseUp;
    property Color;
  end;

  const MinWidth=90;
        MaxWidth=400;
procedure Register;

implementation
{$R controlr.res}

  constructor TController.Create(Aowner:Tcomponent);
  begin
    inherited Create(Aowner);
    width:=MinWidth;
    height:=MinWidth;
    Digits:=1;
    caption:='caption';

    fLEDPanel:=TPanel.Create(self);
    with fLEDPanel do
    begin
      parent:=self;
      visible:=true;
      left:=3;top:=3;
      color:=clblack;
      bevelInner:=bvRaised;
      bevelOuter:=bvRaised;
    end;

    fUpButton:=TSpeedButton.create(self);
    with fUpButton do
    begin
      parent:=self;
      visible:=true;
      setbounds(10,75,20,20);
      enabled:=true;
      numglyphs:=1;
      glyph.handle:=loadBitmap(Hinstance,'arrowup');
      OnMouseUp:=ButtonUp;
      OnMouseDown:=ButtonDown;
      OnClick:=ButtonClick;
    end;

    fDnButton:=TSpeedButton.create(self);
    with fDnButton do
    begin
      parent:=self;
      visible:=true;
      setbounds(70,75,20,20);
      enabled:=true;
      numglyphs:=1;
      glyph.handle:=loadBitmap(Hinstance,'arrowdn');
      OnMouseUp:=ButtonUp;
      OnMouseDown:=ButtonDown;
      OnClick:=ButtonClick;
    end;


    fModeButton:=TSpeedButton.create(self);
    with fModeButton do
    begin
      parent:=self;
      visible:=true;
      setbounds(40,75,20,20);
      enabled:=true;
      numglyphs:=1;
      glyph.handle:=loadBitmap(Hinstance,'ctlmode');
      OnClick:=ModeClick;
    end;

    fspLabel:=TLabel.create(self);
    with fspLabel do
    begin
      parent:=fLEDPanel;
      visible:=true;
      color:=clBlack;
      font.color:=clWhite;
      font.name:='Times New Roman';
      Font.Style := [];
      caption:='sp';
    end;

    fpvLabel:=TLabel.create(self);
    with fpvLabel do
    begin
      parent:=fLEDPanel;
      visible:=true;
      font.color:=clWhite;
      font.name:='Times New Roman';
      Font.Style := [];
      font.color:=clWhite;
      caption:='pv';
    end;

    fCaptionLabel:=TLabel.create(self);
    with fCaptionLabel do
    begin
      parent:=fLEDPanel;
      visible:=true;
      font.name:='Times New Roman';
      Font.Style := [];
      font.color:=clBlack;
      fCaptionLabel.Alignment:=taCenter;
      fCaptionLabel.align:=alBottom;
      caption:='controller';
    end;

    fspVal:=TLabel.create(self);
    with fspVal do
    begin
      parent:=fLEDPanel;
      visible:=true;
      font.color:=clblack;
      font.name:='Times New Roman';
      Font.Style := [fsbold];
      font.color:=cllime;
      caption:='200.0';
      alignment:=taRightJustify;
    end;

    fpvVal:=TLabel.create(self);
    with fpvVal do
    begin
      parent:=fLEDPanel;
      visible:=true;
      font.color:=clblack;
      font.name:='Times New Roman';
      Font.Style := [fsbold];
      font.color:=cllime;
      caption:='201.1';
      alignment:=taRightJustify;
    end;

    SP:=0.0;
    PV:=0.0;
    SPincrement:=1.0;
    LEDcolor:=clRed;
    MaxSP:=100.0;
    MinSP:=0.0;
    ResizeSubcomponents;

  end;

  destructor TController.Destroy;
  begin
    inherited Destroy;
  end;

  procedure TController.Loaded;
  begin
    inherited Loaded;
    Resize;
  end;

  procedure TController.ResizeSubcomponents;
  var butWidth:integer;
  begin
    fLEDPanel.width:=width-6;
    fLEDPanel.height:=height*2 div 3;
    fUpButton.left:=height div 10;
    fUpButton.top:=3 + height div 25+2*height div 3;
    butWidth:=height div 5;
    if butWidth<16 then butWidth:=16;
    fUpButton.width:=butWidth;
    fUpButton.height:=butWidth;
    fDnButton.left:=7*height div 10;
    fDnButton.top:=fUpButton.top;
    fDnButton.width:=butWidth;
    fDnButton.height:=butWidth;
    fModeButton.left:=4*height div 10;
    fModeButton.top:=fUpButton.top;
    fModeButton.width:=butWidth;
    fModeButton.height:=butWidth;
    fspLabel.font.height:=-16*width div 100;
    fspLabel.left:=10 * width div 100;
    fspLabel.top:=7 * width div 100;
    fpvLabel.font.height:=fspLabel.font.height;
    fpvLabel.top:=26 * width div 100;
    fpvlabel.left:=fsplabel.left;
    fspval.font.height:=-16*width div 100;
    fspval.left:=30 * width div 100;
    fspval.top:=7 * width div 100;
    fspval.width:=112*width div 200;
    fpvval.font.height:=fspval.font.height;
    fpvval.top:=26 * width div 100;
    fpvval.left:=fspval.left;
    fpvval.width:=fspval.width;
    fCaptionLabel.font.height:=-14*width div 100;;
    fCaptionLabel.top:=47*width div 100;
    fCaptionLabel.left:=2;
    fCaptionLabel.width:=width-5;
  end;

  procedure TController.Resize;
  begin
    if width<MinWidth then
    begin
      width:=MinWidth;
      height:=MinWidth;
      exit;
    end;
    if width>MaxWidth then
    begin
      width:=MaxWidth;
      height:=MaxWidth;
      exit;
    end;
    height:=width;
    inherited Resize;
    ResizeSubComponents;
  end;

  procedure TController.Paint;
  begin
    fCaptionLabel.color:=color;
    inherited;
  end;

  procedure TController.SetPV(value:double);
  begin
    fPV:=value;
    fpvval.caption:=floattostrf(value,fffixed,6,Digits);
  end;

  procedure TController.SetSP(value:double);
  begin
    fSP:=value;
    fSPval.caption:=floattostrf(value,fffixed,6,Digits);
  end;

  procedure TController.SetCaption(value:string);
  begin
    if value<>fCaptionLabel.caption then
    begin
      fCaptionLabel.caption:=value;
      fCaption:=value;
    end;
  end;

  procedure TController.SetDigits(value:integer);
  begin
    if fDigits<>value then
    begin
      if (value<0) or (value>3) then exit;
      fDigits:=value;
      SetSP(fSP);
      SetPV(fPV);
    end;
  end;

  procedure TController.SetLEDColor(value:Tcolor);
  begin
    if fLEDColor<>value then
    begin
      fLEDColor:=value;
      fSPval.font.color:=value;
      fPVval.font.color:=value;
    end;
  end;

  procedure TController.ButtonUp (Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
  begin
    if fRepeatTimer<>nil then fRepeatTimer.enabled:=false;

    if fChangeTimer=nil then fChangeTimer:=TTimer.Create(self);
    fChangeTimer.OnTimer:=Change;
    fChangeTimer.Interval:=500;
    fChangeTimer.enabled:=true;

  end;

  procedure TController.ButtonDown (Sender: TObject; Button: TMouseButton;
                       Shift: TShiftState; X, Y: Integer);
  begin
    fIncCounter:=0;
    if sender=fUpButton then fUpButtonPushed:=true else fUpButtonPushed:=false;
    if fChangeTimer<>nil then fChangeTimer.enabled:=false;
    if fRepeatTimer=nil then fRepeatTimer:=TTimer.Create(self);
    fRepeatTimer.OnTimer:=TimerExpired;
    fRepeatTimer.Interval:=300;
    fRepeatTimer.enabled:=true;
  end;

  procedure TController.TimerExpired(sender:Tobject);
  begin
    inc(fIncCounter);
    if fIncCounter=10 then fRepeatTimer.Interval:=fRepeatTimer.Interval div 3;
    if fIncCounter=100 then fRepeatTimer.Interval:=fRepeatTimer.Interval div 3;
    if fIncCounter=200 then fRepeatTimer.Interval:=fRepeatTimer.Interval div 3;
    if fUpButtonPushed then
    begin
      SP:=SP+SPincrement;
      if SP>MaxSP then SP:=MaxSP;
    end
    else
    begin
      SP:=SP-SPincrement;
      if SP<MinSP then SP:=MinSP;
    end;
   end;

  procedure TController.ButtonClick(Sender:TObject);
  begin
    if Sender=fUpButton then
    begin
      SP:=fSP+SPincrement;
      if fSP>MaxSP then SP:=MaxSP;
    end
    else
    begin
      SP:=fSP-SPincrement;
      if fSP<MinSP then SP:=MinSP;
    end;
  end;

  procedure TController.ModeClick(sender:TObject);
  begin
    if assigned(fOnModeClick) then fOnModeClick(self);
  end;

  procedure TController.Change(sender:Tobject);
  begin
    fChangeTimer.enabled:=false;
    if assigned(fOnChange) then fOnChange(self);
  end;

  procedure Register;
  begin
    RegisterComponents('Samples', [TController]);
  end;

end.
