{ This is my Custom About Box designed specifically for TechnoSoft }
unit Da3dlabt;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, SysUtils, Rzlabel;

type
  TDB3DLabAboutBox = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    Panel2: TPanel;
    Label8: TLabel;
    Label10: TLabel;
    UserName: TLabel;
    CompanyName: TLabel;
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    WinVersion: TLabel;
    DosVersion: TLabel;
    Coprocessor: TLabel;
    CPU: TLabel;
    Panel4: TPanel;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    FreeMemory: TLabel;
    FreeResources: TLabel;
    FreeDisk: TLabel;
    Panel5: TPanel;
    Panel6: TPanel;
    BitBtn1: TBitBtn;
    Version: TRzLabel;
    VersionNumber: TRzLabel;
    Copyright: TRzLabel;
    ProductName: TRzLabel;
    Comments: TRzLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    fileHandle: THandle;
    fileBuffer: Array [0..29] of Char;
    wVersion: Word;
    dVersion: Word;
    winFlags: LongInt;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

procedure TDB3DLabAboutBox.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TDB3DLabAboutBox.FormActivate(Sender: TObject);
begin
  { Get Win/Dos version numbers }
  wVersion := LoWord(GetVersion);
  dVersion := HiWord(GetVersion);
  WinVersion.Caption := IntToStr(LO(wVersion)) + '.' +
                        IntToStr(HI(wVersion));
  DosVersion.Caption := IntToStr(HI(dVersion)) + '.' +
                        IntToStr(LO(dVersion));

  winFlags := GetWinFlags;

  { Get math coprocessor status }
  if winFlags and WF_80x87 > 0 then
     Coprocessor.Caption := 'Present'
  else
     Coprocessor.Caption := 'Not Present';

  { Get CPU type }
  if winFlags and WF_CPU486 > 0 then
     CPU.Caption := '486 or Pentium';
  if winFlags and WF_CPU386 > 0 then
     CPU.Caption := '386';
  if winFlags and WF_CPU286 > 0 then
     CPU.Caption := '286';

  { Get free memory, resources, disk space }
  FreeMemory.Caption := IntToStr(GetFreeSpace(0) div 1000) + ' KB';
  FreeResources.Caption := IntToStr(GetFreeSystemResources(GFSR_SYSTEMRESOURCES))
                               + '%';
  FreeDisk.Caption := IntToStr(DiskFree(3) div 1000000) + ' MB';

  { Get user name and company name }
  fileHandle := LoadLibrary('USER');

  if fileHandle >= HINSTANCE_ERROR then begin
    if LoadString(fileHandle, 514, @fileBuffer, 30) <> 0 then
       UserName.Caption := fileBuffer;
    if LoadString(fileHandle, 515, @fileBuffer, 30) <> 0 then
       CompanyName.Caption := fileBuffer;
    FreeLibrary(fileHandle);
  end;
end;

end.

