unit Noini;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, DBCtrls, Grids, DBGrids, DB, DBTables, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    edDictPath: TEdit;
    edUserName: TEdit;
    Label3: TLabel;
    lstTables: TComboBox;
    btnOpenTable: TButton;
    Database: TDatabase;
    Table: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    OpenDialog: TOpenDialog;
    btnSelectDic: TButton;
    btnDict: TButton;
    procedure btnSelectDicClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnDictClick(Sender: TObject);
    procedure lstTablesClick(Sender: TObject);
    procedure lstTablesChange(Sender: TObject);
    procedure btnOpenTableClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.FormCreate(Sender: TObject);
begin
  edDictPath.Text := '';
  edUserName.Text := 'Master';
end;

procedure TForm1.btnSelectDicClick(Sender: TObject);
var i : byte;
begin
  if OpenDialog.Execute then begin
    i := pos('\FILE.DDF',OpenDialog.FileName);
    edDictPath.Text := copy (OpenDialog.FileName,1,i-1);
  end;
end;

procedure TForm1.btnDictClick(Sender: TObject);
var ls : TstringList;
begin
  try
    ls := TStringList.Create;
    ls.Add ('DDL='+edDictPath.Text);
    ls.Add ('USER NAME='+edUserName.Text);
    Database.DriverName := 'BTRIEVE';
    Database.Params := ls;
    Database.Connected := true;
  except
    ShowMessage ('Database not opened'#13);
  end;
  ls.free;
  end;

procedure TForm1.lstTablesClick(Sender: TObject);
var ls : TstringList;
begin
  ls := TStringList.Create;
  try
    Session.GetTableNames (Database.DataBaseName,
                           '*', False, False, ls);
    lstTables.Items := ls;
  except
    ShowMessage ('Dictionary not open'#13);
  end;
  ls.Free;
end;

procedure TForm1.lstTablesChange(Sender: TObject);
begin
  with lstTables do
    Text := Items.Strings[ItemIndex];
end;

procedure TForm1.btnOpenTableClick(Sender: TObject);
begin
  try
    Table.TableName := lstTables.Text;
    Table.Active := true;
  except
    Showmessage ('Table not opened.'#13);
  end;
end;

end.
