unit tblstat;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, Buttons, 
  bobase, bosupp,bofile;

type
  TTableStatus = class(TForm)
    EdRecLen: TEdit;
    Label1: TLabel;
    edPageSize: TEdit;
    edRecords: TEdit;
    Label2: TLabel;
    Label4: TLabel;
    IdxGrid: TStringGrid;
    BtnOK: TBitBtn;
    chkVariable: TCheckBox;
    chkBlankTrunc: TCheckBox;
    chkCompress: TCheckBox;
    chkKeyOnly: TCheckBox;
    chkBalIndex: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    sTableName,
    sFileName : string [80];
    { Public-Deklarationen }
    procedure SetTableName ( s : string);
    procedure SetFileName ( s : string);
    procedure SetupKeyGrid;
  end;

var
  TableStatus: TTableStatus;
  BtrHandle  : PBtrieve5File;

implementation

{$R *.DFM}

const cExtKeyType : array [0..15] of string = ('String','Integer','Float',
                                               'Date','Time','Decimal',
                                               'Money','Logical','Numeric',
                                               'BFloat','LString','ZString',
                                               '','','Unsigned','AutoInc');

procedure TTableStatus.SetTablename ( s : string);
begin
  sTableName := s;
end;

procedure TTableStatus.SetFileName (s : string);
begin
  sFileName := s;
end;

procedure TTableStatus.SetupKeyGrid;
begin
  {Key Pos Len Dup Mod Man Null Type Alt Des Case }
  with IdxGrid do begin
    Font.Name := 'Arial';
    Font.Size := 8;
    cells[0,0]:='Key';
    cells[1,0]:='Pos';
    cells[2,0]:='Len';
    cells[3,0]:='Dup';
    cells[4,0]:='Mod';
    cells[5,0]:='Man';
    cells[6,0]:='Null';
    cells[7,0]:='Type';
    cells[8,0]:='Alt';
    cells[9,0]:='Desc';
    cells[10,0]:='Case';
    colwidths[0]:=35;
    colwidths[1]:=35;
    colwidths[2]:=35;
    colwidths[3]:=35;
    colwidths[4]:=35;
    colwidths[5]:=35;
    colwidths[6]:=35;
    colwidths[7]:=90;
    colwidths[8]:=35;
    colwidths[9]:=35;
    colwidths[10]:=35;
  end;
end;

procedure TTableStatus.FormShow(Sender: TObject);
var pBTR : PBtrieve5File;
    FSR  : FileSpecRec;
    ACSName : BTVNameStr;
    ACSMap : CharMap;
    i, iKeyNr : integer;
    bShowKey : boolean;
begin
  Caption := 'Status - '+sTableName;

  pBTR := BTRHandle;
  ACSName := '';
  fillchar (ACSMap,sizeOf (ACSMap), #0);
  pBTR^.Status (FSR,ACSName, ACSMap);
  edRecLen.Text := IntToStr( pBTR^.bfRecl);
  edPageSize.Text := IntToStr (FSR.Data.PageSize);
  edRecords.Text := IntToStr (pBTR^.NrOfRecs);

  if (FSR.Data.FileFlags and VariableLength) = VariableLength then
    chkVariable.checked := true;
  if (FSR.Data.FileFlags and BlankTruncation) = BlankTruncation then
    chkBlankTrunc.checked := true;
  if (FSR.Data.FileFlags and DataCompression) = DataCompression then
    chkCompress.checked := true;
  if (FSR.Data.FileFlags and KeyOnlyFile) = KeyOnlyFile then
    chkKeyOnly.checked := true;
  if (FSR.Data.FileFlags and $0080) = $0080 then
    chkBalIndex.checked := true;

  SetupKeyGrid;

  iKeyNr := 0;
  bShowKey := true;
  for i := 1 to FSR.Data.NrIndexes do begin
    with IdxGrid do begin
      RowCount := RowCount + 1;
      if bShowKey then begin
        cells[0,i] := IntToStr (iKeyNr);
        bShowKey := false;
      end;
      cells[1,i] := IntToStr (FSR.Indexes[i-1].KeyPos);
      cells[2,i] := IntToStr (FSR.Indexes[i-1].KeyLen);
      cells [3,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and DuplicateKey) =  DuplicateKey then
        cells [3,i] := 'Yes';

      cells [4,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and ModifiableKey) = ModifiableKey then
        cells [4,i] := 'Yes';

      cells [5,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and ManualKey) = ManualKey then
        cells [5,i] := 'Yes';

      cells[6,i] := '$'+IntToStr(byte(FSR.Indexes[i-1].NullChar));

      cells[7,i] := cExtKeyType [FSR.Indexes[i-1].ExtKeyType];

      cells [8,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and AltCollKey) = AltCollKey then
        cells [8,i] := 'Yes';

      cells [9,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and DescendingKey) = DescendingKey then
        cells [9,i] := 'Yes';

      cells [10,i] := 'No';
      if (FSR.Indexes[i-1].KeyFlags and 1024) = 1024 then
        cells [10,i] := 'Yes';

      if (FSR.Indexes[i-1].KeyFlags and SegmentOfKey) <> SegmentOfKey then begin
         inc (iKeyNr);
         bShowKey := true;
      end;
    end;
  end;
  IdxGrid.Rowcount := IdxGrid.Rowcount -1; 
end;

procedure TTableStatus.FormCreate(Sender: TObject);
begin
  sTableName := '';
  sFileName := '';
end;

procedure TTableStatus.BtnOKClick(Sender: TObject);
begin
  Close;
end;

end.
