unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Graptool, GrapChrt, StdCtrls;

type
  TForm1 = class(TForm)
    GraphChart1: TGraphChart;
    Panel1: TPanel;
    ButtonSetMinMax: TButton;
    Label2: TLabel;
    EditXMin: TEdit;
    Label3: TLabel;
    EditXMax: TEdit;
    Label4: TLabel;
    EditYMin: TEdit;
    Label5: TLabel;
    EditYMax: TEdit;
    Bevel1: TBevel;
    Label1: TLabel;
    EditXvalue: TEdit;
    Label6: TLabel;
    EditYvalue: TEdit;
    ButtonAddPoint: TButton;
    LabelVersion: TLabel;
    Label7: TLabel;
    procedure ButtonAddPointClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GraphChart1XScaleText(var Text: OpenString; Value: Double);
    procedure ButtonSetMinMaxClick(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function ValueOf(const Str: string): double;
var iErr: integer;
    v: double;
begin
  v:=0;
  val(Str,v,iErr);
  ValueOf:=v;
  if iErr<>0 then v:=0;
end;

function AreaFunc1(x: double; UpperFunction: boolean): double; far;
begin
  if UpperFunction then AreaFunc1:=sqr(x-0.5)*3
                   else AreaFunc1:=sqr(x-0.5)*6;
end;

function AreaFunc2(x: double; UpperFunction: boolean): double; far;
begin
  if UpperFunction then AreaFunc2:=sqr(x-0.5)*4
                   else AreaFunc2:=sqr(x-0.5)*5;
end;

function LineFunc(x: double): double; far;
begin
  LineFunc:=sqr(x-0.5)*4.5;
end;

procedure TForm1.FormCreate(Sender: TObject);
var p: TPointItem;
    t: TTextItem;
begin
  with GraphChart1 do
    begin
      Area(AreaFunc1,clRed);
      Area(AreaFunc2,clGreen);
      Func(LineFunc,clYellow);
      Line(0,0,2,2,WorldCoordinates);
      Point(0.2,0.4,3,clBlue);
      Point(0.45,0.03,3,clBlue);
      Point(0.85,0.6,3,clBlue);
      p:=Point(10,95,3,clBlue);
      p.XScaleMode:=RelativeToWindow;
      p.YScaleMode:=RelativeToWindow;
      t:=Text(12,97,'= Individual points');
      t.XScaleMode:=RelativeToWindow;
      t.YScaleMode:=RelativeToWindow;
      LabelVersion.Caption:=VersionInfo;
    end;
end;

procedure TForm1.ButtonSetMinMaxClick(Sender: TObject);
begin
  GraphChart1.XMin:=ValueOf(EditXMin.Text);
  GraphChart1.XMax:=ValueOf(EditXMax.Text);
  GraphChart1.YMin:=ValueOf(EditYMin.Text);
  GraphChart1.YMax:=ValueOf(EditYMax.Text);
end;

procedure TForm1.ButtonAddPointClick(Sender: TObject);
begin
  GraphChart1.Point(ValueOf(EditXValue.Text),ValueOf(EditYValue.Text),3,clBlue);
end;

procedure TForm1.GraphChart1XScaleText(var Text: OpenString;
  Value: Double);
begin
  if Value=0 then Text:='zero';
  if Value=1 then Text:='one';
end;

end.
