unit ftmain;
        { BabyFTP example application for FTP control in MS Internet Control Pack;
          features graphic display of remote host directories in a List view control,
          simple control by double-clicking remote directories and single file download;
          public domain code; Alin Flaider,  1996
        }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, OleCtrls, MSICPB, StdCtrls, ComCtrls;

type
  TFtpForm = class(TForm)
    FTP: TFTP;
    StatusPanel: TPanel;
    ToolPanel: TPanel;
    ConnectBtn: TSpeedButton;
    ChDirBtn: TSpeedButton;
    GetBtn: TSpeedButton;
    DisconnectBtn: TSpeedButton;
    ImageList1: TImageList;
    Msg1: TLabel;
    Msg2: TLabel;
    Panel1: TPanel;
    HostEdit: TEdit;
    Label4: TLabel;
    Label1: TLabel;
    UserEdit: TEdit;
    PswEdit: TEdit;
    Label2: TLabel;
    Panel2: TPanel;
    FileList: TListView;
    Panel3: TPanel;
    DirLabel: TLabel;
    Label3: TLabel;
    BusyLabel: TLabel;
    procedure ConnectBtnClick(Sender: TObject);
    procedure FTPError(Sender: TObject; Number: Smallint;
      var Description: string; Scode: Integer; const Source,
      HelpFile: string; HelpContext: Integer; var CancelDisplay: Wordbool);
    procedure FTPAuthenticate(Sender: TObject);
    procedure FTPPrintDir(Sender: TObject);
    procedure FTPListItem(Sender: TObject; const Item: Variant);
    procedure FTPConnect(Sender: TObject);
    procedure DisconnectBtnClick(Sender: TObject);
    procedure FTPProtocolStateChanged(Sender: TObject;
      ProtocolState: Smallint);
    procedure ChDirBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FTPStateChanged(Sender: TObject; State: Smallint);
    procedure FTPBusy(Sender: TObject; isBusy: Wordbool);
    procedure GetBtnClick(Sender: TObject);
    procedure FTPDocOutput(Sender: TObject; const DocOutput: Variant);
  private
      ErrorOccured: boolean;
      LastDirPos: integer;
  public
    { Public declarations }
  end;

var
  FtpForm: TFtpForm;

implementation

{$R *.DFM}

procedure TFtpForm.ConnectBtnClick(Sender: TObject);
begin
   with FTP do begin
     ErrorOccured := false;
     Connect( HostEdit.Text, 21);            {wait for connection}
     while (FTP.State in [prcConnecting, prcResolvingHost, prcHostResolved]) do
       Application.ProcessMessages;
     if FTP.State <> prcConnected then exit; {Wait For Connection Response}
     while (FTP.State = prcConnected) and (FTP.ProtocolState = ftpBase) do
       Application.ProcessMessages;
     Authenticate( UserEdit.Text, PswEdit.Text );  {Answer authentication request }
     while FTP.Busy do
       Application.ProcessMessages;          {wait authentication to perform}
     if not ErrorOccured then
       FTP.PrintDir;                         {get remote directory}
     while FTP.Busy do
       Application.ProcessMessages;
     if not ErrorOccured then begin
       FileList.Items.Clear;
       FTP.List( FTP.RemoteDir);             {list remote directory content}
       LastDirPos := 1;
     end;
   end;
end;

procedure TFtpForm.FTPError(Sender: TObject; Number: Smallint;
  var Description: string; Scode: Integer; const Source, HelpFile: string;
  HelpContext: Integer; var CancelDisplay: Wordbool);
begin
  ErrorOccured := true;
  Msg2.Caption := Description;               {show error}
end;

procedure TFtpForm.FTPAuthenticate(Sender: TObject);
begin
  Msg2.Caption := FTP.ReplyString;           {show server welcome message}
  GetBtn.Enabled := true;                    {enable Change Dir and Download buttons}
  ChDirBtn.Enabled := true;
end;

procedure TFtpForm.FTPPrintDir(Sender: TObject);
begin
  DirLabel.Caption := FTP.RemoteDir;        {show current remote directory}
  FileList.Items.Clear;                     {prepare file list for display}
end;

procedure TFtpForm.FTPListItem(Sender: TObject; const Item: Variant);
var It: TListItem;
begin
   with  FileList.Items do if Count = 0 then begin
      It := Add;                            {first entry must be parent directory}
      It.Caption := '..';
      It.ImageIndex := 1
   end;                                     {directories first}
   if (Item.Attributes = 1) then with FileList.Items do begin
     if (LastDirPos < pred(Count)) then It := Insert(LastDirPos)
     else It := Add;
     inc(LastDirPos);
   end
   else It := FileList.Items.Add;
   with It do begin
      Caption := Item.Filename;
      if Item.Attributes = 1 then ImageIndex := 1 {directory}  
   end
end;

procedure TFtpForm.FTPConnect(Sender: TObject);
begin
   ConnectBtn.Enabled := false;
   DisconnectBtn.Enabled := true;
end;

procedure TFtpForm.DisconnectBtnClick(Sender: TObject);
begin
   FTP.Quit;                                {close FTP session}
   FileList.Items.Clear;
   DirLabel.Caption := '';
end;

procedure TFtpForm.FTPProtocolStateChanged(Sender: TObject; ProtocolState: Smallint);
begin
   case ProtocolState of                    {display session status for debug purpose}
        ftpBase: Msg2.Caption := 'Base';
        ftpAuthentication: Msg2.Caption := 'Authentication';
        ftpTransaction:    Msg2.Caption := 'Transaction';
   end;
end;

procedure TFtpForm.ChDirBtnClick(Sender: TObject);
var sdir: string;
begin
   if FTP.Busy then begin            {wait until transfer completes}
      MessageBeep( MB_ICONASTERISK);
      exit;
   end;
   if FileList.ItemFocused <> nil then begin
     if FileList.ItemFocused.Caption = '..' then sdir := '..'
     else begin
       sdir := Dirlabel.Caption;
       if sdir[length(sdir)] <> '/' then sdir := sdir +'/';
       sdir := sdir + FileList.ItemFocused.Caption;
     end
   end;
   FileList.Items.Clear;
   LastDirPos := 1;
   with FTP do begin
     if sdir = '..' then begin           {change to parent directory}
       ParentDir;
       while Busy do
         Application.ProcessMessages;
       PrintDir;                         {get current remote directory}
     end
     else ChangeDir( sdir);
     while Busy do
       Application.ProcessMessages;
     List( RemoteDir);                   {display current remote directory content}
   end
end;

procedure TFtpForm.FormCreate(Sender: TObject);
begin
   Msg1.Caption := FTP.StateString;
end;

procedure TFtpForm.FTPStateChanged(Sender: TObject; State: Smallint);
begin
   if State = prcDisconnected then begin
     ConnectBtn.Enabled := true;        {update buttons accordinglt when FTP session is closed }
     DisconnectBtn.Enabled := false;
     ChDirBtn.Enabled := false;
     GetBtn.Enabled := false;
   end;

   Msg1.Caption := FTP.StateString;
   Msg2.Caption := FTP.ReplyString;
end;

procedure TFtpForm.FTPBusy(Sender: TObject; isBusy: Wordbool);
begin
   BusyLabel.Visible := IsBusy;         {forbid Change Dir & Download while performing operation}
   ChDirBtn.Enabled := not IsBusy and (FTP.ProtocolState = ftpTransaction);
   GetBtn.Enabled := not IsBusy and (FTP.ProtocolState = ftpTransaction);
end;

procedure TFtpForm.GetBtnClick(Sender: TObject);
var SrcFile, DstFile: string;
begin
   if FileList.ItemFocused <> nil then begin
     if FileList.ItemFocused.ImageIndex = 1 then begin   {directory}
        MessageBeep( MB_ICONASTERISK);        {currently allow only file download}
        exit;
     end;
     SrcFile := Dirlabel.Caption;
     if SrcFile[length(SrcFile)] <> '/' then SrcFile:= SrcFile +'/';
     SrcFile := SrcFile + FileList.ItemFocused.Caption;
     DstFile := FileList.ItemFocused.Caption;    {current local directory}
     FTP.GetFile( SrcFile, DstFile);             {download file}
   end
end;

procedure TFtpForm.FTPDocOutput(Sender: TObject; const DocOutput: Variant);
var i,j: integer;
begin
   case FTP.Operation of
        ftpFile: begin                           {show progress}
          i := DocOutput.BytesTransferred;
          j := DocOutput.BytesTotal;
          Msg2.caption := Format( 'Transferred %d of %d bytes.', [i, j]);
        end;
        ftpList:
   end
end;

end.
