unit Ftpmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Buttons, Menus, IniFiles, agsocket, agftp,
  agTypes, StdCtrls, msUtils, agFTPCls;

type
  TFTPForm = class(TForm)
    ToolBar: TPanel;
    ConnectButton: TSpeedButton;
    DisconnectButton: TSpeedButton;
    ChDirButton: TSpeedButton;
    UpdButton: TSpeedButton;
    RetrieveFileButton: TSpeedButton;
    StoreFileButton: TSpeedButton;
    MkDirButton: TSpeedButton;
    DeleteButton: TSpeedButton;
    CancelButton: TSpeedButton;
    ExitButton: TSpeedButton;
    agFTP1: TagFTP;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Connect1: TMenuItem;
    Disconnect1: TMenuItem;
    Retrieve1: TMenuItem;
    Store1: TMenuItem;
    Cancel1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Directory1: TMenuItem;
    Change1: TMenuItem;
    ChangeUp1: TMenuItem;
    Create1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    StatusBar: TPanel;
    Header1: THeader;
    FTPListBox: TListBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    RenameButton: TSpeedButton;
    Rename1: TMenuItem;
    Delete1: TMenuItem;
    LogMemo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure About1Click(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FTPListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Header1Sized(Sender: TObject; ASection, AWidth: Integer);
    procedure RetrieveFileButtonClick(Sender: TObject);
    procedure StoreFileButtonClick(Sender: TObject);
    procedure UpdButtonClick(Sender: TObject);
    procedure MkDirButtonClick(Sender: TObject);
    procedure ChDirButtonClick(Sender: TObject);
    procedure DisconnectButtonClick(Sender: TObject);
    procedure RenameButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure agFTP1Cancel(Sender: TObject);
    procedure agFTP1Closed(Sender: TObject);
    procedure agFTP1Error(Sender: TObject; var Msg: OpenString);
    procedure agFTP1Open(Sender: TObject);
    procedure FTPListBoxDblClick(Sender: TObject);
    procedure agFTP1TransferEnd(Sender: TObject);
    procedure agFTP1TransferStart(Sender: TObject);
    procedure agFTPLineTransferred(Sender: TObject; const TheLine: String);
    procedure agFTP1TransferProgress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    IniName : string;
    FTPEntry : TagFTPDirEntry;
    TheFileSize : LongInt;
    procedure EnableControls;
    procedure DisableControls;
    procedure TransferOn;
    procedure TransferOff;
    function GetFileSize(const FileName : string) : LongInt;
    procedure UpdateFTPListBox;
  public
    { Public declarations }
  end;

var
  FTPForm: TFTPForm;

implementation

uses FtpConn, msAbout, FTPTrans;

{$R *.DFM}
{$R FTPBMP.RES}

procedure TFTPForm.EnableControls;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      if Btn.Tag=1 then Btn.Enabled:=true
      else
      if Btn.Tag>=2 then Btn.Enabled:=false;
    end;
  end;
  Directory1.Enabled:=false;
  for i:=0 to File1.Count-1 do
  begin
    if File1[i].Tag=1 then File1[i].Enabled:=true
    else
    if File1[i].Tag=2 then File1[i].Enabled:=false;
  end;
end;

procedure TFTPForm.DisableControls;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      if Btn.Tag=1 then Btn.Enabled:=false
      else
      if Btn.Tag>=2 then Btn.Enabled:=true
      else
         Btn.Enabled:=true;
    end;
  end;
  Directory1.Enabled:=true;
  for i:=0 to File1.Count-1 do
  begin
    if File1[i].Tag=1 then File1[i].Enabled:=false
    else
    if File1[i].Tag>=2 then File1[i].Enabled:=true;
  end;
end;

procedure TFTPForm.TransferOn;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  FTPListBox.Enabled:=false;
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      Btn.Enabled:=Btn.Tag=3; {Only cancel stays enabled}
    end;
  end;
  Directory1.Enabled:=false;
  for i:=0 to File1.Count-1 do
    File1[i].Enabled:=File1[i].Tag=3
end;

procedure TFTPForm.TransferOff;
begin
  FTPListBox.Enabled:=true;
  DisableControls;
end;

procedure TFTPForm.FormCreate(Sender: TObject);
begin
  EnableControls;
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    agFTP1.Server:=ReadString('Setup','Server','ftp.borland.com');
    agFTP1.UserName:=ReadString('Setup','User Name','anonymous');
    agFTP1.Password:=ReadString('Setup','Password','guest@');
    agFTP1.TransferType:=TTransferType(ReadInteger('Setup','Transfer Type',0));
    agFTP1.LogFileName:=ReadString('Setup','Log File','');
  finally
    free;
  end;
end;

procedure TFTPForm.ConnectButtonClick(Sender: TObject);
var
  Proceed : boolean;
begin
  Proceed:=false;
  with TFTPConnectDlg.Create(Self) do
  try
    ServerEdit.Text:=agFTP1.Server;
    UserNameEdit.Text:=agFTP1.UserName;
    PasswordEdit.Text:=agFTP1.Password;
    TransferTypeComboBox.ItemIndex:=Ord(agFTP1.TransferType);
    LogFileNameEdit.Text:=agFTP1.LogFileName;
    if ShowModal=mrOK then
    begin
      Proceed:=true;
      agFTP1.Server:=ServerEdit.Text;
      agFTP1.UserName:=UserNameEdit.Text;
      agFTP1.Password:=PasswordEdit.Text;
      agFTP1.TransferType:=TTransferType(TransferTypeComboBox.ItemIndex);
      agFTP1.LogFileName:=LogFileNameEdit.Text;
    end;
  finally
    Free;
  end;
  if Proceed then
  begin
    agFTP1.OpenConnection;
    UpdateFTPListBox;
  end;
end;

procedure TFTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if agFTP1.OnLine then
    agFTP1.CloseConnection;
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',agFTP1.Server);
    WriteString('Setup','User Name',agFTP1.UserName);
    WriteString('Setup','Password',agFTP1.Password);
    WriteInteger('Setup','Transfer Type',Ord(agFTP1.TransferType));
    WriteString('Setup','Log File',agFTP1.LogFileName);
  finally
    free;
  end;
end;

procedure TFTPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='agFTP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TFTPForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TFTPForm.UpdateFTPListBox;
var
  i : Integer;
begin
  FTPListBox.Clear;
  TransferOn;
  try
    agFTP1.GetDirectory;
  finally
    TransferOff;
  end;
  for i:=0 to agFTP1.Directory.Count-1 do
    FTPListBox.Items.Add(agFTP1.Directory[i].FileName);
  FTPListBox.Update;
end;

procedure TFTPForm.FTPListBoxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  Bitmap : TBitmap;
  TempRect, TempRect1 : TRect;
begin
  FTPListBox.Canvas.FillRect(Rect);
  FTPEntry:=agFTP1.Directory[Index];
  Bitmap:=TBitmap.Create;
  if FTPEntry.Kind=fkDirectory then
    Bitmap.Handle:=LoadBitmap(hInstance,'FOLDER')
  else
  if FTPEntry.Kind=fkFile then
    Bitmap.Handle:=LoadBitmap(hInstance,'FILE')
  else
  if FTPEntry.Kind=fkLink then
    Bitmap.Handle:=LoadBitmap(hInstance,'LINK');
  with TempRect1 do
  begin
    TempRect1.Left:=0;
    TempRect1.Top:=0;
    TempRect1.Right:=Bitmap.Width;
    TempRect1.Bottom:=Bitmap.Height;
  end;
  with TempRect do
  begin
    TempRect.Left:=Rect.Left+2;
    TempRect.Top:=Rect.Top;
    TempRect.Right:=TempRect.Left+Bitmap.Width;
    TempRect.Bottom:=TempRect.Top+Bitmap.Height;
  end;
  FTPListBox.Canvas.BrushCopy(TempRect,Bitmap,TempRect1,clFuchsia);
  FTPListBox.Canvas.TextOut(Rect.Left+20,Rect.Top,FTPEntry.FileName);
  FTPListBox.Canvas.TextOut(Rect.Left+Header1.SectionWidth[0]+5,Rect.Top,IntToStr(FTPEntry.Size));
  FTPListBox.Canvas.TextOut(Rect.Left+Header1.SectionWidth[0]+Header1.SectionWidth[1]+5,
    Rect.Top,DateTimeToStr(FTPEntry.Date));
  Bitmap.Free;
end;

procedure TFTPForm.Header1Sized(Sender: TObject; ASection,
  AWidth: Integer);
begin
  FTPListBox.Repaint;
end;

procedure TFTPForm.RetrieveFileButtonClick(Sender: TObject);
begin
  if FTPListBox.ItemIndex<>-1 then
  begin
    FTPEntry:=agFTP1.Directory[FTPListBox.ItemIndex];
    if (FTPEntry.FileName<>'') and (FTPEntry.Kind=fkFile) then
    begin
      SaveDialog1.FileName:=FTPEntry.FileName;
      if SaveDialog1.Execute then
      begin
        TransferOn;
        try
          TheFileSize:=FTPEntry.Size;
          agFTP1.RetrieveFile(FTPEntry.FileName,SaveDialog1.FileName);
        finally
          TransferOff;
        end;
      end;
    end;
  end;
end;

function TFTPForm.GetFileSize(const FileName : string) : LongInt;
var
  f : file;
begin
  AssignFile(f,FileName);
  Reset(f,1);
  try
    Result:=FileSize(f);
  finally
    CloseFile(f);
  end;
end;

procedure TFTPForm.StoreFileButtonClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    TransferOn;
    try
      TheFileSize:=GetFileSize(OpenDialog1.FileName);
      agFTP1.StoreFile(OpenDialog1.FileName,ExtractFileName(OpenDialog1.FileName));
    finally
      TransferOff;
    end;
    UpdateFTPListBox;
  end;
end;

procedure TFTPForm.UpdButtonClick(Sender: TObject);
begin
  agFTP1.ChangeToUpperDirectory;
  UpdateFtpListBox;
end;

procedure TFTPForm.MkDirButtonClick(Sender: TObject);
var
  DirName : string;
begin
  DirName:='';
  if InputQuery('Create Directory','Type a Name of Directory:',DirName) then
  begin
    agFTP1.MakeDirectory(DirName);
    UpdateFTPListBox;
  end;
end;

procedure TFTPForm.ChDirButtonClick(Sender: TObject);
var
  DirName : string;
begin
  DirName:='';
  if InputQuery('Change Directory','Type a Name of Directory:',DirName) then
  begin
    agFTP1.ChangeDirectory(DirName);
    UpdateFTPListBox;
  end;
end;

procedure TFTPForm.DisconnectButtonClick(Sender: TObject);
begin
  agFTP1.CloseConnection;
  EnableControls;
  FTPListBox.Clear;
end;

procedure TFTPForm.RenameButtonClick(Sender: TObject);
var
  OldName, NewName : string;
begin
  if FTPListBox.ItemIndex<>-1 then
  begin
    FTPEntry:=agFTP1.Directory[FTPListBox.ItemIndex];
    if FTPEntry.Kind=fkLink then Exit;
    OldName:=FTPEntry.FileName;
    NewName:='';
    if OldName<>'' then
    begin
      if FTPEntry.Kind=fkDirectory then
      begin
        if InputQuery('Rename','Rename directory '+OldName+' to:',NewName) then
          agFTP1.RenameFile(OldName,NewName);
      end
      else
      begin
        if InputQuery('Rename File','Rename file '+OldName+' to:',NewName) then
          agFTP1.RenameFile(OldName,NewName);
      end;
      UpdateFTPListBox;
    end;
  end;
end;

procedure TFTPForm.CancelButtonClick(Sender: TObject);
begin
  if agFTP1.RetrievingList then
    agFTP1.AbortTransfer
  else
    agFTP1.Cancel;
end;

procedure TFTPForm.DeleteButtonClick(Sender: TObject);
begin
  if FTPListBox.ItemIndex<>-1 then
  begin
    FTPEntry:=agFTP1.Directory[FTPListBox.ItemIndex];
    if FTPEntry.Kind=fkLink then Exit;
    if FTPEntry.FileName<>'' then
    begin
      if FTPEntry.Kind=fkDirectory then
        agFTP1.DeleteDirectory(FTPEntry.FileName)
      else
        agFTP1.DeleteFile(FTPEntry.FileName);
      UpdateFTPListBox;
    end;
  end;
end;

procedure TFTPForm.agFTP1Cancel(Sender: TObject);
begin
  StatusBar.Caption:='Operation has been canceled';
end;

procedure TFTPForm.agFTP1Closed(Sender: TObject);
begin
  StatusBar.Caption:='Connection closed';
end;

procedure TFTPForm.agFTP1Error(Sender: TObject; var Msg: OpenString);
begin
  StatusBar.Caption:=Msg;
end;

procedure TFTPForm.agFTP1Open(Sender: TObject);
begin
  StatusBar.Caption:='Opening connection';
end;

procedure TFTPForm.FTPListBoxDblClick(Sender: TObject);
begin
  if FTPListBox.ItemIndex<>-1 then
  begin
    FTPEntry:=agFTP1.Directory[FTPListBox.ItemIndex];
    if FTPEntry.FileName='' then exit;
    if FTPEntry.Kind=fkDirectory then
    begin
      agFTP1.ChangeDirectory(FTPEntry.FileName);
      UpdateFTPListBox;
    end
    else
    if FTPEntry.Kind=fkLink then
    begin
      try
        agFTP1.ChangeDirectory(FTPEntry.LinkPtr);
      except
        on ESocketError do
        begin
          SaveDialog1.FileName:='';
          if SaveDialog1.Execute then
          begin
            TransferOn;
            try
              agFTP1.RetrieveFile(FTPEntry.LinkPtr,SaveDialog1.FileName);
            finally
              TransferOff;
            end;
          end;
        end
        else
          raise;
      end;
    end
    else
      RetrieveFileButtonClick(Sender);
  end;
end;

procedure TFTPForm.agFTP1TransferEnd(Sender: TObject);
begin
  if TransferForm.Showing then
    TransferForm.Hide;
  if agFTP1.TransferringFile then
    MessageBeep(MB_ICONASTERISK);
  StatusBar.Caption:='';
end;

procedure TFTPForm.agFTP1TransferStart(Sender: TObject);
begin
  if agFTP1.TransferringFile then
  begin
    StatusBar.Caption:='Starting file transfer';
    TransferForm.ShowProgress(0,0);
    TransferForm.Show;
  end
  else
  if agFTP1.RetrievingList then
    StatusBar.Caption:='Retrieving directory';
end;

procedure TFTPForm.agFTPLineTransferred(Sender: TObject;
  const TheLine: String);
begin
  LogMemo.Lines.Add(TheLine);
end;

procedure TFTPForm.agFTP1TransferProgress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  if TransferForm.Showing then
    TransferForm.ShowProgress(Transferred, TheFileSize);
end;

end.
