unit TestUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, RtChkGrp, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    RtCheckGroup1: TRtCheckGroup;
    ListBox1: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    RtCheckGroup2: TRtCheckGroup;
    RtCheckGroup3: TRtCheckGroup;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    CheckBox1: TCheckBox;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    Bevel1: TBevel;
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RtCheckGroup1Click(Sender: TObject);
    procedure RtCheckGroup2Click(Sender: TObject);
    procedure RtCheckGroup3Click(Sender: TObject);
    procedure RtCheckGroup1Check(Sender: TObject; Index: Integer;
      var Value: Boolean);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RtCheckGroup3DrawItem(Sender: TObject; Index: Integer;
      Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup4Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button3Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      if RtCheckGroup1.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckGroup1.Items.Add(Memo1.Lines[i]);
      if RtCheckGroup2.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckGroup2.Items.Add(Memo1.Lines[i]);
      if RtCheckGroup3.Items.IndexOf(Memo1.Lines[i])<0 then
         RtCheckGroup3.Items.Add(Memo1.Lines[i]);
   end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
   i,n: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      n := RtCheckGroup1.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckGroup1.Items.Delete(n);
      n := RtCheckGroup2.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckGroup2.Items.Delete(n);
      n := RtCheckGroup3.Items.IndexOf(Memo1.Lines[i]);
      if n>=0 then
         RtCheckGroup3.Items.Delete(n);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      RtCheckGroup1.Value[Memo1.Lines[i]] := True;
      RtCheckGroup2.Value[Memo1.Lines[i]] := True;
      RtCheckGroup3.Value[Memo1.Lines[i]] := True;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   i: integer;
begin
   for i:=0 to Memo1.Lines.Count-1 do
   begin
      RtCheckGroup1.Value[Memo1.Lines[i]] := False;
      RtCheckGroup2.Value[Memo1.Lines[i]] := False;
      RtCheckGroup3.Value[Memo1.Lines[i]] := False;
   end;
end;

procedure TForm1.RtCheckGroup1Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckGroup1.Checked);
end;

procedure TForm1.RtCheckGroup2Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckGroup2.Checked);
end;

procedure TForm1.RtCheckGroup3Click(Sender: TObject);
begin
    ListBox1.Items.Assign(RtCheckGroup3.Checked);
end;

procedure TForm1.RtCheckGroup1Check(Sender: TObject; Index: Integer;
  var Value: Boolean);
var
	Line: string;
begin
	Line := TRtCheckGroup(Sender).Items[Index]+' will be ';
   if Value then
   	Line := Line+'checked.'
   else
   	Line := Line+'unchecked.';
	if MessageDlg(Line+#13#10+'Proceed ?',mtConfirmation,[mbYes,mbNo],0)=mrNo then
   	Value := not Value;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
	RtCheckGroup1.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
	RtCheckGroup2.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
	RtCheckGroup3.CheckMode := TRtCheckMode(TRadioGroup(Sender).ItemIndex);
end;

procedure TForm1.RtCheckGroup3DrawItem(Sender: TObject; Index: Integer;
  Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
begin
  	with TRtCheckGroup(Sender) do
	  	if Value[Items[Index]] then
   		Canvas.Font.Color := clRed;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   RtCheckGroup1.WordWrap := (Sender as TCheckBox).Checked;
   RtCheckGroup2.WordWrap := (Sender as TCheckBox).Checked;
   RtCheckGroup3.WordWrap := (Sender as TCheckBox).Checked;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
   RtCheckGroup1.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckGroup2.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckGroup3.TextAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
end;

procedure TForm1.RadioGroup4Click(Sender: TObject);
begin
   RtCheckGroup1.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
   RtCheckGroup2.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
   RtCheckGroup3.BmpVAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex+2);
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
   RtCheckGroup1.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckGroup2.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
   RtCheckGroup3.BmpHAlign := TRtAlignment((Sender as TRadioGroup).ItemIndex);
end;

end.
