unit Reportfm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, SSBC, StdCtrls, Quickrep, ExtCtrls, DB, DBTables, Qrssbc;

type
  TfmReport = class(TForm)
    QuickReport: TQuickReport;
    tbCustomer: TTable;
    dsCustomer: TDataSource;
    bndDetail: TQRBand;
    QRDBText1: TQRDBText;
    QRDBText2: TQRDBText;
    QRDBText3: TQRDBText;
    QRDBText4: TQRDBText;
    QRDBText5: TQRDBText;
    QRDBText6: TQRDBText;
    QRDBText7: TQRDBText;
    tbCustomerCustNo: TFloatField;
    tbCustomerCompany: TStringField;
    tbCustomerAddr1: TStringField;
    tbCustomerAddr2: TStringField;
    tbCustomerCity: TStringField;
    tbCustomerState: TStringField;
    tbCustomerZip: TStringField;
    tbCustomerCountry: TStringField;
    tbCustomerPhone: TStringField;
    tbCustomerFAX: TStringField;
    tbCustomerTaxRate: TFloatField;
    tbCustomerContact: TStringField;
    tbCustomerLastInvoiceDate: TDateTimeField;
    btReport: TButton;
    SSBarcode1: TSSBarcode;
    QRssBarcode1: TQRssBarcode;
    procedure tbCustomerZipGetText(Sender: TField; var Text: OpenString;
      DisplayText: Boolean);
    procedure btReportClick(Sender: TObject);
    procedure QuickReportFilter(var PrintRecord: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmReport: TfmReport;

implementation

{$R *.DFM}

procedure TfmReport.tbCustomerZipGetText(Sender: TField;
  var Text: OpenString; DisplayText: Boolean);

var
  St : string;


  function IsNumeric(St : string) : boolean;

  var
    X   : integer;
    AcceptSet : set of char;
  begin
    Result := true;
    AcceptSet := ['0'..'9','-'];
    for X := 1 to Length(St) do
      if not (St[X] in AcceptSet) then
        Result:= false;
  end;

begin
  { it is the programmer's responsibility to make sure, when an ssBarcode is linked to a
    DataSource/DataField, that the values being passed to the barcode are legal for that
    symbology.  In this case, we are using PostNet, which requires a numeric zip code.
    Since the DBDEMOS:CUSTOMERS.DB file has some non-U.S. zip codes, we must write a
    GetText handler to throw out any codes that aren't numeric. }

  St := Sender.AsString;
  if (not IsNumeric(St)) or (not (Length(St) in [5,9,10,11])) then
    Text := ''
  else
    Text := St;

end;

procedure TfmReport.btReportClick(Sender: TObject);
begin
  QuickReport.Preview;
end;

procedure TfmReport.QuickReportFilter(var PrintRecord: Boolean);
begin
  PrintRecord := tbCustomer.FieldByName('ZIP').AsString <> '';
end;

end.
