unit TProtect;
{Version 2.0}
{
 Copyright 1996 By Amber Computer Systems Inc.
 and Dave Robinson
 14197 74 Ave Surrey BC
 Ph. 604 599-9279
 FAX 604 599-9261
}

interface

(* {$Define DEMO}  *)

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, db, dbiProcs,dbiTypes,dbiErrs, LZEXPAND, DsgnIntf;


const
  RepairTempTblName='FIX_BAK.DB'; {for internal repair functions}
  BackupTblName='FIX_BAK.DB'; {for TUtility DLL repair functions}
  KeyViolTblName='KEYVIOL.DB'; {for TUtility DLL repair functions}
  ProblemTblName='PROBLEM.DB'; {for TUtility DLL repair functions}
  ErrorTblName='REBUILD.DB'; {for TUtility DLL repair functions}


{ TUtility (TUVerifyTable) Session Options }
const
  TU_Append_Errors = 1;
  TU_No_Secondary  = 2;
  TU_No_Warnings   = 4;
  TU_Header_Only   = 8;
  TU_Dialog_Hide   = 16;
  TU_No_Lock       = 32;

{ TUtility type definitions }
type
  TBDEUtil = class;

  hTUses  = Word;
  phTUses = ^hTUses;
  { Verify Callback processes }
  TUVerifyProcess = (TUVerifyHeader, TUVerifyIndex, TUVerifyData, TUVerifySXHeader,
                     TUVerifySXIndex, TUVerifySXData, TUVerifySXIntegrity,
                     TUVerifyTableName, TURebuild);
  { Call back info for Verify Callback function }
  TUVerifyCallBack = record
    PercentDone: word;
    TableName: DBIPath;
    Process: TUVerifyProcess;
    CurrentIndex: word;
    TotalIndex: word;
  end;

{ TUtility functions }

TUInit = function (var hTUSession: hTUses): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUVerifyTable = function (hTUSession: hTUses;
                       pszTableName,
                       pszDriverType,
                       pszErrTableName,
                       pszPassword: PChar;
                       iOptions: integer;
                       var piErrorLevel: Integer): DBIResult; {$ifDef Win32} stdcall; {$endif}

TURebuildTable = function (hTUSession: hTUses;
                        pszTableName,
                        pszDriverType,
                        pszBackupTableName,
                        pszKeyviolName,
                        pszProblemTableName: PChar;
                        pCrDesc: pCRTblDesc): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUGetCRTblDescCount = function (hTUSession: hTUses;
                             pszTableName: PChar;
                             var iFldCount,
                             iIdxCount,
                             iSecRecCount,
                             iValChkCount,
                             iRintCount,
                             iOptParams,
                             iOptDataLen: word): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUFillCRTblDesc = function (hTUSession: hTUses;
                         pCrDesc: pCRTblDesc;
                         pszTableName,
                         pszPassword: PChar): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUFillCURProps = function (hTUSession: hTUses;
                        pszTableName: PChar;
                        var tblProps: CURProps): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUGetExtTblProps = function (hTUSession: hTUses;
                          pszTableName: PChar;
                          var pTS: TimeStamp;
                          var pbReadOnly: Boolean): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUExit = function (hTUSession: hTUses): DBIResult; {$ifDef Win32} stdcall; {$endif}

TUGetErrorString = function (iErrorcode: DBIResult;
                          pszError: PChar): DBIResult; {$ifDef Win32} stdcall; {$endif}

  TBDEUtil = class
    CbInfo: TUVerifyCallback;
    TUProps: CURProps;
    hDb: hDBIDb;
    vhTSes: hTUSes;

    constructor Create;
    destructor Destroy; override;
    function GetTCursorProps(szTable: String): Boolean;
    procedure RegisterCallBack;
    procedure UnRegisterCallBack;

    private
      FTUtilDLLinstalled           : Boolean;
    protected
      property TUtilDLLinstalled : Boolean read FTUtilDLLinstalled write FTUtilDLLinstalled  default False;
  end;



type

  TProtector = class(TComponent)

  private

    FMessageError,
    FErrorLogFile,
    FNewIndexName,
    FNewIndexFieldName :String;

    fIsTryRepair,
    Fresult,
    FIsKillData,
    FTUtilDLLinstalled,
    FUseTUtilForTest,
    FUseTUtilForRepair            : Boolean;

    FProtectedTable,
    FDataMirrorTable,
    FStructure,
    FtblRepairTemp                : TTable;

    BDEUtil: TBDEUtil;

  protected
    function TUtilTest(aTable:TTable;CallingProcName:String):boolean;
    function TUtilRepair(aTable, aBackupTable:TTable;CallingProcName:String):boolean;

    function RepairTable(useTU :Boolean;CallingProcName:String) : Boolean;
    function DeleteIndexFiles(SenderTTable:TTable;ErrorLogFile,CallingProcName:String):Boolean;
    function TestTable(_Table:TTable;CallingProcName:String) : Boolean;
    function SetIndex(CallingProcName:String) : Boolean;
    function OpenTable(CallingProcName:String) : Boolean;
    function CopyTable(SourceTable,DestTable:TTable;CallingProcName:String) : Boolean;
    function CopyFileLZ(SourcePChar:pchar;DestPChar:Pchar) : Boolean;

    Function CopyTableAPI(SourceTable,DestTable:TTable; CallingProcName:String;Const isTestSourceFirst,
              isLZcopyDLL :Boolean):Boolean;
    function CopyTableBDE(SourceTable,DestTable:TTable;Const isTestSourceFirst:Boolean;CallingProcName:String) : Boolean;

    function CopyTableBatchMove(SourceTable,DestTable:TTable;Const isTestSourceFirst:Boolean;CallingProcName:String):Boolean;

    procedure LogDBError(Const AExc: EDBEngineError;Const OtherInfo,CallingProcName:String);
    procedure LogTUError(TUtilDLL_handle: THandle; Const rslt: dbiResult;Const OtherInfo,CallingProcName:String);
    procedure LogRepair(Const Info,CallingProcName:String);

    property tblRepairTemp   : TTable    read FtblRepairTemp   write FtblRepairTemp;

    procedure SetNewIndexName(const Value: string);
    procedure SetNewIndexFieldName(const Value: string);

  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure   ChangeIndex;
    procedure   ProtectedOpen;

    property    Result           : boolean read Fresult           write Fresult;

  published
    property NewIndexName      : String  read FNewIndexName      write SetNewIndexName;
    property NewIndexFieldName : String  read FNewIndexFieldName write setNewIndexFieldName;
    property ErrorLogFile      : String  read fErrorLogFile      write FErrorLogFile;
    property ProtectedTable    : TTable  read FProtectedTable    write FProtectedTable;
    property DataMirrorTable   : TTable  read FDataMirrorTable   write FDataMirrorTable;
    property StructureBackUp   : TTable  read FStructure         write FStructure;
    property IsKillData        : Boolean read FIsKillData        write FIsKillData default False;

    property TUtilDLLinstalled : Boolean read FTUtilDLLinstalled write FTUtilDLLinstalled  default False;
    property UseTUtilForTest : Boolean read FUseTUtilForTest write FUseTUtilForTest default False;
    {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
    {$ifDef Win32}
    property UseTUtilForRepair : Boolean read FUseTUtilForRepair write FUseTUtilForRepair default False;
    {$endif}
  end;

{$ifDef DEMO}
type
   PHWND=^HWND;

function IsEditMode: Boolean;
function  WinClassName(Int: Integer;FoundWnd:PHWND): Boolean; Export; {$ifDef Win32} stdcall; {$endif}

{$endif}



procedure Register;

var
  Names  : TstringList;

implementation



{------------------------------------------------------------------------------}
{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}
{------------------------------------------------------------------------------}


{"Official" part}


constructor TProtector.Create(AOwner: TComponent);
begin
 {set defaults}
  IsKillData:=False;
  TUtilDLLinstalled:=False;
  UseTUtilForTest:=False;
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  UseTUtilForRepair:=False;
  {$endif}

  inherited Create(AOwner);
  REsult:= false;
  BDEUtil := nil;
  tblRepairTemp   := TTable.create(self);
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


destructor TProtector.Destroy;
begin
  if BDEUtil<>nil then
    BDEUtil.Free;
  if tblRepairTemp<>nil then
    tblRepairTemp.FREE;
  inherited Destroy;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure Register;
begin
  RegisterComponents('ACSI', [TProtector]);
end;


{"Official" part end }


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.SetNewIndexFieldName(const Value: string);
begin
  FNewIndexName:=chr(0);
  FNewIndexFieldName:=Value;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.SetNewIndexName(const Value: string);
begin
  FNewIndexFieldName:=chr(0);
  FNewIndexName:=Value;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.ChangeIndex;
var
  CallingProcName : string;
begin
  CallingProcName:='ChangeIndex';
  if SetIndex(CallingProcName) then REsult :=True;
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.ProtectedOpen;
var
  CallingProcName:String;
begin

  result:=false; {initialize}
  CallingProcName:='ProtectedOpen';

  {$ifDef DEMO}
  if not Iseditmode then
    begin
    messageDlg(' This component is demo version only.'+chr(10)+chr(13)+' To get working version please contact'+
    chr(10)+chr(13)+chr(10)+chr(13)+'   AMBER COMPUTER SYSTEMS Inc.'+chr(10)+chr(13)+chr(10)+chr(13)+
    '   tel. (604)599-9167, (604)599-9261'+chr(10)+chr(13)+'              fax (604)599-9261',mtWarning,[mbOK],0);
     exit;
    end;
  {$endif}

  try
    if Opentable(CallingProcName) then REsult :=True
  finally
    {}
  end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.LogDBError(Const AExc: EDBEngineError;Const OtherInfo,CallingProcName:String);
var
  counter : Integer;
  TxtFile: TextFile;

begin
   try
{    showmessage('Logging Error'); }
      AssignFile(TxtFile, ErrorLogFile);

      if FileExists(ErrorLogFile) then
          Append(TxtFile)	{ Add more text onto end }
      else
          Rewrite(TxtFile);	{ Create new file }

      WriteLn(TxtFile, '******************************************');
      WriteLn(TxtFile, 'Number of Errors: '+ IntToStr(AExc.ErrorCount));

      for counter:=0 to AExc.ErrorCount-1 do
        Begin
            WriteLn(TxtFile, 'Message: '+ AExc.Errors[counter].Message);
            WriteLn(TxtFile, 'Category: '+ IntToStr(AExc.Errors[counter].Category));
            WriteLn(TxtFile, 'SubCode: '+ IntToStr(AExc.Errors[counter].SubCode));
            WriteLn(TxtFile, 'NativeError: '+ IntToStr(AExc.Errors[counter].NativeError));
            Writeln(TxtFile, 'Other Info: '+OtherInfo);
            Writeln(TxtFile, 'Calling procedure: '+CallingProcName);
            Writeln(TxtFile, 'Log Date and time: '+DateTimeToStr(Now));
            Writeln(TxtFile, '');
        End;

      WriteLn(TxtFile, '******************************************');

      Flush(TxtFile);
      CloseFile(TxtFile);	{ Close file, save changes }
   except {prevent error here from interrupting flow of program}
      try
        closefile(TxtFile);
      except
      {}
      end;
   end;
End;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.LogTUError(TUtilDLL_handle : THandle;Const rslt: dbiResult;Const OtherInfo,CallingProcName:String);
var
  TxtFile: TextFile;
  pszError : PChar;
  ErrorString : String;
  TUGetErrorString_func : TUGetErrorString;

begin
   try
{    showmessage('Logging Error'); }

  if TUtilDLL_handle > HINSTANCE_ERROR then
    begin
      {$ifDef Win32}
      Getmem(pszError,(DBIMAXMSGLEN + 1));
      try
        TUGetErrorString_func:=TUGetErrorString(GetProcAddress(TUtilDLL_handle,'TUGetErrorString'));
        TUGetErrorString_func(rslt, pszError);
        ErrorString:=String(pszError);
      finally
        Freemem(pszError,(DBIMAXMSGLEN + 1));
      end;

      {$else}
      Getmem(pszError,(DBIMAXMSGLEN + 1));
      try
        @TUGetErrorString_func:=GetProcAddress(TUtilDLL_handle,'TUGetErrorString');
        TUGetErrorString_func(rslt, pszError);
        ErrorString:= StrPas(pszError);
      finally
        Freemem(pszError,(DBIMAXMSGLEN + 1));
      end;
      {$endif}
    end
  else
    ErrorString:='unknown error - TUtility DLL handle is not available to retrieve error string';

{           Showmessage('Error integer value: '+IntToStr(rslt2)+'    Error String: '+ErrorString); }

      AssignFile(TxtFile, ErrorLogFile);

      if FileExists(ErrorLogFile) then
          Append(TxtFile)	{ Add more text onto end }
      else
          Rewrite(TxtFile);	{ Create new file }

      WriteLn(TxtFile, '******************************************');
      WriteLn(TxtFile, 'Error integer value: '+IntToStr(rslt));
      WriteLn(TxtFile, 'Error String: '+ErrorString);
      Writeln(TxtFile, 'Other Info: '+OtherInfo);
      Writeln(TxtFile, 'Calling procedure: '+CallingProcName);
      Writeln(TxtFile, 'Log Date and time: '+DateTimeToStr(Now));
      WriteLn(TxtFile, '******************************************');

      Flush(TxtFile);
      CloseFile(TxtFile);	{ Close file, save changes }
   except {prevent error here from interrupting flow of program}
      try
        closefile(TxtFile);
      except
      {}
      end;
   end;
End;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


procedure TProtector.LogRepair(Const Info,CallingProcName:String);
var
  TxtFile: TextFile;

begin
   try
      AssignFile(TxtFile, ErrorLogFile);

      if FileExists(ErrorLogFile) then
          Append(TxtFile)	{ Add more text onto end }
      else
          Rewrite(TxtFile);	{ Create new file }

      WriteLn(TxtFile, '_______________________');
      Writeln(TxtFile, 'Info: '+Info);
      Writeln(TxtFile, 'Calling procedure: '+CallingProcName);
      Writeln(TxtFile, 'Log Date and time: '+DateTimeToStr(Now));
      WriteLn(TxtFile, '_______________________');

      Flush(TxtFile);
      CloseFile(TxtFile);	{ Close file, save changes }
   except {prevent error here from interrupting flow of program}
      try
        closefile(TxtFile);
      except
      {}
      end;
   end;
End;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

function TProtector.OpenTable(CallingProcName:String):Boolean;
Begin
   OpenTable:=True; {initialize return value}
 {  showmessage('Opening Table');}
   CallingProcName:='OpenTable called by'+CallingProcName;
   try
      if NOT ProtectedTable.Active then ProtectedTable.open;
   except
      On E: EDBEngineError do
         Begin
         if ProtectedTable.active then ProtectedTable.close;
         {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}
         FisTryRepair:=TRue;
         {@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@}
         if FisTryRepair then
            try
               LogDBError( E,'trying initial table open - will try to repair now',CallingProcName);
               repairTable(True,CallingProcName); {use TUtility if available}
               Application.ProcessMessages;
               ProtectedTable.open;
            except
               On E: EDBEngineError do
                  Begin
                  LogDBError( E,'Re-opening after repair attempt',CallingProcName);
                  OpenTable:=False; {open operation failed}
                  end;
             end {try-except}
         else
            Begin
            OpenTable:=False; {open operation failed}
            LogDBError( E,'trying initial table open',CallingProcName);
            end;
         end;
   end;
end;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


function TProtector.SetIndex(CallingProcName:String):Boolean;
var
   wasOpen:Boolean;
Begin
{  showmessage('Setting Index');}
   SetIndex:=True; {initialize return value}
   CallingProcName:='SetIndex called by '+CallingProcName;
   if ProtectedTable.active then
      wasOpen:=True
   else
      wasOpen:=False;
   try
      try
         if NOT ProtectedTable.active then ProtectedTable.open;
         ProtectedTable.indexName:=FNewIndexName;
      except
         On E: EDBEngineError do
            Begin
            if ProtectedTable.active then ProtectedTable.close;
            FisTryRepair:=True;
            if FisTryRepair then
               try
                  LogDBError(E,'Initial setting of indexname - will now try repair',CallingProcName);
                  if ProtectedTable.active then ProtectedTable.close;
                  repairTable(False,CallingProcName); {index error -do not use TUtility even if available}
                  Application.ProcessMessages;
                  if NOT ProtectedTable.active then ProtectedTable.open;
                  ProtectedTable.indexName:=FNewIndexName;
               except
                  On E: EDBEngineError do
                     Begin
                     LogDBError(E,'Re-Set of indexname after repair attempt',CallingProcName);
                     SetIndex:=False; {setIndex operation failed}
                     end;
                end
            else
               Begin
               SetIndex:=False; {setIndex operation failed}
               LogDBError(E,'Initial setting of indexname',CallingProcName);
               end;
            end;
      end;
   finally
      if NOT wasOpen then
         if ProtectedTable.active then ProtectedTable.close;
   end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


Function TProtector.TestTable(_Table:TTable;CallingProcName:String):Boolean;
var
   TempInt,
   IndexCounter : Integer;

Begin
{   showmessage('Testing Table');  }
   CallingProcName:='TestTable called by '+CallingProcName;
   try
      if NOT _Table.Active then _Table.open;
      _Table.IndexName:='';
      _Table.IndexDefs.Update; { Get the current available indices }
      Application.ProcessMessages;
      TempInt:= _Table.IndexDefs.Count -1;
      For IndexCounter := 0 to TempInt do {cycle through indices}
        BEGIN
         _Table.IndexName:=_Table.IndexDefs.Items[IndexCounter].name; {set index - to test}
         application.processmessages;
        END;
        {Begin-end added because line would only execute once otherwise }
      _Table.IndexName:='';
      if _Table.Active then _Table.close;
      Application.ProcessMessages;
      TestTable:=true; {set function return value}
   except
      On E: EDBEngineError do
         Begin
         LogDBError(E,'testing table:'+_Table.tableName+' and all its indexes',CallingProcName);
         if _Table.Active then _Table.close;
         _Table.indexName:='';
         raise; {re-raise the exception}
         TestTable:= False; {set function return value}
         End;
   end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


(* The RepairTable will first test the validity of BackupTTable (empty backup *)
(* table with the same structure as the damaged table (ProtectedTable)). If the *)
(* backup table is valid the repair will be attempted. If isMirrored is true  *)
(* (ie. there is a second copy of the data in another table) then the Backup  *)
(* table will be copied over the damaged table, then the new table will be    *)
(* re-populated with data with a batchmove from the DataMirrorTable. If      *)
(* isMirrored is False, then the a temporary copy of the .DB part of          *)
(* ProtectedTable will be created with a batchmove(batCopy). Then the Backup    *)
(* table will be copied over the damaged table and then repopulate it with    *)
(* data from the temporary table                                              *)
Function TProtector.RepairTable(useTU :Boolean;CallingProcName:String):Boolean;
var
  Info        : string;
  done,
  TryInternalRepair,
  wasMirrorOpen,
  dbOK : Boolean;
  LockResult: dbiResult;
  aTableName : PChar;
  dbTemp : TDatabase;

Begin
   CallingProcName:='RepairTable called by '+CallingProcName;
   Info:='';

   if ProtectedTable.active then ProtectedTable.close;
   if (StructureBackUp.tableName<>'') then
     if StructureBackUp.active then StructureBackUp.close;
   Application.processmessages;

   dbTemp:=TDatabase.create(self);

   try
      dbTemp.aliasname:=ProtectedTable.databaseName;
      dbTemp.databaseName:='repair';

      dbTemp.open;
      Application.ProcessMessages;
      GetMem(aTableName,length(ProtectedTable.tableName)+1);
      try
         StrPCopy(aTableName,ProtectedTable.tableName);
         Application.ProcessMessages;

         done:=False; {initialize}
         repeat
            LockResult:=dbiAcqPersistTableLock(dbTemp.handle,aTableName,szParadox);
            Application.ProcessMessages;

            if (LockResult=DBIERR_NONE) then
              done:=True
            else
              begin
              {if (LockResult=DBIERR_LOCKED) then }
              if messageDlg('Error: Cannot lock the table :'+ProtectedTable.tableName+' for repair'+
              chr(10)+chr(13)+'This repair function requires exclusive access to this file.'+
              chr(10)+chr(13)+'If you want the repair function to continue, '+
              chr(10)+chr(13)+'you should ask all other users of this program to temporarily shut down'+
              chr(10)+chr(13)+'and then press the retry button.'+chr(10)+chr(13)+
              'Otherwise press the ignore button to skip repair and continue.' , mtConfirmation,[mbRetry, mbIgnore],0)
                =mrIgnore then
                begin
                {done:=True;}
                result:=False;
                exit;
                end;
              end;
          until done;

      finally
         FreeMem(aTableName,length(ProtectedTable.tableName)+1);
         dbTemp.close;
         Application.ProcessMessages;
         if ProtectedTable.Active then ProtectedTable.close;
      end; {try-finally}
   finally
     dbTemp.free;
   end;

try
   try
      info:='Corrupted Structure BackUp';
      done:=False; {intialize}

      if (StructureBackUp.tableName='') then
        TryInternalRepair:=False {requires backup structure}
      else
        try
          {test empty backup file}
          TestTable(StructureBackUp,CallingProcName);
          TryInternalRepair:=True;
        except
          StructureBackUp.tablename:='';
          TryInternalRepair:=False; {requires backup structure}
        end;

   if DataMirrorTable<>nil then
      if DataMirrorTable.tablename<>'' then
         try {test Mirrored data source table}
            TestTable(DataMirrorTable,CallingProcName);
         except
            DataMirrorTable.tablename:='';
         end;

      if ProtectedTable.active then ProtectedTable.close;

      if StructureBackUp.tableName<>'' then
        if StructureBackUp.active then StructureBackUp.close;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

       {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
      {$ifDef Win32}
      if useTU then
        begin
           if TUtilDLLinstalled AND UseTUtilForRepair then {TProtector property set to indicate that TUtility is installed}
             begin
             if BDEUtil=nil then {i.e. BDEUtil has not yet been created}
               Begin
               BDEUtil := TBDEUtil.Create;
               application.processmessages;
               if NOT BDEUtil.TUtilDLLinstalled then {DLL wasn't sucessfully loaded}
                 TUtilDLLinstalled:=False; {change property of TProtector to reflect that TUtility wasn't loaded}
               end;
             end;

           if TUtilDLLInstalled AND UseTUtilForRepair then
             Begin
             if Not TUtilRepair(ProtectedTable,StructureBackUp, CallingProcName) then
               info:='TUtility repair procedure failed';
             Application.Processmessages;
             try
               TestTable(ProtectedTable,CallingProcName);
               TryInternalRepair:=False; {TUtility was successful}
             except
               On E: EDBEngineError do
                 begin
                 if StructureBackUp.tablename='' then
                   TryInternalRepair:=False {no backup structure so cannot repair with internal procedures}
                 else
                   begin
                   TryInternalRepair:=True; {TUtility was NOT successful, try internal repair}
                   info:=info+' - will now try internal repair procedures';
                   end;
                 LogDBError(E,info,CallingProcName);
                 end;
             end;
             end;
        end; {if useTU}
     {$endif}

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

      if TryInternalRepair then
         begin

     if DataMirrorTable<>nil then
       if DataMirrorTable.tablename<>'' then
         Begin
         if DataMirrorTable.active then
           begin
           wasMirrorOpen:=true;
           end
         else
           Begin
           wasMirrorOpen:=False;
           DataMirrorTable.open;
           end;

         info:='Unable to copy StructureBackUp to ProtectedTable';
         if StructureBackUp.tablename='' then
           if CopyTable(DataMirrorTable,ProtectedTable,CallingProcName) then
         else
           Begin
           if CopyTable(StructureBackUp,ProtectedTable,CallingProcName) then
             Begin
             info:='Failed to bachmove data from DataMirror to ProtectedTable after rebuilding of the structure.'+
             ' Possible reason: DataMirror and StructureBackUp has different field structure. Table '+ProtectedTable.tablename;
             Application.ProcessMessages;
             if DataMirrorTable.recordCount>0 then
                begin
                ProtectedTable.batchMove(DataMirrorTable,batAppendUpdate);
                Application.ProcessMessages;
                end;
             end;

           if wasMirrorOpen then
             if NOT DataMirrorTable.active then DataMirrorTable.open
           else
             if DataMirrorTable.active then DataMirrorTable.close;
           end;

         try
           testTable(ProtectedTable,CallingProcName);
           LogRepair('Table '+ProtectedTable.tablename+' successfully repaired (using data mirrored copy)',callingprocName);
           done:=True;
         except
           done:=False;;
         end;
         end;

       if NOT done then
         Begin
         info:='Error creating a temporary table';
         if tblRepairTemp.active then tblRepairTemp.close;
         tblRepairTemp.DatabaseName:=ProtectedTable.DatabaseName;
         tblRepairTemp.TableName := RepairTempTblName;
         tblRepairTemp.batchMove(StructureBackup,batCopy);
         Application.Processmessages;

         info:='Error deleting indexes from damaged table';
         ProtectedTable.indexName:='';
         application.processmessages;

         {delete indexes because badly corrupted indexes will cause batchmove to fail in some cases}
         DeleteIndexFiles(ProtectedTable,ErrorLogFile,CallingProcName); {physically delete index files}

         application.processmessages;

         try {test .db file alone -now that indices were deleted}
           if NOT ProtectedTable.active then ProtectedTable.open;
           dbOK:=True;
         except
           On E: EDBEngineError do
             begin
             if TUtilDLLInstalled {$ifDef Win32} AND UseTUtilForRepair {$endif} then
               begin
               info:='Protected table main .DB file is damaged. This data is not mirrored'+chr(10)+chr(13)+
               'and the TUtility DLL failed to properly repair it .'+chr(10)+chr(13)+
               'Data loss could result from internal repair procedure so repair has been terminated.';
               end
             else
               begin
               info:='Protected table main .DB file is damaged. This data is not mirrored'+chr(10)+chr(13)+
               'and either the TProtector is not configured to use TUtility DLL for repair'+
               ' or TUtility DLL could not be loaded.'+chr(10)+chr(13)+
               'Data loss could result from internal repair procedure so repair has been terminated.';
               end;

             LogDBError(E,info,CallingProcName);
             dbOK:=False;
             end;
         end;

         if ProtectedTable.active then ProtectedTable.close;
         application.processmessages;

         if dbOK then
           Begin
           info:='Error moving data into temp table from damaged table:'+ProtectedTable.tableName;

           try
             tblRepairTemp.batchMove(ProtectedTable,batAppend);
           finally
             application.processmessages;
             if NOT tblRepairTemp.active then tblRepairTemp.open; {needed to check recordcount}
             if NOT ProtectedTable.active then ProtectedTable.open; {needed to check recordcount}
             application.processmessages;

             if (tblRepairTemp.recordCount>0) or (ProtectedTable.recordCount=0) or isKillData then
               Begin
               try
                 if ProtectedTable.active then ProtectedTable.close; {need to copy over it}

                 Application.ProcessMessages;
                 info:='Error copying backup structure over damaged table';
                 CopyTable(StructureBackUp,ProtectedTable,CallingProcName);
                 Application.ProcessMessages;

                 if (tblRepairTemp.recordCount>0) then
                   begin
                   info:='Error batch-moving data from temporary table to repaired table';
                   ProtectedTable.batchMove(tblRepairTemp,batAppendUpdate);
                   Application.ProcessMessages;
                   end;

                 if tblRepairTemp.active then tblRepairTemp.close;

                 try
                   tblRepairTemp.deleteTable;
                 except
                   {trap and ignore errors deleting temp table}
                 end;
               except
                 On E: EDBEngineError do
                   begin
                   LogDBError(E,info,CallingProcName);
                   if IsKillData then
                     begin
                     if ProtectedTable.active then ProtectedTable.close; {need to copy over it}
                     application.processmessages;
                     CopyTable(StructureBackUp,ProtectedTable,CallingProcName);
                     end;
                   Application.ProcessMessages;
                   end;
               end; {try-except}
               end; {if}
           end; {try-finally}
           end; {if dbOK}

         end; {if not done}

         end; {if TryInternalRepair}

      Application.ProcessMessages;

      {test repaired table}
      TestTable(ProtectedTable,CallingProcName);
      LogRepair('Testing confirmed that the table '+ProtectedTable.tablename+' was successully repaired',callingprocName);
      RepairTable:=True; {set function return value - an exception would prevent this line from being executed}

   except
      On E: EDBEngineError do
         Begin
         LogDBError(E,info,CallingProcName);
         RepairTable:=False; {set function return value}
         End;
   End;

finally
    dbTemp:=TDatabase.create(self);
    try
      dbTemp.aliasname:=ProtectedTable.databaseName;
      dbTemp.databaseName:='repair';
      dbTemp.open;
      Application.ProcessMessages;
      GetMem(aTableName,length(ProtectedTable.tableName)+1);
      try
         StrPCopy(aTableName,ProtectedTable.tableName);
         Application.ProcessMessages;
         {LockResult:=}dbiRelPersistTableLock(dbTemp.handle,aTableName,szParadox);
         Application.ProcessMessages;
      finally
         FreeMem(aTableName,length(ProtectedTable.tableName)+1);
         dbTemp.close;
         Application.ProcessMessages;
         if ProtectedTable.Active then ProtectedTable.close;
      end; {try-finally}
    finally
      dbTemp.free;
    end;
end;

end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


Function TProtector.DeleteIndexFiles(SenderTTable:TTable;ErrorLogFile,CallingProcName:String):Boolean;
Var
   AliasParams : TStrings;
   AliasName,
   SenderTableNameString,
   SenderDirString,
   SenderFileName,
   extension    : String;
   SenderPChar : PChar;
   FileDescriptionRec : TSearchRec;
   DotPos : Integer;

Begin
   CallingProcName:='DeleteIndexes called by '+CallingProcName;
   AliasParams:=TStringList.create;
   try
      AliasName:=SenderTTable.DatabaseName;
      Session.GetAliasParams(AliasName, AliasParams);
      SenderDirString:=Copy(AliasParams.Strings[0],6,60);

      try
         if SenderTTable.Active then SenderTTable.close;
         Application.ProcessMessages;

         SenderTableNameString:=SenderTTable.tablename;
         DotPos:=pos('.',SenderTableNameString);
         If DotPos>0 then
            Delete(SenderTableNameString,DotPos,4);

         If FindFirst(SenderDirString+'\'+SenderTableNameString+'.*',faAnyFile,FileDescriptionRec)= 0 then
             Repeat
                SenderFileName:=SenderDirString+'\'+FileDescriptionRec.Name;
                extension:=FileDescriptionRec.Name;
                DotPos:=pos('.',extension);
                If DotPos>0 then
                  Delete(extension,1,DotPos)
                else
                  extension:='';

                if (Copy(extension,1,2)='XG') OR (Copy(extension,1,2)='YG') OR
                   (Copy(extension,1,2)='PX') OR (Copy(extension,1,3)='VAL') then
                   Begin
                   {$ifDef Win32}
                   GetMem(SenderPChar,length(SenderFileName)+1);
                   try
                      StrPCopy(SenderPChar,SenderFileName);
                      DeleteFile(SenderPChar);
                      Application.ProcessMessages;
                   finally
                      FreeMem(SenderPChar,length(senderFileName)+1);
                   end;
                   {$else}
                   DeleteFile(SenderFileName);
                   {$endif}
                   end;
             Until FindNext(FileDescriptionRec)<>0;
             DeleteIndexFiles:=True;
      except
         On E: EDBEngineError do
            Begin
            LogDBError(E,'Index deletes failed',CallingProcName);
            DeleteIndexFiles:=False; {set return value}
            End;
      End; {try-except}

    finally
       AliasParams.Free;
    end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

(* The CopyTable function will try to call other table copy functions and     *)
(* test the results.                                                          *)
Function TProtector.CopyTable(SourceTable,DestTable:TTable;CallingProcName:String):Boolean;

Begin
   CallingProcName:='CopyTable called by '+CallingProcName;
{   showmessage('Copying Table');    }
   try
      {test Source file}
      TestTable(SourceTable,CallingProcName);
      if SourceTable.Active then SourceTable.close;
      if DestTable.Active then DestTable.close;
      Application.ProcessMessages;

(*      if CopyTableBatchMove(SourceTable,DestTable,ErrorLogFile,CallingProcName,False) then *)
(* there are problems with the above procedure *)
      if SourceTable.DatabaseName=DestTable.DatabaseName then {if in same directory}
        Begin
        if CopyTableBDE(SourceTable,DestTable,False,CallingProcName) then
          CopyTable:=True
        else
           begin {if first try to copy failed...}
           Application.ProcessMessages;
           if CopyTableAPI(SourceTable,DestTable,CallingProcName,False,False) then
                   {if WIn32, use COpyFile API call, else use LZexpand.DLL}
             CopyTable:=True
           else
             CopyTable:=False;
           end;
        end
      else
        Begin
{         if CopyTableBatchMove(SourceTable,DestTable,False) then }
{          there are problems with CopyTableBatchMove              }
        if CopyTableAPI(SourceTable,DestTable,CallingProcName,False,False) then
                  {if WIn32, use COpyFile API call, else use LZexpand.DLL}
           CopyTable:=True
        else
           begin {if first try to copy failed...}
           Application.ProcessMessages;
           if CopyTableAPI(SourceTable,DestTable,CallingProcName,False,True) then {use LZexpand.DLL only ewven if WIn32}
             CopyTable:=True
           else
             CopyTable:=False;
           end;
        end;
      Application.ProcessMessages;
   except
      On E: EDBEngineError do
         Begin
         LogDBError(E,'Copy table failed',CallingProcName);
         CopyTable:=False; {set return value}
         End;
   End; {try-except}
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

(* The CopyTableBatchMove function will try to use the BatchMove method to    *)
(* copy a table                                                               *)
Function TProtector.CopyTableBatchMove(SourceTable,DestTable:TTable;
         Const isTestSourceFirst:Boolean;CallingProcName:String):Boolean;
Begin
   CallingProcName:='CopyTableBatchMove called by '+CallingProcName;
   try
      if isTestSourceFirst then
         TestTable(SourceTable,CallingProcName);

      if SourceTable.Active then SourceTable.close;
      Application.ProcessMessages;

      if DestTable.Active then DestTable.close;
      Application.ProcessMessages;
      SourceTable.IndexName:='';
      DestTable.IndexName:='';
      DestTable.DeleteTable;
      Application.ProcessMessages;
      DestTable.FieldDefs:=SourceTable.FieldDefs;
      DestTable.IndexDefs.Assign(SourceTable.IndexDefs);
      DestTable.CreateTable;
      Application.ProcessMessages;
      DestTable.batchmove(SourceTable,BatAppend);
      Application.ProcessMessages;

      try {test destination table}
         TestTable(DestTable,CallingProcName);
         if DestTable.Active then DestTable.close;
         Application.ProcessMessages;
         CopyTableBatchMove:=True; {set return value}
      except
         On E: EDBEngineError do
            Begin
            LogDBError(E,'Testing destination table of table copy',CallingProcName);
            if DestTable.Active then DestTable.close;
            Application.ProcessMessages;
            CopyTableBatchMove:=False; {set return value}
            End;
      end;

   except
      On E: EDBEngineError do
         Begin
         LogDBError(E,'copy failed',CallingProcName);
         CopyTableBatchMove:=False; {set return value}
         End;
   End; {try-except}
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


(* The CopyTableBDE function will try to use the BDE to copy a table.         *)
(* For this function, both the source and destination table must be in the    *)
(* same directory                                                             *)
Function TProtector.CopyTableBDE(SourceTable,DestTable:TTable;
             Const isTestSourceFirst:Boolean;CallingProcName:String):Boolean;
Var
   SourceFileName,
   DestFileName,
   DriverType : PChar;
   dbTemp : TDatabase;
Begin
{   showmessage('Copying Table BDE');             }
   CallingProcName:='CopyTableBDE called by '+CallingProcName;
   dbTemp:=TDatabase.create(self);
   try
      try
         if isTestSourceFirst then
            TestTable(SourceTable,CallingProcName);

         if SourceTable.Active then SourceTable.close;
         Application.ProcessMessages;

         dbTemp.aliasname:=SourceTable.databaseName;
         dbTemp.databaseName:='repair';
         dbTemp.open;
         Application.ProcessMessages;
         GetMem(SourceFileName,length(SourceTable.tableName)+1);
         GetMem(DestFileName,length(DestTable.tableName)+1);
         GetMem(DriverType,length('PARADOX')+1);
         try
            StrPCopy(SourceFileName,SourceTable.tableName);
            StrPCopy(DestFileName,DestTable.tableName);
            StrPCopy(DriverType,'PARADOX');
            if DestTable.Active then DestTable.close;
            Application.ProcessMessages;
            DeleteFile(DestTable.tableName);{dbiCopyTable will not properly replace a badly
                                         corrupted table unless it's deleted first}
            Application.ProcessMessages;
            DbiCopyTable(dbTemp.handle,True,SourceFileName,DriverType,DestFileName);
            Application.ProcessMessages;

         finally
            FreeMem(SourceFileName,length(SourceTable.tableName)+1);
            FreeMem(DestFileName,length(DestTable.tableName)+1);
            FreeMem(DriverType,length('PARADOX')+1);
            dbTemp.close;
            Application.ProcessMessages;
            if SourceTable.Active then SourceTable.close;
         end; {try-finally}

         try {test destination table}
            TestTable(DestTable,CallingProcName);
            if DestTable.Active then DestTable.close;
            Application.ProcessMessages;
            CopyTableBDE:=True; {set return value}
         except
            On E: EDBEngineError do
               Begin
               LogDBError(E,'Testing destination table of table copy',CallingProcName);
               if DestTable.Active then DestTable.close;
               Application.ProcessMessages;
               CopyTableBDE:=False; {set return value}
               End;
         end;

      except
         On E: EDBEngineError do
            Begin
            LogDBError(E,'copy table failed',CallingProcName);
            CopyTableBDE:=False; {set return value}
            End;
      End; {try-except}

    finally
       dbTemp.free;
    end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


(* The CopyTableAPI function will try to use the Windows API to copy a table. *)
Function TProtector.CopyTableAPI(SourceTable,DestTable:TTable; CallingProcName:String;
             Const isTestSourceFirst, isLZcopyDLL :Boolean):Boolean;
Var
   AliasParams          : TStrings;

   extension,
   AliasName,
   TableNameString,
   SourceDirString,
   DestDirString,
   SourceFileName,
   DestTableNameString,
   DestFileName         : String;

   SourcePChar,
   DestPChar            : PChar;

   FileDescriptionRec   : TSearchRec;

   DotPos               : Integer;

Begin
   CallingProcName:='CopyTableAPI called by '+CallingProcName;
   AliasParams:=TStringList.create;
   try
      AliasName:=SourceTable.DatabaseName;
      Session.GetAliasParams(AliasName, AliasParams);
      SourceDirString:=Copy(AliasParams.Strings[0],6,60);

      AliasName:=DestTable.DatabaseName;
      Session.GetAliasParams(AliasName, AliasParams);
      DestDirString:=Copy(AliasParams.Strings[0],6,60);
      try
         if isTestSourceFirst then
            TestTable(SourceTable,CallingProcName);

         if SourceTable.Active then SourceTable.close;
         Application.ProcessMessages;

         TableNameString:=sourcetable.tablename;
         DotPos:=pos('.',TableNameString);
         If DotPos>0 then
            Delete(TableNameString,DotPos,4);

         DestTableNameString := destTable.tablename;
         DotPos:=pos('.',DestTableNameString);
         If DotPos>0 then
            Delete(DestTableNameString,DotPos,4);

         If FindFirst(SourceDirString+'\'+tablenameString+'.*',faAnyFile,FileDescriptionRec)= 0 then
             Repeat
                SourceFileName:=SourceDirString+'\'+FileDescriptionRec.Name;
                DotPos:=pos('.',FileDescriptionRec.Name);
                if (DotPos>0) and (DotPos < (length(sourceFileName)+1)) then
                  extension:=copy(FileDescriptionRec.Name,Dotpos+1,length(FileDescriptionRec.Name)-DotPos)
                else
                  extension:='';

                DestFileName:=DestDirString+'\'+DestTableNameString+'.'+extension;
                GetMem(SourcePChar,length(sourceFileName)+1);
                GetMem(DestPChar,length(DestFileName)+1);
                try
                   StrPCopy(SourcePChar,SourceFileName);
                   StrPCopy(DestPChar,DestFileName);
                 {$ifDef Win32}
                   if isLZcopyDLL then
                     CopyFileLZ(SourcePChar,DestPChar)
                   else
                     if CopyFile(SourcePChar,DestPChar,False)=False then  {win32 procedure}
                       begin
                       CopyTableAPI:=False; {set return value}
                       exit;
                       end;
                 {$else}
                   CopyFileLZ(SourcePChar,DestPChar);
                 {$endif}
                finally
                   FreeMem(SourcePChar,length(sourceFileName)+1);
                   FreeMem(DestPChar,length(DestFileName)+1);
                end;
                Application.ProcessMessages;
             Until FindNext(FileDescriptionRec)<>0;

         try {test destination table}
            TestTable(DestTable,CallingProcName);
            if DestTable.Active then DestTable.close;
            Application.ProcessMessages;
            CopyTableAPI:=True; {set return value}
         except
            On E: EDBEngineError do
               Begin
               LogDBError(E,'Testing destination table of table copy',CallingProcName);
               if DestTable.Active then DestTable.close;
               Application.ProcessMessages;
               CopyTableAPI:=False; {set return value}
               End;
         end;

      except
         On E: EDBEngineError do
            Begin
            LogDBError(E,'copy table failed',CallingProcName);
            CopyTableAPI:=False; {set return value}
            End;
      End; {try-except}

    finally
       AliasParams.Free;
    end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}


function TProtector.CopyFileLZ(SourcePChar:pchar;DestPChar:Pchar): Boolean;
var
  DestOfStruc,
  SourceOfStruc   : Pofstruct;

  SourceHandle,
  DestHandle    : Integer;

begin
  result:=true; {initialize}
  new(DestOfStruc);
  new(SourceOfStruc);
  try
    try
      SourceHandle := LZOpenFile(SourcePChar,SourceOfStruc^,OF_READ);
      {if SourceHandle = HFILE_ERROR then
      showmessage ('Failed to open file '+SourcePChar);}
      DestHandle   := LZOpenFile(DestPChar,DestOfStruc^,(OF_CREATE or OF_WRITE));
      {if SourceHandle = HFILE_ERROR then
      showmessage ('Failed to open file '+DestPChar);}
      lzcopy(SourceHandle,DestHandle) ;
      LZClose(SourceHandle);
      LZClose(DestHandle);
    except
      result:=false;
    end;
  finally
    dispose(SourceOfStruc);
    dispose(DestOfStruc);
  end;
end;


{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

{$ifDef DEMO}

function  WinClassName(Int: Integer;FoundWnd:PHWND): Boolean;
var
Name : Pchar;
begin
  GetMem(Name,100);
  GetClassName(Int,name,100);
  result:= True;
  {$ifDef Win32}
  Names.add(Name);
  {$endif}
  {$ifNDef Win32}
  Names.add(strpas(Name));
  {$endif}
  dispose(Name);
end;

Function IsEditMode : Boolean;
var
  WinHandle : Integer;
  FPointer : Pointer;
  Counter : Integer;
  FoundEditorClass :Boolean;
begin
  FoundEditorClass:=False;
  Names:= TstringList.Create;
  try
    Names.add('  ');
    Fpointer:=addr(WinClassName);
    WinHandle:=10;
    EnumWindows(FPointer,WinHandle);

    for Counter:=0 to names.count-1 do
      begin
       {$ifDef Win32}
      if UpperCase(trim(names.strings[Counter]))= 'TAPPBUILDER' then
       {$endif}
       {$ifNDef Win32}
      if names.strings[Counter]= 'TAppBuilder' then
       {$endif}
        begin
        FoundEditorClass:=True;
        break;
        end;
      end;
  finally
    names.free;
    Result:=FoundEditorClass;
  end;
end;

{$endif}

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

const
{$ifDef Win32}
  TUtil = 'TUTIL32.DLL';
{$else}
  TUtil = 'TUTILITY.DLL';
{$endif}

var
  TUtilDLL_handle : THandle;

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}

function GenProgressCallBack(ecbType: CBType; Data: LongInt; pcbInfo: Pointer):
  CBRType; {$ifDef Win32} stdcall; {$endif}
var
  CBInfo: TUVerifyCallBack;
begin
  CBInfo := TUVerifyCallBack(pcbInfo^);
  if ecbType = cbGENPROGRESS then
   case CBInfo.Process of
     TUVerifyHeader: begin
{       MainForm.PBHeader.Position := CBInfo.percentdone;}
     end;
     TUVerifyIndex: begin
{       MainForm.PBIndexes.Position := CBInfo.percentdone;}
     end;
     TUVerifyData: begin
{       MainForm.PBData.Position := CBInfo.percentdone;}
     end;
     TURebuild: begin
{       MainForm.PBRebuild.Position := CBInfo.percentdone;}
     end;
    end;

  Result := cbrUSEDEF;
end;


constructor TBDEUtil.Create;
var
  TUInit_func : TUInit;
  ReservedDataSpace : Array[0..100] of byte;
begin
  TUtilDLLinstalled:=False; {initialize}

  if TUtilDLL_handle<HINSTANCE_ERROR then {note: HINSTANCE_ERROR = 32}
      TUtilDLL_handle :=LoadLibrary(TUtil);
{  else
    showmessage('Tutility DLL already loaded'); }

  if TUtilDLL_handle > HINSTANCE_ERROR then
    begin
    TUtilDLLinstalled:=True;
    {$ifDef Win32}
    TUInit_func:=TUInit(GetProcAddress(TUtilDLL_handle,'TUInit'));
    {$else}
    @TUInit_func:=GetProcAddress(TUtilDLL_handle,'TUInit');
    {$endif}
    if @TUInit_func <> nil then
      Check(TUInit_func(vhtSes))
    else
      MessageDlg('TUInit function not found in the TUtility.DLL', mtError, [mbOK], 0);
    end
  else
    messageDlg('TUtility DLL not found or cannot be loaded !',mtError,[mbOK],0);
end;

destructor TBDEUtil.Destroy;
var
  TUExit_func : TUExit;
begin
  try
    if TUtilDLL_handle > HINSTANCE_ERROR then
      begin
      {$ifDef Win32}
      TUExit_func:=TUExit(GetProcAddress(TUtilDLL_handle,'TUExit'));
      {$else}
      @TUExit_func:=GetProcAddress(TUtilDLL_handle,'TUExit');
      {$endif}
      if @TUExit_func <> nil then
        Check(TUExit_func(vhtSes))
      else
        MessageDlg('TUExit function not found in the TUtility.DLL', mtError, [mbOK], 0);
      end;

    if TUtilDLL_handle > 0 then
      try
        {FreeLibrary(TUtilDLL_handle); - Causes access violation - DLL probably unloaded with TUExit function}
      except
        {$ifDef Win32}
        showmessage(SysErrorMessage(GetLastError));
        {$endif}
      end;
  finally 
    inherited Destroy;
  end;
end;

function TBDEUtil.GetTCursorProps(szTable: String): Boolean;
var
  TUFillCURProps_func : TUFillCURProps;
  {$ifNDef Win32}
  szTablePChar : PChar;
  {$endif}

begin
  try
    if TUtilDLL_handle > HINSTANCE_ERROR then
      begin
      {$ifDef Win32}
      TUFillCURProps_func:=TUFillCURProps(GetProcAddress(TUtilDLL_handle,'TUFillCURProps'));
      {$else}
      @TUFillCURProps_func:=GetProcAddress(TUtilDLL_handle,'TUFillCURProps');
      {$endif}

      if @TUFillCURProps_func <> nil then
        begin
        {$ifDef Win32}
        if TUFillCURProps_func(vHtSes, PChar(szTable), TUProps) = DBIERR_NONE then
        {$else}
        GetMem(szTablePChar, length(szTable)+1);
        try
          StrPCopy(szTablePChar,szTable);
          if TUFillCURProps_func(vHtSes, szTablePChar, TUProps) = DBIERR_NONE then
        {$endif}
            Result := True
          else
            result:=False;
       {$ifNDef Win32}
        finally
          FreeMem(szTablePChar, length(szTable)+1);
        end;
        {$endif}
        end
      else
        begin
        MessageDlg('TUFillCURProps function not found in the TUtility.DLL', mtError, [mbOK], 0);
        result:=False;
        end;
      end
    else
      result:=False;
  except
    result:=False;
  end;
end;

procedure TBDEUtil.RegisterCallback;
begin
  {$ifDef Win32}
  Check(DbiRegisterCallBack(nil, cbGENPROGRESS, 0,
            sizeof(TUVerifyCallBack), @CbInfo, GenProgressCallback));
  {$endif}
end;

procedure TBDEUtil.UnRegisterCallback;
begin
  {$ifDef Win32}
  Check(DbiRegisterCallBack(nil, cbGENPROGRESS, 0,
           sizeof(TUVerifyCallBack), @CbInfo, nil));
  {$endif}
end;



function TProtector.TUtilTest(aTable:TTable;CallingProcName:String):boolean;

function TUtilVerify(tableName:String):integer;
var
  TUInit_func : TUInit;
  TUExit_func : TUExit;
  TUVerifyTable_func : TUVerifyTable;
  ResultCode: Integer;
  FunctionResult : dbiResult;
  {$ifNDef Win32}
  TableNamePChar : PChar;
  {$endif}
begin
  ResultCode:=0;
  try
    if TUtilDLL_handle > HINSTANCE_ERROR then
      begin
      {$ifDef Win32}
      TUExit_func:=TUExit(GetProcAddress(TUtilDLL_handle,'TUExit'));
      {$else}
      @TUExit_func:=GetProcAddress(TUtilDLL_handle,'TUExit');
      {$endif}


      if @TUExit_func = nil then
        begin
        MessageDlg('TUExit function not found in the TUtility.DLL', mtError, [mbOK], 0);
        result:=-1;
        exit;
        end;

      Check(TUExit_func(BDEUtil.vHtSes));

      {$ifDef Win32}
      TUInit_func:=TUInit(GetProcAddress(TUtilDLL_handle,'TUInit'));
      {$else}
      @TUInit_func:=GetProcAddress(TUtilDLL_handle,'TUInit');
      {$endif}

      if @TUInit_func = nil then
        begin
        MessageDlg('TUInit function not found in the TUtility.DLL', mtError, [mbOK], 0);
        result:=-1;
        exit;
        end;

      Check(TUInit_func(BDEUtil.vHtSes));
      end
    else
      begin
      result:=-1;
      exit;
      end;

{    BDEUtil.RegisterCallBack; }

    try
      {$ifDef Win32}
      TUVerifyTable_func:=TUVerifyTable(GetProcAddress(TUtilDLL_handle,'TUVerifyTable'));
      FunctionResult:=TUVerifyTable_func(BDEUtil.vHtSes, PChar(TableName), szPARADOX, 'VERIFY.DB',
           nil, 0, ResultCode);
      if FunctionResult <> DBIERR_NONE then
         LogTUError(TUtilDLL_handle,FunctionResult,'Table: '+tableName,CallingProcName);

      {$else}
      @TUVerifyTable_func:=GetProcAddress(TUtilDLL_handle,'TUVerifyTable');
      GetMem(TableNamePChar,length(TableName)+1);
      try
        StrPCopy(TableNamePChar,TableName);
        FunctionResult:=TUVerifyTable_func(BDEUtil.vHtSes, TableNamePChar, szPARADOX, 'VERIFY.DB',
             nil, 0, ResultCode);
        if FunctionResult <> DBIERR_NONE then
          LogTUError(TUtilDLL_handle,FunctionResult,'Table: '+tableName,CallingProcName);
      finally
        FreeMem(TableNamePChar,length(TableName)+1);
      end;
      {$endif}

        begin
(*         case ResultCode of
            0: ShowMessage( 'Verification Successful. Table has no errors.');
            1: ShowMessage( 'Verification completed. Table is damaged.');
            2: ShowMessage( 'Verification not completed. Table is damaged.');
            3: ShowMessage( 'Verification completed. Table header is corrupt.');
            4: ShowMessage( 'Verification Successful. Table is corrupt and cannot be rebuilt.');
          else
             ShowMessage( 'Unable to verify table.');
          end; *)
        end;
    finally
    {  BDEUtil.UnRegisterCallBack;}
    end;
  finally
    result:=ResultCode;
  end;
end;

var
   vDBDesc: DBDesc;
   {$ifNDef Win32}
   databaseNamePChar : PChar;
   {$endif}
Begin
   result:=True; {initialize}
   CallingProcName:='TUtilTest called by '+CallingProcName;
(*   Showmessage('"'+aTable.tableName+'" table seems OK, will now try TUtility.DLL (dynamically loaded)'); *)

   {$ifDef Win32}
   Check(DbiGetDatabaseDesc(PChar(aTable.databaseName), @vDBDesc));
   {$else}
   GetMem(databaseNamePChar,length(aTable.databaseName)+1);
   try
     StrPCopy(databaseNamePChar,aTable.databaseName);
     Check(DbiGetDatabaseDesc(databaseNamePChar, @vDBDesc));
   finally
     FreeMem(databaseNamePChar,length(aTable.databaseName)+1);
   end;
   {$endif}

   if TUtilVerify(Format('%s\%s', [vDBDesc.szPhyName, aTable.tableName])) >0 then
     begin
     Application.ProcessMessages;
(*     showmessage('Error value returned from TUtility.DLL for verify of table: "'+aTable.tableName+'" '); *)
     result:=False;
     end;
end;


function TProtector.TUtilRepair(aTable, aBackupTable:TTable;CallingProcName:String):boolean;

function TUtilRebuild(tableName, backuptableName:String):integer;
var
  {$ifNDef Win32}
  PBackup, pKEYVIOL, pPROBLEM,
  TableNamePChar : PChar;
  {$endif}
  isBackupAvailable,
  isUsingBackup : Boolean;
  iFld, iIdx, iSec, iVal, iRI, iOptP, iOptD: word;
  rslt,rslt2: DBIResult;
  ResultCode: Integer;
  TblDesc: CRTBlDesc;
  Backup: String;
  TUInit_func : TUInit;
  TUExit_func : TUExit;
  TUVerifyTable_func : TUVerifyTable;
  TUGetCRTblDescCount_Func : TUGetCRTblDescCount;
  TUFillCRTblDesc_Func : TUFillCRTblDesc;
  TURebuildTable_Func : TURebuildTable;
begin
  rslt :=99; {initialize}
  result:=-1;
  try
    if backuptableName='NO_BACKUP' then
      begin
      isBackupAvailable :=False;
      end
    else
      Begin
      isBackupAvailable :=True;
      end;

    isUsingBackup := False; {initialize}

    if TUtilDLL_handle > HINSTANCE_ERROR then
      begin
      {$ifDef Win32}
      TUExit_func:=TUExit(GetProcAddress(TUtilDLL_handle,'TUExit'));
      {$else}
      @TUExit_func:=GetProcAddress(TUtilDLL_handle,'TUExit');
      {$endif}


      if @TUExit_func = nil then
        begin
        MessageDlg('TUExit function not found in the TUtility.DLL', mtError, [mbOK], 0);
        result:=-1;
        exit;
        end;

      Check(TUExit_func(BDEUtil.vHtSes));

      {$ifDef Win32}
      TUInit_func:=TUInit(GetProcAddress(TUtilDLL_handle,'TUInit'));
      {$else}
      @TUInit_func:=GetProcAddress(TUtilDLL_handle,'TUInit');
      {$endif}

      if @TUInit_func = nil then
        begin
        MessageDlg('TUInit function not found in the TUtility.DLL', mtError, [mbOK], 0);
        result:=-1;
        exit;
        end;

      Check(TUInit_func(BDEUtil.vHtSes));
      end
    else
      begin
      result:=-1;
      exit;
      end;

{    BDEUtil.RegisterCallBack; }
    try
    {$ifDef Win32}
      TUVerifyTable_func:=TUVerifyTable(GetProcAddress(TUtilDLL_handle,'TUVerifyTable'));
      TUGetCRTblDescCount_Func:=TUGetCRTblDescCount(GetProcAddress(TUtilDLL_handle,'TUGetCRTblDescCount'));

      if isBackupAvailable then
        begin
        if TUVerifyTable_func(BDEUtil.vHtSes, PChar(BackupTableName), szPARADOX, 'VERIFY.DB',
           nil, 0, ResultCode) = DBIERR_NONE then
          begin
          rslt := TUGetCRTblDescCount_Func(BDEUtil.vhTSes, PChar(BackupTableName), iFld,
              iIdx, iSec, iVal, iRI, iOptP, iOptD);
          if rslt = DBIERR_NONE then
            isUsingBackup := True
          else
            LogTUError(TUtilDLL_handle,Rslt,'TUGetCRTblDescCount failed on Table: '+BackuptableName,CallingProcName);
          end;
        end;

      if NOT isUsingBackup then
        begin
        rslt:= TUVerifyTable_func(BDEUtil.vHtSes, PChar(TableName), szPARADOX, 'VERIFY.DB',
           nil, 0, ResultCode);
        if rslt = DBIERR_NONE then
          begin
          rslt := TUGetCRTblDescCount_Func(BDEUtil.vhTSes, PChar(TableName), iFld,
             iIdx, iSec, iVal, iRI, iOptP, iOptD);
          if rslt <> DBIERR_NONE then
            begin
            LogTUError(TUtilDLL_handle,Rslt,'TUGetCRTblDescCount failed on Table: '+tableName,CallingProcName);
            end;
          end
        else
          LogTUError(TUtilDLL_handle,Rslt,'TUVerifyTable failed on Table: '+tableName,CallingProcName);
        end;

    {$else}

      @TUVerifyTable_func:=GetProcAddress(TUtilDLL_handle,'TUVerifyTable');
      @TUGetCRTblDescCount_Func:=GetProcAddress(TUtilDLL_handle,'TUGetCRTblDescCount');

      GetMem(TableNamePChar,length(TableName)+1);
      try

        if isBackupAvailable then
          Begin
          StrPCopy(TableNamePChar,BackupTableName);
          if TUVerifyTable_func(BDEUtil.vHtSes, TableNamePChar, szPARADOX, 'VERIFY.DB',
               nil, 0, ResultCode) = DBIERR_NONE then
            begin
            rslt := TUGetCRTblDescCount_Func(BDEUtil.vhTSes, TableNamePChar, iFld,
               iIdx, iSec, iVal, iRI, iOptP, iOptD);
            if rslt = DBIERR_NONE then
              isUsingBackup := True
            else
              LogTUError(TUtilDLL_handle,Rslt,'TUGetCRTblDescCount failed on Table: '+BackuptableName,CallingProcName);
            end;
          end;

      if NOT isUsingBackup then
        begin
        StrPCopy(TableNamePChar,TableName);
        rslt:= TUVerifyTable_func(BDEUtil.vHtSes, TableNamePChar, szPARADOX, 'VERIFY.DB',
             nil, 0, ResultCode);
        if rslt = DBIERR_NONE then
          begin
          rslt := TUGetCRTblDescCount_Func(BDEUtil.vhTSes, TableNamePChar, iFld,
              iIdx, iSec, iVal, iRI, iOptP, iOptD);
          if rslt <> DBIERR_NONE then
            begin
            LogTUError(TUtilDLL_handle,Rslt,'TUGetCRTblDescCount failed on Table: '+tableName,CallingProcName);
            end;
          end
        else
          LogTUError(TUtilDLL_handle,Rslt,'TUVerifyTable failed on Table: '+tableName,CallingProcName);
        end;


      finally
        FreeMem(TableNamePChar,length(TableName)+1);
      end;
    {$endif}


      if rslt = DBIERR_NONE then
        begin
        FillChar(TblDesc, SizeOf(CRTBlDesc), 0);

        StrPCopy(TblDesc.szTblName, TableName);

      {$ifDef Win32}
        TblDesc.szTblType := szParadox;
        TblDesc.szErrTblName := ErrorTblName;
      {$else}
        StrCopy(TblDesc.szTblType, szPARADOX);
        StrCopy(TblDesc.szErrTblName,ErrorTblName);
      {$endif}

        TblDesc.iFldCount := iFld;
        GetMem(TblDesc.pFldDesc, (iFld * SizeOf(FldDesc)));

        TblDesc.iIdxCount := iIdx;
        GetMem(TblDesc.pIdxDesc, (iIdx * SizeOf(IdxDesc)));

        TblDesc.iSecRecCount := iSec;
        GetMem(TblDesc.pSecDesc, (iSec * SizeOf(SecDesc)));

        TblDesc.iValChkCount := iVal;
        GetMem(TblDesc.pvchkDesc, (iVal * SizeOf(VCHKDesc)));

        TblDesc.iRintCount := iRI;
        GetMem(TblDesc.printDesc, (iRI * SizeOf(RINTDesc)));

        TblDesc.iOptParams := iOptP;
        GetMem(TblDesc.pfldOptParams, (iOptP * sizeOf(FLDDesc)));

        GetMem(TblDesc.pOptData, (iOptD * DBIMAXSCFLDLEN));


        try

    {$ifDef Win32}
          TUFillCRTblDesc_Func:=TUFillCRTblDesc(GetProcAddress(TUtilDLL_handle,'TUFillCRTblDesc'));
          TURebuildTable_Func:=TURebuildTable(GetProcAddress(TUtilDLL_handle,'TURebuildTable'));

          if isUsingBackup then
            rslt := TUFillCRTblDesc_Func(BDEUtil.vhTSes, @TblDesc, PChar(BackupTableName), nil)
          else
            rslt := TUFillCRTblDesc_Func(BDEUtil.vhTSes, @TblDesc, PChar(TableName), nil);

          if rslt = DBIERR_NONE then
            begin
            rslt2:=TURebuildTable_func(BDEUtil.vhTSes, PChar(TableName), szPARADOX,
                 PChar(BackupTblName), pChar(KeyViolTblName), pChar(ProblemTblName), @TblDesc);

            LogTUError(TUtilDLL_handle,Rslt2,'TURebuildTable (TUtility DLL table rebuild) on Table: '+
                    tableName,CallingProcName);

            if rslt2 = DBIERR_NONE then
               result:=0
             else
               result:=1;
             end
          else
            begin
            result:=2;
            LogTUError(TUtilDLL_handle,Rslt,'TUFillCRTblDesc failed on Table: '+tableName,CallingProcName);
            end;

    {$else}
          @TUFillCRTblDesc_Func:=GetProcAddress(TUtilDLL_handle,'TUFillCRTblDesc');
          @TURebuildTable_Func:=GetProcAddress(TUtilDLL_handle,'TURebuildTable');

          GetMem(TableNamePChar,length(TableName)+1);
          try

            if isUsingBackup then
              StrPCopy(TableNamePChar,BackupTableName)
            else
              StrPCopy(TableNamePChar,TableName);

            rslt := TUFillCRTblDesc_Func(BDEUtil.vhTSes, @TblDesc, TableNamePChar, nil);

           if rslt = DBIERR_NONE then
             begin
             GetMem(pBackup,length(BackupTblName)+1);
             GetMem(pKeyViol,length(KeyViolTblName)+1);
             GetMem(pProblem,length(ProblemTblName)+1);
             try
               StrPCopy(pBackup,BackupTblName);
               StrPCopy(pKeyViol,KeyViolTblName);
               StrPCopy(pProblem,ProblemTblName);

               rslt2:=TURebuildTable_Func(BDEUtil.vhTSes, TableNamePChar, szPARADOX,
                   pBackup, pKEYVIOL, pPROBLEM, @TblDesc);

               LogTUError(TUtilDLL_handle,Rslt2,'TURebuildTable (TUtility DLL table rebuild) on Table: '+
                        tableName,CallingProcName);

               if rslt2 = DBIERR_NONE then
                 result:=0
               else
                 begin
                 result:=1;
                 end;
             finally
             FreeMem(pBackup,length(BackupTblName)+1);
             FreeMem(pKeyViol,length(KeyViolTblName)+1);
             FreeMem(pProblem,length(ProblemTblName)+1);
             end;
             end
           else
             begin
             result:=2;
             LogTUError(TUtilDLL_handle,Rslt,'TUFillCRTblDesc failed on Table: '+tableName,CallingProcName);
             end;

          finally
            FreeMem(TableNamePChar,length(TableName)+1);
          end;
    {$endif}


        finally
          FreeMem(TblDesc.pFldDesc, (iFld * SizeOf(FldDesc)));
          FreeMem(TblDesc.pIdxDesc, (iIdx * SizeOf(IdxDesc)));
          FreeMem(TblDesc.pSecDesc, (iSec * SizeOf(SecDesc)));
          FreeMem(TblDesc.pvchkDesc, (iVal * SizeOf(VCHKDesc)));
          FreeMem(TblDesc.printDesc, (iRI * SizeOf(RINTDesc)));
          FreeMem(TblDesc.pfldOptParams, (iOptP * sizeOf(FLDDesc)));
          FreeMem(TblDesc.pOptData, (iOptD * DBIMAXSCFLDLEN));
        end;
      end;
    finally
{      BDEUtil.UnRegisterCallBack; }
    end;
  finally
{}
  end;
end;

var
   vDBDesc, vDBbackupDesc: DBDesc;
   resultCode : integer;
   tableName,backupTableName,
   MessageStr : String;
   {$ifNDef Win32}
   databaseNamePChar : PChar;
   {$endif}
   AliasParams : TStrings;
   AliasString,
   DirString    : String;

Begin
   CallingProcName:='TUtilRepair called by '+CallingProcName;

{  Check(dbiInit(Nil));
  tmpDB:=TDatabase.create(self);
  try
    rslt:=DbiSetDirectory(tmpDB.handle,PChar('k:\dvpwin\laytally'));
    if rslt=DBIERR_NONE then
      showmessage('no error with k path');
    rslt:=DbiSetDirectory(tmpDB.handle,PChar('\\acsi410\APPS:\dvpwin\laytally'));
    if rslt=DBIERR_NONE then
      showmessage('no error with UNC path');
  finally
    tmpDB.free;
  end; }

  AliasParams:=TStringList.create;
  try
     AliasString:=aTable.databaseName;
     Session.GetAliasParams(AliasString, AliasParams);
     DirString:=Copy(AliasParams.Strings[0],6,60);
     {$ifDef Win32}
     SetCurrentDir(DirString); {this is necessary to make TUtil32.DLL rebuild correctly }
                               {when working with tables located on a network (esp. with}
                               {Novell client software for WIndoes (????)               }
     {$else}
     ChDir(DirString);
     {$endif}
     Application.processmessages;
   finally
      AliasParams.Free;
   end;

   {$ifDef Win32}
   Check(DbiGetDatabaseDesc(PChar(aTable.databaseName), @vDBDesc));
   if aBackupTable<>nil then
     Check(DbiGetDatabaseDesc(PChar(aBackupTable.databaseName), @vDBbackupDesc));
   {$else}
   GetMem(databaseNamePChar,length(aTable.databaseName)+1);
   try
     StrPCopy(databaseNamePChar,aTable.databaseName);
     Check(DbiGetDatabaseDesc(databaseNamePChar, @vDBDesc));
   finally
     FreeMem(databaseNamePChar,length(aTable.databaseName)+1);
   end;
   if aBackupTable<>nil then
     Begin
   GetMem(databaseNamePChar,length(aBackupTable.databaseName)+1);
   try
     StrPCopy(databaseNamePChar,aBackupTable.databaseName);
     if aBackupTable<>nil then
       begin
       StrPCopy(databaseNamePChar,aBackupTable.databaseName);
       Check(DbiGetDatabaseDesc(databaseNamePChar, @vDBbackupDesc));
       end;
     finally
       FreeMem(databaseNamePChar,length(aBackupTable.databaseName)+1);
     end;
     end;
   {$endif}

   tableName:=Format('%s\%s', [vDBDesc.szPhyName, aTable.tableName]);

   if (aBackupTable=nil) then
     backupTableName:='NO_BACKUP'
   else if (aBackupTable.tableName='') then
     backupTableName:='NO_BACKUP'
   else
     backupTableName:=Format('%s\%s', [vDBbackupDesc.szPhyName, abackupTable.tableName]);

   resultCode:=TUtilRebuild(tableName,backupTableName);

   Application.ProcessMessages;

   if resultCode =0 then
     begin
     MessageStr := 'Rebuild was successful.';
     result:=True;
     end
   else
     begin
{     showmessage('Error value returned from TUtility.DLL for repair of table: "'+aTable.tableName+'" '); }
{     case resultCode of
       -1: MessageStr := 'Error: TUtility DLL not loaded.';
       0: MessageStr := 'Rebuild was successful.';
       1: MessageStr := 'Rebuild was NOT successful.';
       2: MessageStr := 'Error Filling table structure in preparation for rebuild';
     else
       MessageStr := 'Unknown error in rebuild procedure';
     end; }

     result:=False;
     end;
end;


end.
