unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, xfer_32, StdCtrls;

type
  TForm1 = class(TForm)
    Xfer1: TXfer;
    MainMenu1: TMainMenu;
    Port1: TMenuItem;
    BaudRate1: TMenuItem;
    NOPORT1: TMenuItem;
    COM11: TMenuItem;
    COM21: TMenuItem;
    COM31: TMenuItem;
    COM41: TMenuItem;
    N24001: TMenuItem;
    N48001: TMenuItem;
    N96001: TMenuItem;
    N144001: TMenuItem;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Memo2: TMemo;
    Button1: TButton;
    GroupBox1: TGroupBox;
    lblSent: TLabel;
    lblReceived: TLabel;
    lblEvent: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Xfer1Receive(Sender: TObject; count: Word);
    procedure Xfer1Transmit(Sender: TObject; count: Word);
    procedure NOPORT1Click(Sender: TObject);
    procedure N24001Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Xfer1Error(Sender: TObject; err: string);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Xfer1CommEvent(Sender: TObject; event: TCommEvent);
  private
    procedure UpdateMenu;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.UpdateMenu;
var
  btnID: char;
begin
  Port1.Items[Ord(Xfer1.Port)].Checked := True;
  BaudRate1.Items[Ord(Xfer1.BaudRate) -
                  Ord(___2400)].Checked := True;
  for btnID := '2' to '9' do
    (FindComponent('Button' + btnID) as TButton).Enabled :=
                  Xfer1.Port <> NO_PORT;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  data: string;
begin
  Memo2.Clear;
  data := Memo1.Text;
  Xfer1.Write(data, Length(data));
  Memo1.Clear;
end;

procedure TForm1.Xfer1Receive(Sender: TObject; count: Word);
var
  data: string;
begin
  Xfer1.Read(data, count);
  Memo2.Text := data;
  lblReceived.Caption := IntToStr(Length(data)) + ' bytes received';
end;

procedure TForm1.Xfer1Transmit(Sender: TObject; count: Word);
begin
  lblSent.Caption := IntToStr(count) + ' bytes sent';
end;

procedure TForm1.NOPORT1Click(Sender: TObject);
var
  p: TPort;
begin
  p := NO_PORT;
  Inc(p, (Sender as TMenuItem).Tag);
  Xfer1.Port := p;
  UpdateMenu;
end;

procedure TForm1.N24001Click(Sender: TObject);
var
  b: TBaudRate;
begin
  b := ___2400;
  Inc(b, (Sender as TMenuItem).Tag);
  Xfer1.BaudRate := b;
  UpdateMenu;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  lblSent.Caption := '';
  lblReceived.Caption := '';
  lblEvent.Caption := '';
  UpdateMenu;
end;

procedure TForm1.Xfer1Error(Sender: TObject; err: string);
begin
  ShowMessage(err);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if not Xfer1.ClearDTR then
    ShowMessage('ClearDTR method failed');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if not Xfer1.SetDTR then
    ShowMessage('SetDTR method failed');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if not Xfer1.SetRTS then
    ShowMessage('SetRTS method failed');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if not Xfer1.ClearRTS then
    ShowMessage('ClearRTS method failed');
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  if not Xfer1.SetXOn then
    ShowMessage('SetXOn method failed');
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  if not Xfer1.SetXOff then
    ShowMessage('SetOff method failed');
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  if not Xfer1.SetBreak then
    ShowMessage('SetBreak method failed');
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  if not Xfer1.ClearBreak then
    ShowMessage('ClearBreak method failed');
end;

procedure TForm1.Xfer1CommEvent(Sender: TObject; event: TCommEvent);
begin
  case event of
    ceBREAK: lblEvent.Caption := 'Event: ceBREAK';
    ceCTS: lblEvent.Caption := 'Event: ceCTS';
    ceDSR: lblEvent.Caption := 'Event: ceDSR';
    ceERR: lblEvent.Caption := 'Event: ceERR';
    ceRING: lblEvent.Caption := 'Event: ceRING';
    ceRLSD: lblEvent.Caption := 'Event: ceRLSD';
    ceTXEMPTY: lblEvent.Caption := 'Event: ceTXEMPTY';
  end;
end;

end.
