unit Tray1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin, ExtCtrls, DComm95, Menus;

type
  TForm1 = class(TForm)
    RadioGroup1: TRadioGroup;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    Edit1: TEdit;
    Label2: TLabel;
    Panel1: TPanel;
    DCSystemTray1: TDCSystemTray;
    PopupMenu1: TPopupMenu;
    Test11: TMenuItem;
    Test21: TMenuItem;
    Exit1: TMenuItem;
    procedure BitBtn1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure DCSystemTray1Click(Sender: TObject);
    procedure DCSystemTray1DblClick(Sender: TObject);
    procedure DCSystemTray1RightClick(Sender: TObject);
    procedure DCSystemTray1RightDblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  DCSystemTray1.Active := not DCSystemTray1.Active;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  DCSystemTray1.State := TTrayState(RadioGroup1.ItemIndex);
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  DCSystemTray1.AnimationDelay := SpinEdit1.Value;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  DCSystemTray1.ShowHint := CheckBox1.Checked;
  DCSystemTray1.Hint := Edit1.Text;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  DCSystemTray1.Hint := Edit1.Text;
end;

procedure TForm1.DCSystemTray1Click(Sender: TObject);
begin
  Panel1.Caption := 'Single left click';
end;

procedure TForm1.DCSystemTray1DblClick(Sender: TObject);
begin
  Panel1.Caption := 'Double left click';
end;

procedure TForm1.DCSystemTray1RightClick(Sender: TObject);
begin
  Panel1.Caption := 'Single right click';
end;

procedure TForm1.DCSystemTray1RightDblClick(Sender: TObject);
begin
  Panel1.Caption := 'Double right click';
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  DCSystemTray1.EnabledIcon.LoadFromFile('ENABLED.ICO');
  DCSystemTray1.DisabledIcon.LoadFromFile('DISABLED.ICO');
  DCSystemTray1.IconList.Add('SMILEY1.ICO');
  DCSystemTray1.IconList.Add('SMILEY2.ICO');
  DCSystemTray1.IconList.Add('SMILEY3.ICO');
  DCSystemTray1.IconList.Add('SMILEY4.ICO');
  DCSystemTray1.IconList.Add('SMILEY5.ICO');
end;

end.
