(*
   TdkwCommandButton

   The CommandButton runs a Windows program in response to button
   presses

   (c) 1995 by DKW Systems Corporation, All Rights Reserved.

   Change History:

     May 27, 1995
       BWS - Original version written by Blake Stone

     Sept 17, 1995
       BWS - Added OnFail event and CommandStyle property
*)

unit DKWCBtn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TdkwCommandButtonStyle = ( cbShow, cbHide, cbMinimize ) ;

  TdkwCommandButton = class(TButton)
  private
    { Private declarations }
    FCommand: String ;
    FCommandStyle: TdkwCommandButtonStyle ;
    FOnFail: TNotifyEvent ;
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure Click ; override ;
  published
    { Published declarations }
    property Command: String read FCommand write FCommand ;
    property CommandStyle: TdkwCommandButtonStyle read FCommandStyle write FCommandStyle default cbShow ;
    property OnFail: TNotifyEvent read FOnFail write FOnFail ;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('DKW', [TdkwCommandButton]);
end;

(* Convert the command to a null-terminated string and execute *)

procedure TdkwCommandButton.Click ;
var
  szCommand: Array [ 0 .. 255 ] of Char ;
  Style: Word ;
begin
  StrPCopy ( szCommand, FCommand ) ;

  (* Translate our enumerated type into a Windows argument *)

  case FCommandStyle of
    cbShow: Style := SW_SHOW ;
    cbHide: Style := SW_HIDE ;
    cbMinimize: Style := SW_MINIMIZE ;
  end ;

  (* Notify our delgate of failure to launch *)

  if WinExec ( szCommand, Style ) < 32 then
    if Assigned ( FOnFail ) then FOnFail ( self ) ;
end;

end.

