(*
   TdkwDBGridPlus

   The GridPlus adds automatic post behavior when losing
   the focus

   (c) 1995 by DKW Systems Corporation, All Rights Reserved.

   Change History:

     Dec 8, 1995
       BWS - Original version written by Blake Stone
*)

unit DKWGrid ;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, DBGrids, DB ;

type
  TdkwDBGridPlusOption = ( dgpPostOnExit ) ;
  TdkwDBGridPlusOptions = set of TdkwDBGridPlusOption ;

  TdkwDBGridPlus = class(TDBGrid)
  private
    { Private declarations }
    FOptionsPlus: TdkwDBGridPlusOptions ;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create ( AOwner: TComponent ) ; override ;
    procedure DoExit ; override ;
  published
    { Published declarations }
    property OptionsPlus: TdkwDBGridPlusOptions read FOptionsPlus write FOptionsPlus
      default [ dgpPostOnExit ] ;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('DKW', [TdkwDBGridPlus]);
end;

procedure TdkwDBGridPlus.DoExit ;
begin
  if dgpPostOnExit in FOptionsPlus then
    if DataSource <> nil then
      if DataSource.State in [ dsEdit, dsInsert ] then
        if DataSource.DataSet <> nil then
          DataSource.DataSet.Post ;

  inherited DoExit ;
end ;

constructor TdkwDBGridPlus.Create ( AOwner: TComponent ) ;
begin
  inherited Create ( AOwner ) ;
  OptionsPlus := [ dgpPostOnExit ] ;
end ;

end.

