unit Testmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Graph, StdCtrls, ExtCtrls ;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Test1: TMenuItem;
    Draw1: TMenuItem;
    Remove1: TMenuItem;
    add1: TMenuItem;
    N1: TMenuItem;
    Draw2: TMenuItem;
    N2: TMenuItem;
    AxisInvisible1: TMenuItem;
    AxisVisible1: TMenuItem;
    LayerInvisible1: TMenuItem;
    LayerVisible1: TMenuItem;
    N3: TMenuItem;
    ShortGraph1: TMenuItem;
    LongGraph1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure Draw1Click(Sender: TObject);
    procedure Remove1Click(Sender: TObject);
    procedure add1Click(Sender: TObject);
    procedure Draw2Click(Sender: TObject);
    procedure AxisInvisible1Click(Sender: TObject);
    procedure AxisVisible1Click(Sender: TObject);
    procedure LayerInvisible1Click(Sender: TObject);
    procedure LayerVisible1Click(Sender: TObject);
    procedure ShortGraph1Click(Sender: TObject);
    procedure LongGraph1Click(Sender: TObject);
  private
    { Private declarations }
    Graph: TdkwGraph ;
    LineGraph1, LineGraph2: TdkwLineGraphLayer ;
    BarGraph: TdkwBarGraphLayer ;
    HiLowGraph: TdkwHiLowGraphLayer ;
    TimeAxis, DateAxis: TdkwHorizontalGraphAxis ;
    TempAxis, WindAxis: TdkwVerticalGraphAxis ;
  public
    { Public declarations }
    procedure DateLabel ( Sender: TObject ; Index: Integer ;
        var AxisLabel: String ) ;
    procedure BarColor ( Sender: TObject ; Index: Integer ;
        var BarColor: TColor ) ;
    procedure LineColor ( Sender: TObject ; Index: Integer ;
        var LineColor: TColor ) ;
    procedure GraphClick ( Sender: TObject ; Index: Integer ) ;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DateLabel ( Sender: TObject ; Index: Integer ;
    var AxisLabel: String ) ;
begin
  AxisLabel := FormatDateTime ( 'mmmd', Now + Index ) ;
end ;

procedure TForm1.BarColor ( Sender: TObject ; Index: Integer ;
    var BarColor: TColor ) ;
begin
  if DayOfWeek ( Now + Index ) = 1 then
    BarColor := clBlue ;
  if DayOfWeek ( Now + Index ) = 7 then
    BarColor := clBlue ;
end ;

procedure TForm1.LineColor ( Sender: TObject ; Index: Integer ;
    var LineColor: TColor ) ;
begin
  if Index Mod 2 = 0 then
    LineColor := clWhite ;
end ;

procedure TForm1.GraphClick ( Sender: TObject ; Index: Integer ) ;
begin
  ShowMessage ( 'Clicked at index ' + IntToStr ( Index ) ) ;
end ;

procedure TForm1.FormCreate(Sender: TObject);
const
  TimeCount = 96 * 15 + 1 ;
  DayCount = 16 ;
var
  Index: Integer ;
begin
  Randomize ;

  { Create axes for the graph }

  TimeAxis := TdkwHorizontalGraphAxis.Create ;
  with TimeAxis do
  begin
    Minimum := 0 ;
    Maximum := TimeCount - 1 ;
    MinorTick := 16 ;
    MajorTick := 96 ;
  end ;

  DateAxis := TdkwHorizontalGraphAxis.Create ;
  with DateAxis do
  begin
    Minimum := 0 ;
    Maximum := DayCount - 1 ;
    OnLabel := DateLabel ;
  end ;

  TempAxis := TdkwVerticalGraphAxis.Create ;

  WindAxis := TdkwVerticalGraphAxis.Create ;
  WindAxis.Color := clWhite ;

  { Create the layers }

  LineGraph1 := TdkwLineGraphLayer.Create ;
  with LineGraph1 do
  begin
    for Index := 0 to TimeCount - 1 do
      Data [ Index ] := Round ( Sin ( Index / 100 ) * 50 + 50 ) + Random ( 5 ) - 3 ;
    Color := clBlue ;
    XAxis := TimeAxis ;
    YAxis := TempAxis ;

    { This slows things down brutally with this
      many points, but it DOES work if uncommented }

    { OnColor := LineColor ; }
  end ;

  HiLowGraph := TdkwHiLowGraphLayer.Create ;
  with HiLowGraph do
  begin
    for Index := 0 to DayCount - 1 do
    begin
      DataLow [ Index ] := 22;{Random ( 10 ) ;}
      DataHigh [ Index ] := 22;{Random ( 10 ) ;}
      while ( DataLow [ Index ] > DataHigh [ Index ] ) do
      begin
        DataLow [ Index ] := Random ( 100 ) ;
        DataHigh [ Index ] := Random ( 100 ) ;
      end ;
    end ;
    Color := clWhite ;
    XAxis := DateAxis ;
    YAxis := WindAxis ;
    OnColor := BarColor ;
  end ;

  BarGraph := TdkwBarGraphLayer.Create ;
  with BarGraph as TdkwBarGraphLayer do
  begin
    for Index := 0 to DayCount - 1 do
      Data [ Index ] := Random ( 100 ) ;
    Color := clRed ;
    XAxis := DateAxis ;
    YAxis := TempAxis ;
  end ;

  LineGraph2 := TdkwLineGraphLayer.Create ;
  with LineGraph2 do
  begin
    for Index := 0 to TimeCount - 1 do
      Data [ Index ] := Round ( Sin ( Index / 70 ) * 100 + 100 ) + Random ( 20 ) ;
    Color := clBlack ;
    XAxis := TimeAxis ;
    YAxis := TempAxis ;
  end ;

  { Create the graph }

  Graph := TdkwGraph.Create ( self ) ;
  with Graph do
  begin
    AddAxis ( 'Time', TimeAxis ) ;
    AddAxis ( 'Date', DateAxis ) ;
    AddAxis ( 'Temperature', TempAxis ) ;
    AddAxis ( 'Wind Speed', WindAxis ) ;
    AddLayer ( 'TestBar', BarGraph ) ;
    AddLayer ( 'TestLine', LineGraph1 ) ;
    AddLayer ( 'TestHiLow', HiLowGraph ) ;
    AddLayer ( 'TestBar2', LineGraph2 ) ;
    FixedWidth := 1440 ;
    Parent := self ;
    Align := alClient ;
    OnClick := GraphClick ;
  end ;
end ;

procedure TForm1.Draw1Click(Sender: TObject);
begin
  Graph.Restructure ;
end;

procedure TForm1.Remove1Click(Sender: TObject);
begin
  Graph.RemoveLayer ( LineGraph2 ) ;
  Graph.Refresh ;
end;

procedure TForm1.add1Click(Sender: TObject);
begin
  Graph.AddLayer ( 'SampleTwo', LineGraph2 ) ;
  Graph.Refresh ;
end;

procedure TForm1.Draw2Click(Sender: TObject);
begin
  Graph.Refresh ;
end;

procedure TForm1.AxisInvisible1Click(Sender: TObject);
begin
  DateAxis.Visible := False ;
  Graph.Restructure ;
end;

procedure TForm1.AxisVisible1Click(Sender: TObject);
begin
  DateAxis.Visible := True ;
  Graph.Restructure ;
end;

procedure TForm1.LayerInvisible1Click(Sender: TObject);
begin
  HiLowGraph.Visible := False ;
  Graph.Restructure ;
end;

procedure TForm1.LayerVisible1Click(Sender: TObject);
begin
  HiLowGraph.Visible := True ;
  Graph.Restructure ;
end;

procedure TForm1.ShortGraph1Click(Sender: TObject);
begin
  TimeAxis.Minimum := 96 ;
  TimeAxis.Maximum := 192 ;
  Graph.FixedWidth := 96 ;
  Graph.Restructure ;
end;

procedure TForm1.LongGraph1Click(Sender: TObject);
begin
  TimeAxis.Minimum := 0 ;
  TimeAxis.Maximum := 1440 ;
  Graph.FixedWidth := 1440 ;
  Graph.Restructure ;
end;

end.

