unit Dragdrop;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Dropfile, ExtCtrls, Menus, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ComboBox1: TComboBox;
    FontDialog1: TFontDialog;
    PopupMenu1: TPopupMenu;
    Font1: TMenuItem;
    PrinterSetup1: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    PrintSetup: TPrinterSetupDialog;
    FileDropEnabled1: TMenuItem;
    N2: TMenuItem;
    DropFile1: TDropFile;
    Memo1: TRichEdit;
    PrintDialog1: TPrintDialog;
    WordWrap1: TMenuItem;
    N3: TMenuItem;
    procedure DropFile1DropFile(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure PrinterSetup1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure FileDropEnabled1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure WordWrap1Click(Sender: TObject);
    procedure Panel1Resize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DropFile1DropFile(Sender: TObject);
begin
  combobox1.items := dropfile1.filelist;
  combobox1.itemindex := 0;
  combobox1change(self);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  memo1.lines.loadfromfile(combobox1.items[combobox1.itemindex]);
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  FontDialog1.Font := Memo1.Font;
  if FontDialog1.Execute then Memo1.Font := FontDialog1.Font;
end;

procedure TForm1.PrinterSetup1Click(Sender: TObject);
begin
  PrintSetup.Execute;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.PopupMenu1Popup(Sender: TObject);
begin
  Print1.enabled := Memo1.Lines.Count > 0;
end;

procedure TForm1.FileDropEnabled1Click(Sender: TObject);
begin
  with FileDropEnabled1 do begin
    Checked := not Checked;
    DropFile1.Active := Checked;
  end;
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
  if PrintDialog1.Execute then
    Memo1.Print(combobox1.items[combobox1.itemindex]);
end;

procedure TForm1.WordWrap1Click(Sender: TObject);
begin
  with WordWrap1 do begin
    Checked := not Checked;
    Memo1.WordWrap := Checked;
  end;
end;

procedure TForm1.Panel1Resize(Sender: TObject);
begin
  ComboBox1.Width := Panel1.Width - 2 - 2 * ComboBox1.Left;
end;

end.
