 unit TTSCMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, TLips, StdCtrls, ComCtrls, Speech, TTS, ModeDlg,
  AuDevDlg;

type
  TFormMain = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    RichEdit1: TRichEdit;
    Panel1: TPanel;
    ButtonSpeak: TButton;
    TabSheet3: TTabSheet;
    StatusBar1: TStatusBar;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    edLexGet: TEdit;
    btLexGet: TButton;
    lbLexGet: TLabel;
    btPauseResume: TButton;
    btReset: TButton;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    TrackBarPitch: TTrackBar;
    Label2: TLabel;
    TrackBarRealTime: TTrackBar;
    TrackBarVolumeR: TTrackBar;
    TrackBarVolumeL: TTrackBar;
    TrackBarSpeed: TTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lbPitch: TLabel;
    lbRealTime: TLabel;
    lbSpeed: TLabel;
    lbVolumeL: TLabel;
    lbVolumeR: TLabel;
    Label7: TLabel;
    lbPitchMin: TLabel;
    lbRealTimeMin: TLabel;
    lbSpeedMin: TLabel;
    lbVolumeLMin: TLabel;
    lbVolumeRMin: TLabel;
    Label13: TLabel;
    lbPitchMax: TLabel;
    lbRealTimeMax: TLabel;
    lbSpeedMax: TLabel;
    lbVolumeLMax: TLabel;
    lbVolumeRMax: TLabel;
    btActive: TButton;
    btEngineMode: TButton;
    btAudioDevice: TButton;
    lbActiveStatus: TLabel;
    lbEngineMode: TLabel;
    lbAudioDevice: TLabel;
    GroupBox3: TGroupBox;
    bConvertToPhoneme: TButton;
    RichEdit2: TRichEdit;
    rgCharSets: TRadioGroup;
    Panel2: TPanel;
    cbxCtrlTags: TCheckBox;
    Panel3: TPanel;
    btPosnGet: TButton;
    lbPosnGet: TLabel;
    Panel4: TPanel;
    Panel5: TPanel;
    btInject: TButton;
    cbCtrlTags: TComboBox;
    cbxBuffNotifications: TCheckBox;
    GroupBox4: TGroupBox;
    cbxOnAudioStartEvent: TCheckBox;
    cbxOnAudioStopEvent: TCheckBox;
    cbxOnVisualEvent: TCheckBox;
    GroupBox5: TGroupBox;
    cbxOnTextDataDoneEvent: TCheckBox;
    cbxOnTextDataStartedEvent: TCheckBox;
    cbxOnBookMarkEvent: TCheckBox;
    cbxOnWordPositionEvent: TCheckBox;
    ListBoxNotifications: TListBox;
    btClearList: TButton;
    Panel6: TPanel;
    btEngineReleasesAudio: TCheckBox;
    Label8: TLabel;
    cbxEngineNotificaitons: TCheckBox;
    cbxAttributesActive: TCheckBox;
    cbxDialogsActive: TCheckBox;
    TTS1: TTTS;
    ModeDlg1: TModeDlg;
    AuDevDlg1: TAuDevDlg;
    GroupBox1: TGroupBox;
    btAbout: TButton;
    btGeneral: TButton;
    btTranslate: TButton;
    btLexicon: TButton;
    btFileTime: TButton;
    lbFileTime: TLabel;
    cbxOnAttribChangedEvent: TCheckBox;
    Lip1: TLip;
    edLexAddWord: TEdit;
    edLexAddPro: TEdit;
    btLexAdd: TButton;
    rgCharSet: TRadioGroup;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    edLexDelete: TEdit;
    Label14: TLabel;
    btLexDelete: TButton;
    procedure FormActivate(Sender: TObject);
    procedure TTS1AttribChangedEvent(Sender: TObject;
      dwAttribute: Integer);
    procedure TTS1AudioStartEvent(Sender: TObject; qTimeStamp: Comp);
    procedure TTS1AudioStopEvent(Sender: TObject; qTimeStamp: Comp);
    procedure TTS1BookMarkEvent(Sender: TObject; SpeechTimeStamp: Comp;
      dwMarkNum: Integer);
    procedure TTS1TextDataDoneEvent(Sender: TObject; SpeechTimeStamp: Comp;
      dwFlags: Integer);
    procedure TTS1TextDataStartedEvent(Sender: TObject;
      SpeechTimeStamp: Comp);
    procedure TTS1WordPositionEvent(Sender: TObject; SpeechTimeStamp: Comp;
      dwByteOffset: Integer);
    procedure TrackBarPitchChange(Sender: TObject);
    procedure TrackBarRealTimeChange(Sender: TObject);
    procedure TrackBarSpeedChange(Sender: TObject);
    procedure TrackBarVolumeLChange(Sender: TObject);
    procedure TrackBarVolumeRChange(Sender: TObject);
    procedure ButtonSpeakClick(Sender: TObject);
    procedure btEngineModeClick(Sender: TObject);
    procedure btAudioDeviceClick(Sender: TObject);
    procedure btActiveClick(Sender: TObject);
    procedure btPauseResumeClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
    procedure btAboutClick(Sender: TObject);
    procedure btInjectClick(Sender: TObject);
    procedure btPosnGetClick(Sender: TObject);
    procedure btLexGetClick(Sender: TObject);
    procedure bConvertToPhonemeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btFileTimeClick(Sender: TObject);
    procedure cbxCtrlTagsClick(Sender: TObject);
    procedure cbxBuffNotificationsClick(Sender: TObject);
    procedure cbxEngineNotificaitonsClick(Sender: TObject);
    procedure btClearListClick(Sender: TObject);
    procedure btEngineReleasesAudioClick(Sender: TObject);
    procedure cbxDialogsActiveClick(Sender: TObject);
    procedure cbxAttributesActiveClick(Sender: TObject);
    procedure TTS1VisualEvent(Sender: TObject; qTimeStamp: Comp;
      cIPAPhoneme, cEnginePhoneme: Char; dwHints: Integer;
      aTTSMouth: TTSMOUTH);
    procedure btLexAddClick(Sender: TObject);
    procedure btLexDeleteClick(Sender: TObject);
  private
    fLastFileTime : Comp;
    { Private declarations }
  public
    { Public declarations }
    Procedure UpdateAttributes;
  end;

var
  FormMain: TFormMain;

implementation

uses TModeFrm, TADevFrm;

{$R *.DFM}

procedure TFormMain.FormCreate(Sender: TObject);
begin
  fLastFileTime := 0;
end;

Procedure TFormMain.UpdateAttributes;
begin
  if TTS1.Active then
  begin
    if (TTS1.PitchSupported) and
       ((TTSFEATURE_PITCH and TTS1.ModeInfo.dwFeatures) <> 0) then
    begin
      TrackBarPitch.Position := TTS1.Pitch;
      lbPitch.Caption := IntToStr(TTS1.Pitch);
    end;
    if (TTS1.RealTimeSupported) then
    begin
      TrackBarRealTime.Position := TTS1.Realtime;
      lbRealTime.Caption := IntToStr(TTS1.Realtime);
    end;
    if (TTS1.SpeedSupported) and
       ((TTSFEATURE_Speed and TTS1.ModeInfo.dwFeatures) <> 0) then
    begin
      TrackBarSpeed.Position := TTS1.Speed;
      lbSpeed.Caption := IntToStr(TTS1.Speed);
    end;
    if TTS1.VolumeSupported and
       ((TTSFEATURE_VOLUME and TTS1.ModeInfo.dwFeatures) <> 0 ) then
    begin
      TrackBarVolumeL.Position := TTS1.VolumeL;
      lbVolumeL.Caption := IntToStr(TTS1.VolumeL);
      TrackBarVolumeR.Position := TTS1.VolumeR;
      lbVolumeR.Caption := IntToStr(TTS1.VolumeR);
    end;
  end;
end;

procedure TFormMain.FormActivate(Sender: TObject);
  Function SetupTrackBar(TrackBar : TTrackBar; Min, Current, Max : Integer) : Boolean;
  {Go to all this trouble so track bar doesn't give range error if min> max or max < min}
  {The code below looks like the same thing is being done for both conditions of the if
  {statements. Its not exactly so. Its the order of setting the min and the max that is
  important. Max can not be less than min and min can not be greater than max. }
  Begin
    result := False;
    TrackBar.Position := TrackBar.Min;
    TrackBar.Max := TrackBar.Min;
    If TrackBar.Min < 100 then
    begin
      TrackBar.Max := 100;
      TrackBar.Min := 0;
    end
    else
    begin
      TrackBar.Min := 0;
      TrackBar.Max := 100
    end;
    TrackBar.Position := 50;
    if (Min <= Current) and (Current <= Max) then
    begin
      If (TrackBar.Max > Min) or ((Max > TrackBar.Max) and (Min > TrackBar.Min)) then
      begin
        TrackBar.Max := Max;
        TrackBar.Min := Min;
      end
      else
      begin
        TrackBar.Min := Min;
        TrackBar.Max := Max;
      end;
      TrackBar.Position := Current;
      result := True;
    end
    else
      TrackBar.Enabled := False;
  end;
begin
  if TTS1.Active then
  begin
    GroupBox2.Enabled := True;
    TrackBarPitch.Enabled := False;
    Label1.Enabled := False;
    try
      if (TTS1.PitchSupported) and
         ((TTSFEATURE_PITCH and TTS1.ModeInfo.dwFeatures) <> 0) and
           SetupTrackBar(TrackBarPitch, TTS1.MinPitch,
                         TTS1.Pitch, TTS1.MaxPitch) then
      begin
        TrackBarPitch.Frequency := (TrackBarPitch.Max - TrackBarPitch.Min) div 8;
        lbPitch.Caption := IntToStr(TrackBarPitch.Position);
        lbPitchMin.Caption := IntToStr(TrackBarPitch.Min);
        lbPitchMax.Caption := IntToStr(TrackBarPitch.Max);
        TrackBarPitch.Enabled := True;
        Label1.Enabled := True;
      end;
    except
    end;

    TrackBarRealTime.Enabled := False;
    Label2.Enabled := False;
    Try
      if TTS1.RealTimeSupported and
           SetupTrackBar(TrackBarRealTime, TTS1.MinRealTime,
                         TTS1.RealTime, TTS1.MaxRealTime) then
      begin
        TrackBarRealTime.Frequency := (TrackBarRealTime.Max - TrackBarRealTime.Min) div 8;
        lbRealTime.Caption := IntToStr(TrackBarRealTime.Position);
        lbRealTimeMin.Caption := IntToStr(TrackBarRealTime.Min);
        lbRealTimeMax.Caption := IntToStr(TrackBarRealTime.Max);
        TrackBarRealTime.Enabled := True;
        Label2.Enabled := True;
      end;
    except
    end;

    TrackBarSpeed.Enabled := False;
    Label3.Enabled := False;
    Try
      if (TTS1.SpeedSupported) and
         ((TTSFEATURE_Speed and TTS1.ModeInfo.dwFeatures) <> 0) and
           SetupTrackBar(TrackBarSpeed, TTS1.MinSpeed,
                         TTS1.Speed, TTS1.MaxSpeed) then
      begin
        TrackBarSpeed.Frequency := (TrackBarSpeed.Max - TrackBarSpeed.Min) div 8;
        lbSpeed.Caption := IntToStr(TrackBarSpeed.Position);
        lbSpeedMin.Caption := IntToStr(TrackBarSpeed.Min);
        lbSpeedMax.Caption := IntToStr(TrackBarSpeed.Max);
        TrackBarSpeed.Enabled := True;
        Label3.Enabled := True;
      end;
    except
    end;

    TrackBarVolumeL.Enabled := False;
    Label4.Enabled := False;
    Try
      if TTS1.VolumeSupported and
         ((TTSFEATURE_VOLUME and TTS1.ModeInfo.dwFeatures) <> 0 ) and
           SetupTrackBar(TrackBarVolumeL, TTS1.MinVolumeL,
                         TTS1.VolumeL, TTS1.MaxVolumeL) then
      begin
        TrackBarVolumeL.Frequency := (TrackBarVolumeL.Max - TrackBarVolumeL.Min) div 8;
        lbVolumeL.Caption := IntToStr(TrackBarVolumeL.Position);
        lbVolumeLMin.Caption := IntToStr(TrackBarVolumeL.Min);
        lbVolumeLMax.Caption := IntToStr(TrackBarVolumeL.Max);
        TrackBarVolumeL.Enabled := True;
        Label4.Enabled := True;
      end;
    Except
    end;

    TrackBarVolumeR.Enabled := False;
    Label5.Enabled := False;
    Try
      if TTS1.VolumeSupported and
         ((TTSFEATURE_VOLUME and TTS1.ModeInfo.dwFeatures) <> 0 ) and
           SetupTrackBar(TrackBarVolumeR, TTS1.MinVolumeR,
                         TTS1.VolumeR, TTS1.MaxVolumeR) then
      begin
        TrackBarVolumeR.Frequency := (TrackBarVolumeR.Max - TrackBarVolumeR.Min) div 8;
        lbVolumeR.Caption := IntToStr(TrackBarVolumeR.Position);
        lbVolumeRMin.Caption := IntToStr(TrackBarVolumeR.Min);
        lbVolumeRMax.Caption := IntToStr(TrackBarVolumeR.Max);
        TrackBarVolumeR.Enabled := True;
        Label5.Enabled := True;
      end;
    except
    end;

    btActive.Caption := 'DeActivate';
  end
  else
  begin
    TrackBarPitch.Enabled    := False;
    TrackBarRealTime.Enabled := False;
    TrackBarSpeed.Enabled    := False;
    TrackBarVolumeL.Enabled  := False;
    TrackBarVolumeR.Enabled  := False;
    Label1.enabled := False;
    Label2.enabled := False;
    Label3.enabled := False;
    Label4.enabled := False;
    Label5.enabled := False;
    GroupBox2.enabled := False;
    btActive.Caption := 'Activate'
  end;

  if itAttributes in TTS1.Interfaces then
    cbxAttributesActive.checked := True
  else
    cbxAttributesActive.checked := False;

  if itDialogs in TTS1.Interfaces then
    cbxDialogsActive.checked := True
  else
    cbxDialogsActive.checked := False;

  btAbout.enabled := TTS1.AboutDlgSupported;
  btGeneral.enabled := TTS1.GeneralDlgSupported;
  btLexicon.enabled := TTS1.LexiconDlgSupported;
  btTranslate.enabled := TTS1.TranslateDlgSupported;

  If TTS1.Active then
    lbActiveStatus.caption := 'Engine is running . . .'
  else
    lbActiveStatus.caption := 'Engine is stopped';
  lbEngineMode.caption := TTS1.ModeName;

  lbAudioDevice.caption := String(TTS1.DeviceInfo.szPname);

  if itNotifySink in TTS1.Interfaces then
  begin
    cbxEngineNotificaitons.checked := True;
    StatusBar1.Panels.Items[1].text := 'Engine Notifications ON';
  end
  else
  begin
    cbxEngineNotificaitons.checked := False;
    StatusBar1.Panels.Items[1].text := 'Engine Notifications OFF';
  end;

  if itBuffNotify in TTS1.Interfaces then
  begin
    cbxBuffNotifications.checked := True;
    StatusBar1.Panels.Items[2].text := 'Buffer Notifications ON';
  end
  else
  begin
    cbxBuffNotifications.checked := False;
    StatusBar1.Panels.Items[2].text := 'Buffer Notifications OFF';
  end;

  if TTS1.ControlTags = ctNone then
     cbxCtrlTags.Checked := False
  else
     cbxCtrlTags.Checked := True;

  if TTS1.EngineReleasesAudio then
    btEngineReleasesAudio.Checked := True
  else
    btEngineReleasesAudio.Checked := False;
end;

procedure TFormMain.TTS1AttribChangedEvent(Sender: TObject;
  dwAttribute: Integer);
begin
  if cbxOnAttribChangedEvent.Checked then
  begin
    Case dwAttribute of
      TTSNSAC_REALTIME :
        ListBoxNotifications.ItemIndex :=
           ListBoxNotifications.Items.Add('Attribute Changed Event - RealTime');
      TTSNSAC_PITCH    :
        ListBoxNotifications.ItemIndex :=
           ListBoxNotifications.Items.Add('Attribute Changed Event - Pitch');
      TTSNSAC_SPEED    : 
        ListBoxNotifications.ItemIndex :=
           ListBoxNotifications.Items.Add('Attribute Changed Event - Speed');
      TTSNSAC_VOLUME   : 
        ListBoxNotifications.ItemIndex :=
           ListBoxNotifications.Items.Add('Attribute Changed Event - Volume');
    end; {case}
  end;
end;

procedure TFormMain.TTS1AudioStartEvent(Sender: TObject; qTimeStamp: Comp);
begin
  if cbxOnAudioStartEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Audio Start Event');
  end;
  fLastFileTime := qTimeStamp;
end;

procedure TFormMain.TTS1AudioStopEvent(Sender: TObject; qTimeStamp: Comp);
begin
  if cbxOnAudioStopEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Audio Stop Event');
  end;
  fLastFileTime := qTimeStamp;
end;

procedure TFormMain.TTS1BookMarkEvent(Sender: TObject; SpeechTimeStamp: Comp;
  dwMarkNum: Integer);
begin
  if cbxOnBookMarkEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Book Mark Event - at ' + InttoStr(dwMarkNum));
  end;
  fLastFileTime := SpeechTimeStamp;
end;

procedure TFormMain.TTS1TextDataDoneEvent(Sender: TObject;
  SpeechTimeStamp: Comp; dwFlags: Integer);
begin
 if cbxOnTextDataDoneEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Text Data Done Event');
  end;

 if (dwFlags = TTSBNS_ABORTED) then exit; { don't continue speaking if reset }
 RichEdit1.SelStart := 0;
 RichEdit1.SelLength := 0;
  fLastFileTime := SpeechTimeStamp;
end;

procedure TFormMain.TTS1TextDataStartedEvent(Sender: TObject;
  SpeechTimeStamp: Comp);
begin
  if cbxOnTextDataStartedEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Text Data Started Event');
  end;
  if Screen.Cursor = crHourglass then
    Screen.Cursor := crDefault;
  fLastFileTime := SpeechTimeStamp;
end;

procedure TFormMain.TTS1WordPositionEvent(Sender: TObject;
  SpeechTimeStamp: Comp; dwByteOffset: Integer);
  function lengthToNextSpace : Word;
  var
    I : Integer;
  begin
    I := dwByteOffset + 1;
    While not(RichEdit1.text[I] in [#0, #10, #32]) do
      Inc(I);
    Result := pred(I) - dwByteOffset;
  end;
begin
  if cbxOnWordPositionEvent.Checked then
  begin
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Word Position Event - Offset: '+IntToStr(dwByteOffset));
  end;
  StatusBar1.Panels.Items[0].text := 'Time ' + FloatToStr(SpeechTimeStamp);
  RichEdit1.SelStart := dwByteOffset;
  RichEdit1.SelLength := lengthToNextSpace;
  fLastFileTime := SpeechTimeStamp;
end;

procedure TFormMain.TrackBarPitchChange(Sender: TObject);
begin
  if TTS1.PitchSupported then
  begin
    TTS1.Pitch := TrackBarPitch.Position;
    UpdateAttributes;
  end;
end;

procedure TFormMain.TrackBarRealTimeChange(Sender: TObject);
begin
  if TTS1.RealTimeSupported then
  begin
    TTS1.RealTime := TrackBarRealTime.Position;
    UpdateAttributes;
  end;
end;

procedure TFormMain.TrackBarSpeedChange(Sender: TObject);
begin
  if TTS1.SpeedSupported then
  begin
    TTS1.Speed := TrackBarSpeed.Position;
    UpdateAttributes;
  end;
end;

procedure TFormMain.TrackBarVolumeLChange(Sender: TObject);
begin
  TTS1.VolumeL := TrackBarVolumeL.Position;
  UpdateAttributes;
end;

procedure TFormMain.TrackBarVolumeRChange(Sender: TObject);
begin
  TTS1.VolumeR := TrackBarVolumeR.Position;
  UpdateAttributes;
end;

procedure TFormMain.ButtonSpeakClick(Sender: TObject);
begin
  if not TTS1.Active then
    btActiveClick(Self);
  If itBuffNotify in TTS1.Interfaces  then
    Screen.Cursor := crHourglass;
  Try
    TTS1.Speak(RichEdit1.text);
  except
    Screen.Cursor := crDefault;
    raise;
  end;
end;

procedure TFormMain.btEngineModeClick(Sender: TObject);
var
  Old : Boolean;
begin
  Old := TTS1.Active;
  TTS1.Active := False;
  ModeDlg1.execute;    {The dialog automatically sets ModeInfo through its TTS property }
  TTS1.Active := Old;
  FormActivate(Self);
end;

procedure TFormMain.btAudioDeviceClick(Sender: TObject);
begin
  AuDevDlg1.execute; {The dialog automatically sets AudioDeviceID through its TTS property }
  lbAudioDevice.caption := String(TTS1.DeviceInfo.szPname);
end;

procedure TFormMain.btActiveClick(Sender: TObject);
begin
  TTS1.Active := Not(TTS1.Active);
  FormActivate(Self);
end;

procedure TFormMain.btPauseResumeClick(Sender: TObject);
begin
  TTS1.AudioPaused := Not(TTS1.AudioPaused);
  if TTS1.AudioPaused then
    btPauseResume.Caption := 'Resume'
  else
    btPauseResume.Caption := 'Pause';
end;

procedure TFormMain.btResetClick(Sender: TObject);
begin
  TTS1.AudioReset;
  if TTS1.AudioPaused then     {Do this cause AudioReset also unpauses the engine}
    btPauseResume.Caption := 'Resume'
  else
    btPauseResume.Caption := 'Pause';
  RichEdit1.SelStart := 0;
  RichEdit1.SelLength := 0;
end;

procedure TFormMain.btAboutClick(Sender: TObject);
begin
  case TButton(Sender).Caption[1] of
   'A' : TTS1.ShowAboutDlg(Handle, '');
   'G' : TTS1.ShowGeneralDlg(Handle, '');
   'L' : TTS1.ShowLexiconDlg(Handle, '');
   'T' : TTS1.ShowTranslateDlg(Handle, '');
  end; {case}
  UpdateAttributes;
end;

procedure TFormMain.btInjectClick(Sender: TObject);
begin
  TTS1.Inject(cbCtrlTags.Items.Strings[cbCtrlTags.ItemIndex]);

end;

procedure TFormMain.btPosnGetClick(Sender: TObject);
begin
  lbPosnGet.Caption := FloatToStr(TTS1.PosnGet);
end;

procedure TFormMain.btLexGetClick(Sender: TObject);
var
  POS : VoicePartOfSpeech;
  Info : Pointer;
  InfoSize : Integer;
begin
  lbLexGet.Caption := String(TTS1.LexPronounceGet(TChrSet(rgCharSet.itemindex),
                      pChar(edLexGet.Text), 0, POS, Info, InfoSize));
end;

procedure TFormMain.btLexAddClick(Sender: TObject);
var
  POS : VoicePartOfSpeech;
  Info : Pointer;
  InfoSize : Integer;
begin
  POS := VPS_UNKNOWN;
  Info := nil;
  InfoSize := 0;
  TTS1.LexPronounceAdd(TChrSet(rgCharSet.itemindex),
                       pChar(edLexAddWord.Text),
                       pChar(edLexAddPro.Text),
                       POS, Info, InfoSize);
end;

procedure TFormMain.btLexDeleteClick(Sender: TObject);
begin
  TTS1.LexPronounceRemove(pChar(edLexDelete.Text), 0);
end;

procedure TFormMain.bConvertToPhonemeClick(Sender: TObject);
begin
   TTS1.ConvertToPhoneme(TchrSet(ord(rgCharSets.itemIndex+1)), ctNone,
                          RichEdit1.text);
   {The result is retuned in the PhonemeOut property which is a TSData}
   RichEdit2.text := String(TTS1.PhonemeOut.pData);
end;


procedure TFormMain.btFileTimeClick(Sender: TObject);
var
  TmpDate : TDateTime;
begin
  Try
    TmpDate := TTS1.SpeechTimeToDateTime(fLastFileTime);
    lbFileTime.Caption := DateTimeToStr(TmpDate);
  except
    lbFileTime.caption := 'Not Supported by this engine'
  end;
end;

procedure TFormMain.cbxCtrlTagsClick(Sender: TObject);
var
  old : Boolean;
begin
  Old := cbxCtrlTags.Checked;
  try
    if cbxCtrlTags.Checked then
      TTS1.ControlTags := ctTagged
    else
      TTS1.ControlTags := ctNone;
  except
     cbxCtrlTags.Checked := not(old);
     raise;
  end;
end;

procedure TFormMain.cbxBuffNotificationsClick(Sender: TObject);
begin
  if cbxBuffNotifications.checked then
  begin
    TTS1.Interfaces := TTS1.Interfaces + [itBuffNotify];
    StatusBar1.Panels.Items[2].text := 'Buffer Notifications ON';
  end
  else
  begin
    TTS1.Interfaces := TTS1.Interfaces - [itBuffNotify];
    StatusBar1.Panels.Items[2].text := 'Buffer Notifications OFF';
  end;
end;

procedure TFormMain.cbxEngineNotificaitonsClick(Sender: TObject);
begin
  if cbxEngineNotificaitons.checked then
  begin
    TTS1.Interfaces := TTS1.Interfaces + [itNotifySink];
    StatusBar1.Panels.Items[1].text := 'Engine Notifications ON';
  end
  else
  begin
    TTS1.Interfaces := TTS1.Interfaces - [itNotifySink];
    StatusBar1.Panels.Items[1].text := 'Engine Notifications OFF';
  end;
end;

procedure TFormMain.btClearListClick(Sender: TObject);
begin
  ListBoxNotifications.Clear;
end;


procedure TFormMain.btEngineReleasesAudioClick(Sender: TObject);
begin
  if btEngineReleasesAudio.checked then
    tts1.EngineReleasesAudio := True
  else
    tts1.EngineReleasesAudio := False;
end;

procedure TFormMain.cbxDialogsActiveClick(Sender: TObject);
begin
  if cbxDialogsActive.checked then
    TTS1.Interfaces := TTS1.Interfaces + [itDialogs]
  else
    TTS1.Interfaces := TTS1.Interfaces - [itDialogs];
end;

procedure TFormMain.cbxAttributesActiveClick(Sender: TObject);
begin
  if cbxAttributesActive.checked then
    TTS1.Interfaces := TTS1.Interfaces + [itAttributes]
  else
    TTS1.Interfaces := TTS1.Interfaces - [itAttributes];
end;

procedure TFormMain.TTS1VisualEvent(Sender: TObject; qTimeStamp: Comp;
  cIPAPhoneme, cEnginePhoneme: Char; dwHints: Integer;
  aTTSMouth: TTSMOUTH);
var
  tmp : String;
begin
  if cbxOnVisualEvent.Checked then
  begin
    tmp := '';
    if dwHints <> 0 then
    begin
      If (TTSNSHINT_QUESTION and dwHints) <> 0 then
        tmp := tmp + 'Question ';
      If (TTSNSHINT_STATEMENT and dwHints) <> 0 then
        tmp := tmp + 'Statement ';
      If (TTSNSHINT_COMMAND and dwHints) <> 0 then
        tmp := tmp + 'Command ';
      If (TTSNSHINT_EXCLAMATION and dwHints) <> 0 then
        tmp := tmp + 'Exclamation ';
      If (TTSNSHINT_EMPHASIS and dwHints) <> 0 then
        tmp := tmp + 'Emphasis ';
    end
    else
      tmp := 'None';
    ListBoxNotifications.ItemIndex :=
      ListBoxNotifications.Items.Add('Visual Event - Phoneme: ' + cEnginePhoneme +
      ' Hint: '+ tmp);
  end;
  lip1.talk(aTTSMouth.bMouthHeight, aTTSMouth.bMouthWidth);
  fLastFileTime := qTimeStamp;
end;






end.



