unit DTalkReg;

interface

uses DsgnIntf, Classes, Windows, Forms, mmsystem,
     TTS, SR, Grammar, AuDevDlg, TADevFrm,
     ModeDlg, TModeFrm, TLips, Dialogs,
  {$IFDEF VER90} //Delphi 2.0
    OLE2,
    OleAuto,
  {$ENDIF}
  {$IFDEF VER100}  //Delphi 3.0
    ActiveX,
    ComObj,
  {$ENDIF}
    sysutils;

Procedure Register;

implementation

uses Speech, sphconst, GmRuleFm;

{ --- COMPONENT EDITORS ---   SpeechComponentEditor }
type
  SpeechComponentEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure SpeechComponentEditor.ExecuteVerb(Index: Integer);
begin
  MessageDlg('DTalk - Speech Components'
             +#10#13+ 'Version 1.00'
             +#10#13+ '(c) 1997, Out && About Productions'
             +#10#13+ 'WWW: www.o2a.com'
             +#10#13+ 'email: 75664.1224@compuserve.com'
             +#10#13+ 'Fax: (415) 695-9934',
             mtInformation,[mbOK],0);
end;

function SpeechComponentEditor.GetVerb(Index: Integer): string;
begin
  result := 'Component Info';
end;

function SpeechComponentEditor.GetVerbCount: Integer;
begin
  result := 1;
end;


{ --- PROPERTY EDITORS AND REGISTRATIONS ETC For TTS----------------}
{ TAudioDeviceIDProperty }
type
  TAudioDeviceIDProperty = class(TIntegerProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; Override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure GetValueList(List: TStrings); virtual;
  end;

function TAudioDeviceIDProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paValueList, paMultiSelect, paRevertable];
end;

procedure TAudioDeviceIDProperty.Edit;
var
  AudioDeviceIDDlg : TAudioDeviceIDDlg;
begin
  if ((GetComponent(0) is TTTS) and
     ((GetComponent(0) as TTTS).Active = TRUE))
     or
     ((GetComponent(0) is TSR) and
     ((GetComponent(0) as TSR).Active = TRUE)) then
  begin
    raise EOleError.CreateResFmt(SMustBeInActive, ['AudioDeviceID']);
    exit;
  end;
  AudioDeviceIDDlg := TAudioDeviceIDDlg.Create(Application);
  if (GetComponent(0) is TTTS) then AudioDeviceIDDlg.DlgUse := duTTS;
  if (GetComponent(0) is TSR) then AudioDeviceIDDlg.DlgUse := duSR;
  Try
    AudioDeviceIDDlg.AudioDeviceID := getOrdValue;
    if (AudioDeviceIDDlg.ShowModal = idOK) then
      SetOrdValue(AudioDeviceIDDlg.AudioDeviceID);
  Finally
    AudioDeviceIDDlg.Free;
  end;
end;

procedure TAudioDeviceIDProperty.GetValues(Proc: TGetStrProc);
{if paValueList is an Attribute then this is called to create and fill a list Note that
 Proc must be called for every list value that is acceptable for this property.}
var
  I: Integer;
  Values: TStringList;
begin
  If ((GetComponent(0) is TTTS) and
  ((GetComponent(0) as TTTS).Active = TRUE))
  or
  ((GetComponent(0) is TSR) and
  ((GetComponent(0) as TSR).Active = TRUE))  then
  begin
    raise EOleError.CreateResFmt(SMustBeInActive, ['AudioDeviceID']);
    exit;
  end;
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TAudioDeviceIDProperty.GetValueList(List: TStrings);
var
  I, numAudioDevices : Integer;
begin
  NumAudioDevices := 0;
  List.Add('Wave_Mapper');
  If (GetComponent(0) is TTTS) then
    NumAudioDevices := WaveOutGetNumDevs
  else
  if (GetComponent(0) is TSR) then
    NumAudioDevices := WaveInGetNumDevs;
  For I := 0 to NumAudioDevices - 1 do
     List.Add(IntToStr(I));
end;

function TAudioDeviceIDProperty.GetValue: string;
{Returns the string value of the property. That is the value thats displayed in the
object inspector}
begin
  If GetOrdValue = Wave_Mapper then
    Result := 'Wave_Mapper'
  else
    Result := IntToStr(GetOrdValue);
end;

procedure TAudioDeviceIDProperty.SetValue(const Value: string);
begin
  if Value = 'Wave_Mapper' then
    inherited SetValue(IntToStr(Wave_Mapper))
  else
    inherited SetValue(Value);
end;

{ ----------- TTTSModeInfoProperty --------------- }
type
  TModeInfoProperty = class(TStringProperty)
  public
    procedure GetValueList(List: TStrings); virtual;
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure Edit; Override;
{    function GetValue: string; override;
    procedure SetValue(const Value: string); override; }
  end;

function TModeInfoProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paValueList, paMultiSelect, paRevertable];
end;

procedure TModeInfoProperty.GetValues(Proc: TGetStrProc);
{ if paValueList is an Attribute then this is called to create and fill a list Note that
  Proc must be called for every list value that is acceptable for this property.}
var
  I: Integer;
  Values: TStringList;
begin
  If ((GetComponent(0) is TTTS) and
  ((GetComponent(0) as TTTS).Active = TRUE))
  or
  ((GetComponent(0) is TSR) and
  ((GetComponent(0) as TSR).Active = TRUE))  then
  begin
    raise EOleError.CreateResFmt(SMustBeInActive, ['ModeName']);
    exit;
  end;
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TModeInfoProperty.Edit;
var
  EngineModeForm: TEngineModeForm;
begin
  if ((GetComponent(0) is TTTS) and
     ((GetComponent(0) as TTTS).Active = TRUE))
     or
     ((GetComponent(0) is TSR) and
     ((GetComponent(0) as TSR).Active = TRUE)) then
  begin
    raise EOleError.CreateResFmt(SMustBeInActive, ['ModeName']);
    exit;
  end;

  EngineModeForm := TEngineModeForm.Create(Application);

  Try
    if (GetComponent(0) is TTTS) then
    begin
      EngineModeForm.DlgUse := duTTS;
      EngineModeForm.TTSModeInfo := (GetComponent(0) as TTTS).ModeInfo;
      if (EngineModeForm.ShowModal = idOK) then
        (GetComponent(0) as TTTS).ModeInfo := EngineModeForm.TTSModeInfo;
    end;
    if (GetComponent(0) is TSR) then
    begin
      EngineModeForm.DlgUse := duSR;
      EngineModeForm.SRModeInfo := (GetComponent(0) as TSR).ModeInfo;
      if (EngineModeForm.ShowModal = idOK) then
        (GetComponent(0) as TSR).ModeInfo := EngineModeForm.SRModeInfo;
    end;
  Finally
    EngineModeForm.Free;
  end;
end;

procedure TModeInfoProperty.GetValueList(List: TStrings);
var
  aITTSEnum : ITTSEnum;
  aISREnum : ISREnum;
  NumFound : LongInt;
  ModeInfo : TModeInfo;
begin
  aITTSEnum := Nil;
  aISREnum := Nil;
  List.Add('Default');
  if (GetComponent(0) is TTTS) then
  begin
{$IFDEF VER90} //Delphi 2.0
    OleCheck(CoCreateInstance(CLSID_TTSEnumerator, Nil, CLSCTX_ALL, IID_ITTSEnum, aITTSEnum));
{$ENDIF}
{$IFDEF VER100}  //Delphi 3.0
    aITTSEnum := CreateComObject(CLSID_TTSEnumerator) as ITTSEnum;
{$ENDIF}
    OleCheck(aITTSEnum.Reset);
    OleCheck(aITTSEnum.Next(1, @ModeInfo, NumFound));  {First Get}
    While NumFound > 0 do
    begin
      List.Add(String(ModeInfo.szModeName));
      OleCheck(aITTSEnum.Next(1, @ModeInfo, NumFound)); {additional gets}
    end;
{$IFDEF VER90} //Delphi 2.0
    aITTSEnum.Release;
{$ENDIF}
  end;
  if (GetComponent(0) is TSR) then
  begin
{$IFDEF VER90} //Delphi 2.0
    OleCheck(CoCreateInstance(CLSID_SREnumerator, Nil, CLSCTX_ALL, IID_ISREnum, aISREnum));
{$ENDIF}
{$IFDEF VER100}  //Delphi 3.0
    aISREnum := CreateComObject(CLSID_SREnumerator) as ISREnum;
{$ENDIF}
    OleCheck(aISREnum.Reset);
    OleCheck(aISREnum.Next(1, @ModeInfo, NumFound));  {First Get}
    While NumFound > 0 do
    begin
      List.Add(String(ModeInfo.szModeName));
      OleCheck(aISREnum.Next(1, @ModeInfo, NumFound)); {additional gets}
    end;
{$IFDEF VER90} //Delphi 2.0
    aISREnum.Release;
{$ENDIF}
  end;
end;

{--------------- TRulesListProperty --------------}

type
  TRulesListProperty = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

function TRulesListProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

procedure TRulesListProperty.Edit;
var
  Rules: TStrings;
begin
  Rules := TStringList.Create;
  try
    Rules.Assign(TStrings(GetOrdValue));
    if EditRules( Rules, (GetComponent(0) as TGrammar)) then SetOrdValue(longint(Rules));
  finally
    Rules.Free;
  end;
end;

Procedure Register;
begin
  RegisterComponents('Samples', [TTTS, TSR, TGrammar, TLip, TModeDlg, TAuDevDlg]);
  RegisterComponentEditor(TTTS,SpeechComponentEditor);
  RegisterComponentEditor(TSR,SpeechComponentEditor);
  RegisterPropertyEditor(TypeInfo(Integer), TSpeechComponent, 'AudioDeviceID', TAudioDeviceIDProperty);
  RegisterPropertyEditor(TypeInfo(String), TSpeechComponent, 'ModeName', TModeInfoProperty);
  RegisterPropertyEditor(TypeInfo(TStrings), TGrammar, 'Rules', TRulesListProperty);
end;

end.
