unit Unit1;

interface

uses
  SysUtils, Classes, Controls, Forms, StdCtrls;

type
  TForm1 = class(TForm)
    CopyBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtSource: TEdit;
    edtTarget: TEdit;
    edtMask: TEdit;
    procedure CopyBtnClick(Sender: TObject);
  private
    function  GetDrive: Byte;
    function  FillList(Source: Boolean): TStringList;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  CopyFrm;

function TForm1.GetDrive: Byte;
begin
  Result := Ord( UpCase( edtTarget.Text[1] ) ) - 64;
end;

procedure TForm1.CopyBtnClick(Sender: TObject);
var
  DFree: LongInt;
  Sources, Targets: TStringList;
begin
  Sources := FillList(True);
  Targets := FillList(False);
  DFree := DiskFree(GetDrive);
  CopyForm := TCopyForm.Create(Self);
  try
    CopyForm.SetupFiles(Sources, Targets, DFree);
    CopyForm.CopyFiles(True, False); {OneByOne=TRUE; MoveFile=FALSE}
  finally
    CopyForm.Close;
    Sources.Free;
    Targets.Free;
  end;
end;

function TForm1.FillList(Source: Boolean): TStringList;
var
  SR: TSearchRec;
begin
  Result := TStringList.Create;
  if FindFirst(edtSource.Text+edtMask.Text, faArchive, SR) = 0 then
  repeat
    if Source then
      Result.Add(edtSource.Text+LowerCase(SR.Name))
    else
      Result.Add(edtTarget.Text+LowerCase(SR.Name));
  until FindNext(SR) <> 0;
  FindClose(SR);
end;

end.

