unit samp2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, arrowbtn, TLabDBug;

type
  Tfrm_Samp2 = class(TForm)
    DBug: TLabDeBug;
    Btn_Test: TButton;
    procedure Btn_TestClick(Sender: TObject);
    function rtn_string(value : integer) : string;
    function rtn_TimeStamp : string;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frm_Samp2: Tfrm_Samp2;

implementation

{$R *.DFM}

function Tfrm_Samp2.rtn_string(value : integer) : string;
begin
    result := intToStr(value);
end;
function Tfrm_Samp2.rtn_TimeStamp : string;
begin
    result := TimeToStr(Time);
end;

procedure Tfrm_Samp2.Btn_TestClick(Sender: TObject);
var
  l_ktr : integer;
  l_ktrStr : string;
  l_timestamp : string;
  l_str : string;

begin
   Dbug.buttonColor := clRed;
   btn_test.caption := 'Wait';
   screen.cursor := crHourGlass;
   application.processmessages; (* let control change colors *)
   for l_ktr := 1 to 1000 do
      begin
          l_ktrStr := Rtn_string(l_ktr);
          l_timeStamp := rtn_timestamp;
          l_str := l_timeStamp + '     ----------> ' + l_ktrStr;
          DBug.addBug(l_str);
      end;
   Dbug.buttonColor := clLime;  (* set control back indicating process done *)
   btn_test.caption := 'Test';
   screen.cursor := crDefault;
end;

end.
