unit TLabDBug;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  arrowbtn, StdCtrls, extctrls, printers;

type
  TLabDeBug = class(TArrowButton)
  private
    { Private declarations }
  BugForm : Tform;
  BugMemo : Tmemo;
  BugPanel : TPanel;
  BugSaveBtn : Tbutton;
  BugPrtBtn  : Tbutton;
  BugClearBtn : Tbutton;
  BugCloseBtn : Tbutton;
  BugFontBtn  : Tbutton;
  BugSDlg     : TsaveDialog;
  BugPDlg     : TPrintDialog;
  BugFDlg     : TFontDialog;
  BugShow     : boolean;

    procedure Build_BugForm;
    procedure Kill_BugForm;
    procedure SetBtns(value : Tbutton);
    procedure PrtMemo(sender : Tobject );
    Procedure ShowForm(Sender : Tobject);
    Procedure ClearMemo(sender : Tobject);
    Procedure FontMemo(sender : Tobject);
    Procedure SaveMemo(sender : Tobject);
    Procedure StartBug;
    Procedure EndBug;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor create(Aowner : TComponent); override;
    destructor destroy; override;
    procedure AddBug(value : string);
    procedure ClearBug;
    procedure PrintBug;
    procedure FontBug;
    procedure savebug;
  published
    { Published declarations }
  end;

procedure Register;

implementation
var
   ul_left : integer;

procedure TLabDebug.SaveMemo(Sender: TObject);
begin
   SaveBug;
end;

procedure TLabDebug.FontMemo(Sender: TObject);
begin
   FontBug;
end;
procedure TLabDebug.ClearMemo(Sender: TObject);
begin
   ClearBug;
end;
procedure TLabDebug.prtMemo(Sender: TObject);
begin
   printBug;
end;
procedure TLabDebug.ShowForm(sender : Tobject);
begin
   if bugshow then
      begin
         bugform.hide;
         bugshow := false;
      end
      else
         begin
            bugform.show;
            bugshow := true;
         end;
end;
constructor TLabDebug.create(Aowner : Tcomponent);
begin
   inherited create(Aowner);
   ButtonColor := clLime;
   ul_left := 0;
   onClick := showform;
   hint := 'Click to show/hide';
   showhint := true;
   bugShow := false;
   Build_BugForm;
end;
destructor TLabDebug.destroy;
begin
    Kill_BugForm;
    inherited destroy;
end;
procedure TLabDebug.SetBtns(value : Tbutton);
begin
   value.left := ul_left;
   ul_left := ul_left + 35;
   value.top := 0;
   value.height := 25;
   value.width := 35;
   value.visible := true;
end;
(* Build the form/memo pad/ and all buttons here *)
procedure TLabDebug.Build_BugForm;
begin
   BugForm := Tform.create(self);
   BugForm.visible := false;
   BugForm.caption := application.Title;
   BugPanel := TPanel.create(Self);
   BugPanel.parent := BugForm;
   BugPanel.align := altop;
   BugPanel.height := 25;
   BugMemo := Tmemo.create(self);
   BugMemo.parent := BugForm;
   BugMemo.align := alClient;
   BugMemo.scrollbars := ssBoth;
   BugFDlg := TFontDialog.create(self);
   BugSaveBtn := Tbutton.create(self);
   BugSaveBtn.parent := BugPanel;
   BugSaveBtn.caption := 'Save';
   SetBtns(BugSaveBtn);
   BugSaveBtn.onClick := SaveMemo;
   BugClearBtn := Tbutton.create(self);
   BugClearBtn.parent := BugPanel;
   BugClearBtn.caption := 'Clear';
   SetBtns(BugClearBtn);
   BugClearBtn.onClick := ClearMemo;
   BugPrtBtn := Tbutton.create(self);
   BugPrtBtn.parent := BugPanel;
   BugPrtBtn.caption := 'Prt';
   SetBtns(BugPrtBtn);
   BugPrtBtn.Onclick := prtMemo;
   BugFontBtn := Tbutton.create(self);
   BugFontBtn.parent := BugPanel;
   BugFontBtn.caption := 'Font';
   SetBtns(BugFontBtn);
   BugFontBtn.onClick := FontMemo;
   BugSdlg := TSaveDialog.create(Self);
   BugPDlg := TPrintDialog.create(Self);
end;
Procedure TLabDebug.StartBug;
begin
end;

Procedure TLabDebug.ClearBug;
begin
  BugMemo.clear;
end;

procedure TLabDebug.Kill_Bugform;
begin
   Bugform.destroy;
end;

Procedure TLabDebug.EndBug;
begin
end;

Procedure TLabDebug.AddBug(Value : String);
begin
  BugMemo.lines.add(value);
end;

procedure TLabDebug.printBug;
var
  l_File : Textfile;
  l_ktr  : Integer;
begin
  if BugPDlg.execute then
     begin
       printer.canvas.font := bugmemo.font;
       assignPrn(L_file);
       rewrite(l_file);
       for l_ktr := 0 to (BugMemo.lines.count - 1) do
          begin
             writeln(l_file,BugMemo.lines[l_ktr]);
          end;
       system.closeFile(l_file);
     end;
end;


procedure TLabDebug.FontBug;
begin
  if BugFDlg.execute then BugMemo.font := BugFdlg.font;
end;

procedure TLabDebug.SaveBug;
var
   l_file : TextFile;
   l_ktr  : integer;
begin
   if BugSDlg.execute then
      begin
         assignfile(l_file,BugSdlg.filename);
         rewrite(l_file);
         for l_ktr := 0 to (BugMemo.lines.count - 1) do
            writeln(l_file,BugMemo.lines[l_ktr]);
         closefile(l_file);
      end;
end;


procedure Register;
begin
  RegisterComponents('System', [TLabDeBug]);
end;

end.
