unit GraphObj;

interface

uses
  WinTypes, WinProcs, LongColl;

type

  TGraphObject = class(TDStreamableClass)
    Rect: TRect;
    constructor Create(Bounds: TRect);
    constructor Load(S: TDStream); override;
    procedure Draw(DC: HDC); virtual; abstract;
    procedure Store(S: TDStream); override;
  end;

  TGraphEllipse = class(TGraphObject)
    procedure Draw(DC: HDC); override;
  end;

  TGraphRect = class(TGraphObject)
    procedure Draw(DC: HDC); override;
  end;

  TGraphPie = class(TGraphObject)
    ArcStart, ArcEnd: TPoint;
    constructor Create(Bounds: TRect);
    constructor Load(S: TDStream); override;
    procedure Draw(DC: HDC); override;
    procedure Store(S: TDStream); override;
  end;

implementation

var
  RGraphEllipse, RGraphRect, RGraphPie: TStreamRec;

{ TGraphObject }
constructor TGraphObject.Create(Bounds: TRect);
var
  Height, Width: Word;
begin
  inherited Create;
  with Bounds do
  begin
    Height := Random(Bottom - Top) div 2 + 10;
    Width := Random(Right - Left) div 3 + 15;
  end;
  with Rect do
  begin
    Left := Random(Bounds.Right - Bounds.Left - Width);
    Right := Left + Width;
    Top := Random(Bounds.Bottom - Bounds.Top - Height);
    Bottom := Top + Height;
  end;
end;

constructor TGraphObject.Load(S: TDStream);
begin
  S.Read(Rect, SizeOf(Rect));
end;

procedure TGraphObject.Store(S: TDStream);
begin
  S.Write(Rect, SizeOf(Rect));
end;

{ TGraphEllipse }
procedure TGraphEllipse.Draw(DC: HDC);
begin
  with Rect do
    Ellipse(DC, Left, Top, Right, Bottom);
end;

{ TGraphRect }
procedure TGraphRect.Draw(DC: HDC);
begin
  with Rect do
    Rectangle(DC, Left, Top, Right, Bottom);
end;

{ TGraphPie }
constructor TGraphPie.Create(Bounds: TRect);
var Height, Width: Word;
begin
  inherited Create(Bounds);
  with Bounds do
  begin
    Height := Random(Bottom - Top);
    Width := Random(Right - Left);

    ArcStart.X := Random(Right - Left - Width);
    ArcEnd.X := ArcStart.X + Width;
    ArcStart.Y := Random(Bottom - Top - Height);
    ArcEnd.Y := ArcStart.Y + Height;
  end;
end;

procedure TGraphPie.Draw;
begin
  with Rect do
    Pie(DC, Left, Top, Right, Bottom,
      ArcStart.X, ArcStart.Y, ArcEnd.X, ArcEnd.Y);
end;

constructor TGraphPie.Load(S: TDStream);
begin
  inherited Load(S);
  S.Read(ArcStart, SizeOf(ArcStart));
  S.Read(ArcEnd, SizeOf(ArcEnd));
end;

procedure TGraphPie.Store(S: TDStream);
begin
  inherited Store(S);
  S.Write(ArcStart, SizeOf(ArcStart));
  S.Write(ArcEnd, SizeOf(ArcEnd));
end;

initialization
  RegisterStreamObject(RGraphEllipse,150,Pointer(TGraphEllipse),
    @TGraphEllipse.Load,@TGraphEllipse.Store);
  RegisterStreamObject(RGraphRect,151,Pointer(TGraphRect),
    @TGraphRect.Load,@TGraphRect.Store);
  RegisterStreamObject(RGraphPie,152,Pointer(TGraphPie),
    @TGraphPie.Load,@TGraphPie.Store);
end.

