unit Unit1;

interface

uses
  WinTypes, WinProcs, Classes, Forms;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  LongColl, GraphObj;

procedure TForm1.FormCreate(Sender: TObject);
const
  NumToDraw = 10;
var
  Bounds: TRect;
  I: Integer;
  G: TGraphObject;
  GraphicsStream: TDStream;
  GraphicsList: TCollection32;
begin
  Randomize;
  Bounds := GetClientRect;
  { Initialize collection to hold "NumToDraw" elements first, then grow by 5's }
  GraphicsList := TCollection32.Create(NumToDraw, 5);

  for I := 1 to NumToDraw do
  begin
    case I mod 3 of
      0: G := TGraphRect.Create(Bounds);     { Create GraphRect object    }
      1: G := TGraphEllipse.Create(Bounds);  { Create GraphEllipse object }
      2: G := TGraphPie.Create(Bounds);      { Create GraphPie object     }
    end;
    GraphicsList.Insert(G, nil, nil);        { Add object to collection   }
  end;
  { Put the collection in a stream on disk }
  GraphicsStream := TDStream.Create('GRAPH.STM', fmCreate); { create stream }
  GraphicsStream.Put(GraphicsList);          { Output collection          }
  GraphicsStream.Free;                       { Free stream object         }
  GraphicsList.Free;                         { Free our collection        }
end;

procedure TForm1.FormPaint(Sender: TObject);
const
  Msg: PChar = 'Figures stored. Run project2 to load and see them.'#0;
var
  Bounds: TRect;
begin
  Bounds := GetClientRect;
  DrawText(Canvas.Handle, Msg, -1, Bounds, DT_WordBreak);
end;

end.

