unit Unit2;

interface

uses
  WinTypes, Classes, Forms,
  LongColl, GraphObj;

type
  TForm2 = class(TForm)
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    GraphList: TCollection32;
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.FormDestroy(Sender: TObject);
begin
  if Assigned(GraphList) then
    GraphList.Free;                                       { Free collection }
end;

procedure TForm2.FormCreate(Sender: TObject);
var
  GraphStream: TDStream;
begin
  GraphList := nil;
  try
    GraphStream := TDStream.Create('GRAPH.STM', of_Read); { Open stream     }
    GraphList := TCollection32(GraphStream.Get);          { Load collection }
    GraphStream.Free;                                     { Free stream     }
  except
    Application.MessageBox('Run project1 first, to create collection.', 'Error', MB_OK);
  end;
end;

{$IFDEF WIN32}
procedure CallDraw(P: TGraphObject);
begin
  P.Draw(Form2.Canvas.Handle); { Call Draw method }
end;
{$ENDIF}

procedure TForm2.FormPaint(Sender: TObject);

{$IFNDEF WIN32}
procedure CallDraw(P: TGraphObject); far;
begin
  P.Draw(Canvas.Handle); { Call Draw method }
end;
{$ENDIF}

begin
  if Assigned(GraphList) then
    GraphList.ForEach(@CallDraw);
end;

end.

