unit memo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs,stdctrls;

type
  TMyMemo = class(TMemo)
  private
    FH : THandle;
    Fcurrentline : integer;

    Fcharpos : integer;
    Ftopindex : integer;
    function Getcurrentline: integer;
    function Getcharpos: integer;
    function Gettopindex : integer;
    procedure Settopindex(Value:integer);
  protected
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    Property currentline : integer read Getcurrentline;
    Property charpos : integer read Getcharpos;
    Property topindex : integer read Gettopindex write Settopindex;
    Procedure gototop;
    Procedure gotobottom;
    Procedure gotoline(linenumber:integer);
  published

end;

procedure Register;


implementation

procedure Register;
begin
     RegisterComponents('Parallax',[TMyMemo]);
end;

constructor TMyMemo.Create(AOwner:TComponent);
var
   H : THandle;
   NewH : THandle;
   i : longint;
begin
     inherited Create(AOwner);
end;

destructor TMyMemo.Destroy;
begin
     inherited Destroy;
end;
procedure TMyMemo.Settopindex(Value:integer);
var
	i : integer;
	curr : integer;
	moveby : integer;
        l : integer;
        numchars : integer;

begin

        l := perform(EM_GETLINECOUNT,0,0);
        if value > l-1 then
          value := l-1;
        if value < 0 then
          value := 0;
	curr := perform(EM_LINEFROMCHAR,$FFFF,0);
	moveby := value-curr;
	i := perform(EM_LINESCROLL,0,moveby);
        FCurrentline := value;


end;
function TMyMemo.Getcurrentline: integer;
var
	i : integer;
begin
	i := perform(EM_LINEFROMCHAR,$FFFF,0);
	FCurrentline := i;
end;

function TMyMemo.Gettopindex : integer;
var
   i : integer;
begin
     i := perform(EM_GETFIRSTVISIBLELINE,0,0);
     Ftopindex := i;
     Result := i;
end;
function TMyMemo.Getcharpos: integer;
var
	i : longint;
begin
        FCurrentline := perform(EM_LINEFROMCHAR,$FFFF,0);
	i := perform(EM_LINEINDEX,FCurrentline,0);
        FCharPos := i;
        Result := FCharPos;
end;

Procedure TMyMemo.gototop;
var
	i : integer;
begin
	i := perform(EM_LINESCROLL,0,-lines.count);
	FCurrentline := 0;
        i := perform(EM_SETSEL,0,makelong(0,1));
end;
Procedure TMyMemo.gotobottom;
var
	i : integer;
        numchars : integer;
begin
	i := perform(EM_LINESCROLL,0,lines.count-1);
	FCurrentline := lines.count-1;
        numchars := perform(EM_LINEINDEX,FCurrentline,0);
        i := perform(EM_SETSEL,0,makelong(numchars,numchars+1));
end;
Procedure TMyMemo.gotoline(linenumber:integer);
var
	i : integer;
	curr : integer;
	moveby : integer;
        l : integer;
        numchars : integer;
begin
        l := perform(EM_GETLINECOUNT,0,0);
        if linenumber > l-1 then
          linenumber := l-1;
        if linenumber < 0 then
          linenumber := 0;
	curr := perform(EM_LINEFROMCHAR,$FFFF,0);
	moveby := linenumber-curr;
	i := perform(EM_LINESCROLL,0,moveby);
        numchars := perform(EM_LINEINDEX,linenumber,0);
        i := perform(EM_SETSEL,0,makelong(numchars,numchars+1));
        FCurrentline := linenumber;

end;
end.
