unit envydcp1;

{ EnvyDCP1 - Envy Technologies Delphi Component Pack #1
  Written by: Damien Guard, Envy Technologies <envy@guernsey.net>
  Version:    0.4 (10-August-96)
  Status:     FREEWARE + source included
              No warranty expressed or implied.  Use at your own risk.
  Installing: Use the Component > Install option to compile this file into
              your component library.  A new tab called 'Envy' will be added with
              these Components.
  Components: TCoolListView - List View with Auto-sorting facilities
              TCoolCheckBox - Check Box with Read-Only protection
              TCoolDlgAbout - About dialog box very similar to Windows 95
  Usage:      After much thought on the distribution/usage on this package, I've
              come up with this:

              You MAY include this file with your own applications without any
                  royalties/notifications in either source or compiled formats.

              You MAY NOT use these components to form part of another component
                  library nor redistribute these components in a modified state
                  unless accompanied by an application that uses them.

              Generally: Use these in your own applications, but don't try to pass
                         this code off as your own/for profit.
  Copyright:  Copyright  1996 Envy Technologies. }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, AboutDlg, CommCtrl;

{--- TCoolListView - List View with AutoSort-----------------------------------------------
    This component can be used to replace TListView and provides automatic column-sorting
    facilities.  This version now handles numeric sorting (of some degree).  Column-click
    events are still processed.

    New in v0.2!  - A second click on the column will sort in descending order just like
                    Explorer ;-)  Alternatively you can now force a specific sorting
                    by column/order using SortColumn - this does not rely on AutoSort being
                    set on so you can use this method to sort listviews that you don't
                    want to have column-click sorting available on.

    New in v0.3!  - AutoSizeColumns method to auto-size all the listview columns

    New in v0.4!  - AutoSizeColumn for just adjusting one column.

    New:   Property - AutoSort (boolean) to switch auto-column-sorting on or off
           Event    - OnAfterSort - occurs after sorting has occured
           Methods  - Resort - sorts the listview using the last clicked column and order
                      SortNow(ColumnIdx: Integer, Ascending: Boolean);
                      AutoSizeColumsn - resizes the columns to fit it's contents

    Notes: FOnColumnClick is processed *before* the columns are sorted. }

type
  TCoolListView = class(TCustomListView)
  private
    FAutoSort : Boolean;
    FOnColumnClick : TLVColumnClickEvent;
    FOnAfterSort : TNotifyEvent;
    FLastColumn : Integer;
    FSortAscend : Boolean;
  protected
    procedure ColClick(Column: TListColumn); override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure SortColumn(ColumnIdx : Integer; Ascending: Boolean);
    procedure Resort;
    procedure AutoSizeColumns;
    procedure AutoSizeColumn(ColumnIdx : Integer);
  published
    property Align;
    property AutoSort: Boolean read FAutoSort write FAutoSort default False;
    property BorderStyle;
    property Color;
    property ColumnClick;
    property OnClick;
    property OnDblClick;
    property Columns;
    property Ctl3D;
    property DragMode;
    property ReadOnly;
    property Font;
    property HideSelection;
    property IconOptions;
    property Items;
    property AllocBy;
    property MultiSelect;
    property OnAfterSort : TNotifyEvent read FOnAfterSort write FOnAfterSort;
    property OnChange;
    property OnChanging;
    property OnColumnClick;
    property OnCompare;
    property OnDeletion;
    property OnEdited;
    property OnEditing;
    property OnEnter;
    property OnExit;
    property OnInsert;
    property OnDragDrop;
    property OnDragOver;
    property DragCursor;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property ParentShowHint;
    property ShowHint;
    property PopupMenu;
    property ShowColumnHeaders;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property ViewStyle;
    property Visible;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property LargeImages;
    property SmallImages;
    property StateImages;
  end;

{--- TCoolCheckBox - Checkbox with Read-only ability---------------------------------------
    This component can be used to replace TCheckBox and provides an extra property to allow
    the CheckBox to prevent any toggling by the user.
    New:   Property - ReadOnly (boolean) to switch user-click-prevention on and off}
type
  TCoolCheckBox = class(TCustomCheckBox)
  private
    FReadOnly: Boolean;
  protected
    procedure Toggle; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Alignment;
    property AllowGrayed;
    property Caption;
    property Checked;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property State;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDragDrop;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default False;
  end;

{--- TCoolAboutDlg - Windows 95 style about dialog box-------------------------------------
    This component can be dropped into your application to provide a quick and easy way
    to add a Windows 95 style dialog box to your application.  This works correctly on
    Windows 95 and Windows NT v3.51+}
type
  TCoolAboutDlg = class(TComponent)
  private
    FProduct         : String;
    FProduct2        : String;
    FTitle           : String;
    FCopyright       : String;
    FRegUser         : String;
    FRegCompany      : String;
  published
    property Product: String read FProduct write FProduct;
    property Product2: String read FProduct2 write FProduct2;
    property Title : String read FTitle write FTitle;
    property Copyright: String read FCopyright write FCopyright;
    property RegUser: String read FRegUser write FRegUser;
    property RegCompany: String read FRegCompany write FRegCompany;
  public
    function Execute: Boolean;
  end;

procedure Register;

{--- Subfunctions -------------------------------------------------------------------------}
function SortACaption(Item1, Item2: TListItem; ParamSort: Integer): Integer; stdcall;
function SortASubItem(Item1, Item2: TListItem; idx: Integer): Integer; stdcall;
function SortDCaption(Item2, Item1: TListItem; ParamSort: Integer): Integer; stdcall;
function SortDSubItem(Item2, Item1: TListItem; idx: Integer): Integer; stdcall;

implementation

procedure Register;
begin
     RegisterComponents('Envy', [TCoolListView, TCoolCheckBox, TCoolAboutDlg]);
end;

{--Implementation of TCoolListView-----------------------------------------------------}
procedure TCoolListView.ColClick(Column: TListColumn);
begin
     if Assigned(FOnColumnClick) then FOnColumnClick(Self, Column);
     if FAutoSort then
        begin
          if (Column.Index = FLastColumn) then
             FSortAscend := not FSortAscend
           else
             FSortAscend := True;
          FLastColumn := Column.Index;
          Resort;
          if Assigned(FOnAfterSort) then FOnAfterSort(Self);
        end;
end;

procedure TCoolListView.Resort;
begin
     if FAutoSort then SortColumn(FLastColumn,FSortAscend);
end;

procedure TCoolListView.SortColumn(ColumnIdx : Integer; Ascending: Boolean);
begin
     if (ColumnIdx = 0) then
        if Ascending then CustomSort(@SortACaption,0)
                     else CustomSort(@SortDCaption,0);
     if (ColumnIdx > 0) then
        if Ascending then CustomSort(@SortASubItem, ColumnIdx-1)
                     else CustomSort(@SortDSubItem, ColumnIdx-1);
end;

procedure TCoolListView.AutoSizeColumns;
var
   ColumnIdx : Integer;
begin
   for ColumnIdx := 0 to Columns.Count do
       ListView_SetColumnWidth(handle,ColumnIdx,LVSCW_AUTOSIZE);
end;

procedure TCoolListView.AutoSizeColumn(ColumnIdx : Integer);
begin
     ListView_SetColumnWidth(handle,ColumnIdx,LVSCW_AUTOSIZE);
end;


constructor TCoolListView.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FAutoSort := False;
     FLastColumn := -1;
     FSortAscend := True;
end;

function SortACaption(Item1, Item2: TListItem; ParamSort: Integer): Integer; stdcall;
begin
  if (StrToIntDef(Item1.Caption,0) <> 0) and
     (StrToIntDef(Item2.Caption,0) <> 0) then
      Result := StrToIntDef(Item1.Caption,0) - StrToIntDef(Item2.Caption,0)
   else
      Result := lstrcmp(PChar(Item1.Caption), PChar(Item2.Caption));
  if (ParamSort = 1) then Result := -Result;
end;

function SortASubItem(Item1, Item2: TListItem; idx: Integer): Integer; stdcall;
begin
  if (StrToIntDef(Item1.SubItems[idx],0) <> 0) and
     (StrToIntDef(Item2.SubItems[idx],0) <> 0) then
      Result := StrToIntDef(Item1.SubItems[idx],0) - StrToIntDef(Item2.SubItems[idx],0)
   else
     Result := lstrcmp(PChar(Item1.SubItems[idx]), PChar(Item2.SubItems[idx]));
end;

function SortDCaption(Item2, Item1: TListItem; ParamSort: Integer): Integer; stdcall;
begin
  if (StrToIntDef(Item1.Caption,0) <> 0) and
     (StrToIntDef(Item2.Caption,0) <> 0) then
      Result := StrToIntDef(Item1.Caption,0) - StrToIntDef(Item2.Caption,0)
   else
      Result := lstrcmp(PChar(Item1.Caption), PChar(Item2.Caption));
  if (ParamSort = 1) then Result := -Result;
end;

function SortDSubItem(Item2, Item1: TListItem; idx: Integer): Integer; stdcall;
begin
  if (StrToIntDef(Item1.SubItems[idx],0) <> 0) and
     (StrToIntDef(Item2.SubItems[idx],0) <> 0) then
      Result := StrToIntDef(Item1.SubItems[idx],0) - StrToIntDef(Item2.SubItems[idx],0)
   else
     Result := lstrcmp(PChar(Item1.SubItems[idx]), PChar(Item2.SubItems[idx]));
end;

{--Implementation of TCoolCheckBox-----------------------------------------------------}
constructor TCoolCheckBox.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     ReadOnly := False;
end;

procedure TCoolCheckBox.Toggle;
begin
     if not FReadOnly then inherited Toggle;
end;

{--Implementation of TCoolAboutDlg-----------------------------------------------------}
function TCoolAboutDlg.Execute : Boolean;
var
     MemoryStruct : TMemoryStatus;
     MemoryString : String;
     OSVersionInfo : TOSVersionInfo;
     Ver : String;
begin
     frmAboutDlg := TfrmAboutDlg.Create(Application);
     MemoryStruct.dwLength := SizeOf(MemoryStruct);
     GlobalMemoryStatus(MemoryStruct);
     MemoryStruct.dwTotalPhys := MemoryStruct.dwTotalPhys div 1024;
     MemoryString := IntToStr(MemoryStruct.dwTotalPhys);
     OSVersionInfo.dwOSVersionInfoSize := SizeOf(OSVersionInfo);
     GetVersionEx(OSVersionInfo);
     case OSVersionInfo.dwPlatformID of
          VER_PLATFORM_WIN32s        : Ver := 'Windows (Win32s)';
          VER_PLATFORM_WIN32_WINDOWS : Ver := 'Windows 95';
          VER_PLATFORM_WIN32_NT      : Ver := 'Windows NT';
     end;
     Ver := Ver + ' v' + IntToStr(OSVersionInfo.dwMajorVersion) +
                   '.' + IntToStr(OSVersionInfo.dwMinorVersion) +
                   ' (Build ' + IntToStr(OSVersionInfo.dwBuildNumber) + ')';
     try
       if FProduct = '' then FProduct := Application.Title;
       with frmAboutDlg do
         begin
           Caption := FTitle;
           lWVe.Caption := Ver;
           lRAM.Caption := Copy(MemoryString,1,length(MemoryString) -3) + ','
                         + Copy(MemoryString,length(MemoryString)-2,10) + ' KB';
           lPro.Caption := FProduct;
           lVer.Caption := FProduct2;
           lCop.Caption := FCopyright;
           lUsr.Caption := FRegUser;
           lCom.Caption := FRegCompany;
           imgPro.Picture.Icon := Application.Icon;
           Result := (ShowModal = IDOK);
         end;
     finally
       frmAboutDlg.Free;
     end;
end;

end.

