//-------------------------------------------------------------//
//                                                             //
//     PopupBox.hpp                                            //
//     Header for PopupBox                                     //
//     for Borland C++Builder                                  //
//     Copy this file into your C++Builder Include directory   //
//                                                             //
//-------------------------------------------------------------//

#ifndef PopUpBoxHPP
#define PopUpBoxHPP
//----------------------------------------------------------------------------
#include <StdCtrls.hpp>
#include <MainClss.hpp>
#include <DBTables.hpp>
#include <DB.hpp>
#include <Menus.hpp>
#include <Graphics.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <System.hpp>
namespace Popupbox
{
//-- type declarations -------------------------------------------------------
enum TPopupBoxAt { pbaAbove, pbaBelow };

enum TPopupBoxDoOn { doTakeValue, doShutup, doGoAway };

class __declspec(delphiclass) TPopupBoxLB;
class __declspec(pascalimplementation) TPopupBoxLB : public Mainclss::TPrxCustomVListBox
{
    typedef Mainclss::TPrxCustomVListBox inherited;
    
private:
    bool FAutoPos;
    TPopupBoxDoOn FDoOnClick;
    TPopupBoxDoOn FDoOnReturnKey;
    TPopupBoxAt FPopupAt;
    Windows::TRect FPopupBoundsRect;
    HIDESBASE MESSAGE void __fastcall CMEnter(Messages::TWMNoParams &p0);
    HIDESBASE MESSAGE void __fastcall CMShowingChanged(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &p0);
    HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &p0);
    MESSAGE void __fastcall WMMousMove(Messages::TWMMouse &p0);
    
protected:
    virtual void __fastcall CreateParams(Controls::TCreateParams &p0);
    virtual void __fastcall CreateWnd(void);
    virtual Menus::TPopupMenu* __fastcall GetPopupMenu(void);
    virtual void __fastcall WndProc(Messages::TMessage &p0);
    
public:
    void __fastcall (__closure *MPAutoPos)(void);
    __fastcall virtual TPopupBoxLB(Controls::TWinControl* p0);
    __fastcall virtual ~TPopupBoxLB(void);
    virtual void __fastcall DefaultDrawing(int p0, const Windows::TRect &p1);
    
__published:
    __property bool AutoPos = {read=FAutoPos, write=FAutoPos, default=1};
    __property TPopupBoxDoOn DoOnClick = {read=FDoOnClick, write=FDoOnClick, default=2};
    __property TPopupBoxDoOn DoOnReturnKey = {read=FDoOnReturnKey, write=FDoOnReturnKey, default=2};
    __property TPopupBoxAt PopupAt = {read=FPopupAt, write=FPopupAt, default=1};
    __property TabStop  = {stored=false, default=1};
public:
    /* TPrxCustomVListBox.Create */ __fastcall virtual TPopupBoxLB(Classes::TComponent* p0) : Mainclss::
        TPrxCustomVListBox(p0) { }
    
public:
    /* TWinControl.CreateParented */ __fastcall TPopupBoxLB(HWND ParentWindow) : Mainclss::TPrxCustomVListBox(
        ParentWindow) { }
    
};

class __declspec(delphiclass) TPopupListValues;
class __declspec(delphiclass) TCustomPopupBox;
enum TPopupBoxStyle { pbsDropDown, pbsDropDownList };

typedef void __fastcall (__closure *TSetFieldValueEvent)(System::TObject* Sender, int Index,  System::AnsiString &
    Value, bool &Allowed);

class __declspec(pascalimplementation) TCustomPopupBox : public Mainclss::TPrxCustomEditAlign
{
    typedef Mainclss::TPrxCustomEditAlign inherited;
    
private:
    Graphics::TColor FColorFocus;
    bool FIgnoreArrowKeys;
    bool FInUpdateText;
    TPopupBoxLB* FList;
    TPopupListValues* FListValues;
    TPopupBoxStyle FStyle;
    Classes::TNotifyEvent FOnListClick;
    Controls::TMouseMoveEvent FOnListMouseMove;
    TSetFieldValueEvent FOnSetFieldValue;
    bool DesignTimerActive;
    void __fastcall AutoPosMethod(void);
    int __fastcall GetListBoxItemIndex(void);
    Classes::TStringList* __fastcall GetListBoxItems(void);
    Stdctrls::TDrawItemEvent __fastcall GetOnDrawListItem(void);
    HIDESBASE System::AnsiString __fastcall GetText(void);
    void __fastcall SetListBoxItemIndex(int p0);
    void __fastcall SetOnDrawListItem(Stdctrls::TDrawItemEvent p0);
    void __fastcall SetStyle(TPopupBoxStyle p0);
    HIDESBASE void __fastcall SetText( System::AnsiString p0);
    HIDESBASE MESSAGE void __fastcall CMTextChanged(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &p0);
    HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &p0);
    HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &p0);
    HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &p0);
    
protected:
    virtual void __fastcall Change(void);
    virtual void __fastcall ChangeScale(int p0, int p1);
    virtual void __fastcall CreateWnd(void);
    virtual void __fastcall KeyDown(Word &p0, Classes::TShiftState p1);
    virtual void __fastcall KeyPress(char &p0);
    virtual void __fastcall PaintTheFocus(bool p0);
    void __fastcall ScrollListValues(int p0);
    virtual bool __fastcall SetListValueOnField(void);
    virtual void __fastcall TakeValue(TPopupBoxDoOn p0);
    virtual void __fastcall WndProc(Messages::TMessage &p0);
    __property Graphics::TColor ColorFocus = {read=FColorFocus, write=FColorFocus, default=8421504};
    __property bool IgnoreArrowKeys = {read=FIgnoreArrowKeys, write=FIgnoreArrowKeys, default=0};
    __property TPopupBoxStyle Style = {read=FStyle, write=SetStyle, nodefault};
    __property Stdctrls::TDrawItemEvent OnDrawListItem = {read=GetOnDrawListItem, write=SetOnDrawListItem
        };
    __property Classes::TNotifyEvent OnListClick = {read=FOnListClick, write=FOnListClick};
    __property Controls::TMouseMoveEvent OnListMouseMove = {read=FOnListMouseMove, write=FOnListMouseMove
        };
    __property TSetFieldValueEvent OnSetFieldValue = {read=FOnSetFieldValue, write=FOnSetFieldValue};
    
public:
    __fastcall virtual TCustomPopupBox(Classes::TComponent* p0);
    __fastcall virtual ~TCustomPopupBox(void);
    virtual void __fastcall PopItUp(void);
    virtual void __fastcall ShutItUp(void);
    virtual void __fastcall SpecialPainting(int p0, Graphics::TCanvas* p1);
    __property int ItemIndex = {read=GetListBoxItemIndex, write=SetListBoxItemIndex, stored=false, nodefault
        };
    __property Classes::TStringList* Items = {read=GetListBoxItems, stored=false, nodefault};
    __property TPopupBoxLB* ListBox = {read=FList, nodefault};
    __property TPopupListValues* List = {read=FListValues, write=FListValues, nodefault};
    __property System::AnsiString Text = {read=GetText, write=SetText, nodefault};
    __property WordWrap ;
public:
    /* TWinControl.CreateParented */ __fastcall TCustomPopupBox(HWND ParentWindow) : Mainclss::TPrxCustomEditAlign(
        ParentWindow) { }
    
};

class __declspec(pascalimplementation) TPopupListValues : public Classes::TPersistent
{
    typedef Classes::TPersistent inherited;
    
private:
    TCustomPopupBox* FPopupBox;
    TPopupBoxLB* FList;
    Classes::TAlignment __fastcall GetAlignment(void);
    bool __fastcall GetAutoPos(void);
    Forms::TBorderStyle __fastcall GetBorderStyle(void);
    Graphics::TColor __fastcall GetColor(void);
    Graphics::TColor __fastcall GetColorSel(void);
    Graphics::TColor __fastcall GetColorSelBG(void);
    TPopupBoxDoOn __fastcall GetDoOnClick(void);
    TPopupBoxDoOn __fastcall GetDoOnReturnKey(void);
    Graphics::TFont* __fastcall GetFont(void);
    int __fastcall GetHeight(void);
    System::AnsiString __fastcall GetHint(void);
    Classes::TStringList* __fastcall GetItems(void);
    int __fastcall GetItemHeight(void);
    int __fastcall GetLeft(void);
    bool __fastcall GetParentFont(void);
    TPopupBoxAt __fastcall GetPopupAt(void);
    bool __fastcall GetSel3D(void);
    bool __fastcall GetShowHint(void);
    bool __fastcall GetSorted(void);
    int __fastcall GetTop(void);
    int __fastcall GetWidth(void);
    bool __fastcall IsFontStored(void);
    void __fastcall SetAlignment(Classes::TAlignment p0);
    void __fastcall SetAutoPos(bool p0);
    void __fastcall SetBorderStyle(Forms::TBorderStyle p0);
    void __fastcall SetColor(Graphics::TColor p0);
    void __fastcall SetColorSel(Graphics::TColor p0);
    void __fastcall SetColorSelBG(Graphics::TColor p0);
    void __fastcall SetDoOnClick(TPopupBoxDoOn p0);
    void __fastcall SetDoOnReturnKey(TPopupBoxDoOn p0);
    void __fastcall SetFont(Graphics::TFont* p0);
    void __fastcall SetHeight(int p0);
    void __fastcall SetHint( System::AnsiString p0);
    void __fastcall SetItems(Classes::TStringList* p0);
    void __fastcall SetItemHeight(int p0);
    void __fastcall SetLeft(int p0);
    void __fastcall SetParentFont(bool p0);
    void __fastcall SetPopupAt(TPopupBoxAt p0);
    void __fastcall SetSel3D(bool p0);
    void __fastcall SetShowHint(bool p0);
    void __fastcall SetSorted(bool p0);
    void __fastcall SetTop(int p0);
    void __fastcall SetWidth(int p0);
    
public:
    __fastcall TPopupListValues(TCustomPopupBox* p0);
    
__published:
    __property Classes::TAlignment Alignment = {read=GetAlignment, write=SetAlignment, default=0};
    __property bool AutoPos = {read=GetAutoPos, write=SetAutoPos, default=1};
    __property Forms::TBorderStyle BorderStyle = {read=GetBorderStyle, write=SetBorderStyle, default=1}
        ;
    __property Graphics::TColor Color = {read=GetColor, write=SetColor, default=12639424};
    __property Graphics::TColor ColorSel = {read=GetColorSel, write=SetColorSel, default=8388608};
    __property Graphics::TColor ColorSelBG = {read=GetColorSelBG, write=SetColorSelBG, default=15780518
        };
    __property TPopupBoxDoOn DoOnClick = {read=GetDoOnClick, write=SetDoOnClick, default=2};
    __property TPopupBoxDoOn DoOnReturnKey = {read=GetDoOnReturnKey, write=SetDoOnReturnKey, default=2}
        ;
    __property Graphics::TFont* Font = {read=GetFont, write=SetFont, stored=IsFontStored, nodefault};
    __property int Height = {read=GetHeight, write=SetHeight, nodefault};
    __property System::AnsiString Hint = {read=GetHint, write=SetHint, nodefault};
    __property Classes::TStringList* Items = {read=GetItems, write=SetItems, nodefault};
    __property int ItemHeight = {read=GetItemHeight, write=SetItemHeight, nodefault};
    __property int Left = {read=GetLeft, write=SetLeft, default=0};
    __property bool ParentFont = {read=GetParentFont, write=SetParentFont, default=1};
    __property TPopupBoxAt PopupAt = {read=GetPopupAt, write=SetPopupAt, default=1};
    __property bool Sel3D = {read=GetSel3D, write=SetSel3D, default=1};
    __property bool ShowHint = {read=GetShowHint, write=SetShowHint, default=0};
    __property bool Sorted = {read=GetSorted, write=SetSorted, default=0};
    __property int Top = {read=GetTop, write=SetTop, default=0};
    __property int Width = {read=GetWidth, write=SetWidth, nodefault};
public:
    /* TObject.Destroy */ __fastcall virtual ~TPopupListValues(void) { }
    
};

class __declspec(delphiclass) TPopupBox;
class __declspec(pascalimplementation) TPopupBox : public TCustomPopupBox
{
    typedef TCustomPopupBox inherited;
    
__published:
    __property Alignment ;
    __property AutoSelect ;
    __property AutoSize ;
    __property BorderStyle ;
    __property CaretAtEnd ;
    __property CharCase ;
    __property Color ;
    __property ColorFocus ;
    __property Ctl3D ;
    __property DoOnReturnKey ;
    __property DragCursor ;
    __property DragMode ;
    __property Enabled ;
    __property Font ;
    __property MaxLength ;
    __property OEMConvert ;
    __property ParentColor ;
    __property ParentCtl3D ;
    __property ParentFont ;
    __property ParentShowHint ;
    __property PopupMenu ;
    __property ReadOnly ;
    __property ShowButton ;
    __property ShowButtonWidth ;
    __property ShowHint ;
    __property Style ;
    __property TabOrder ;
    __property TabStop ;
    __property Text ;
    __property TrimText ;
    __property Visible ;
    __property OnChange ;
    __property OnClick ;
    __property OnDblClick ;
    __property OnDragDrop ;
    __property OnDragOver ;
    __property OnEndDrag ;
    __property OnEnter ;
    __property OnExit ;
    __property OnKeyDown ;
    __property OnKeyPress ;
    __property OnKeyUp ;
    __property OnMouseDown ;
    __property OnMouseMove ;
    __property OnMouseUp ;
    __property OnStartDrag ;
    __property DropDownOn ;
    __property IgnoreArrowKeys ;
    __property List ;
    __property OnListClick ;
    __property OnListMouseMove ;
    __property OnDrawListItem ;
    __property OnPopup ;
    __property OnSetFieldValue ;
    __property OnShutup ;
public:
    /* TCustomPopupBox.Create */ __fastcall virtual TPopupBox(Classes::TComponent* p0) : Popupbox::TCustomPopupBox(
        p0) { }
    /* TCustomPopupBox.Destroy */ __fastcall virtual ~TPopupBox(void) { }
    
public:
    /* TWinControl.CreateParented */ __fastcall TPopupBox(HWND ParentWindow) : Popupbox::TCustomPopupBox(
        ParentWindow) { }
    
};

class __declspec(delphiclass) TPopupBoxDates;
class __declspec(pascalimplementation) TPopupBoxDates : public TCustomPopupBox
{
    typedef TCustomPopupBox inherited;
    
private:
    int FAscending;
    Graphics::TColor FColorSaturday;
    Graphics::TColor FColorSunday;
    Word FDateBeginD;
    Word FDateBeginM;
    Word FDateBeginY;
    Word FDateEndD;
    Word FDateEndM;
    Word FDateEndY;
    System::TDateTime FDateBegin;
    System::TDateTime FDateEnd;
    System::AnsiString FDateFormatList;
    int FHolidayYear;
    System::TDateTime FHolidays[9];
    bool FIsCalculated;
    HIDESBASE void __fastcall AutoPosMethod(void);
    void __fastcall CalcDates(void);
    bool __fastcall CheckIsGermanHoliday(System::TDateTime p0);
    System::TDateTime __fastcall GetDateBegin(void);
    System::TDateTime __fastcall GetDateEnd(void);
    void __fastcall SetDateBeginD(Word p0);
    void __fastcall SetDateBeginM(Word p0);
    void __fastcall SetDateBeginY(Word p0);
    void __fastcall SetDateEndD(Word p0);
    void __fastcall SetDateEndM(Word p0);
    void __fastcall SetDateEndY(Word p0);
    
protected:
    int __fastcall GetListItemCount(void);
    System::AnsiString __fastcall GetListItemValue(int p0);
    virtual void __fastcall KeyDown(Word &p0, Classes::TShiftState p1);
    virtual bool __fastcall SetListValueOnField(void);
    
public:
    __fastcall virtual TPopupBoxDates(Classes::TComponent* p0);
    virtual void __fastcall PopItUp(void);
    virtual void __fastcall SpecialPainting(int p0, Graphics::TCanvas* p1);
    __property System::TDateTime DateBegin = {read=GetDateBegin};
    __property System::TDateTime DateEnd = {read=GetDateEnd};
    
__published:
    __property Alignment ;
    __property AutoSelect ;
    __property AutoSize ;
    __property BorderStyle ;
    __property CaretAtEnd ;
    __property CharCase ;
    __property Color ;
    __property ColorFocus ;
    __property Ctl3D ;
    __property DoOnReturnKey ;
    __property DragCursor ;
    __property DragMode ;
    __property Enabled ;
    __property Font ;
    __property MaxLength ;
    __property OEMConvert ;
    __property ParentColor ;
    __property ParentCtl3D ;
    __property ParentFont ;
    __property ParentShowHint ;
    __property PopupMenu ;
    __property ShowButton ;
    __property ShowButtonWidth ;
    __property ShowHint ;
    __property Style ;
    __property TabOrder ;
    __property TabStop ;
    __property Text ;
    __property Visible ;
    __property OnChange ;
    __property OnClick ;
    __property OnDblClick ;
    __property OnDragDrop ;
    __property OnDragOver ;
    __property OnEndDrag ;
    __property OnEnter ;
    __property OnExit ;
    __property OnKeyDown ;
    __property OnKeyPress ;
    __property OnKeyUp ;
    __property OnMouseDown ;
    __property OnMouseMove ;
    __property OnMouseUp ;
    __property OnStartDrag ;
    __property Graphics::TColor ColorSaturday = {read=FColorSaturday, write=FColorSaturday, default=8388608
        };
    __property Graphics::TColor ColorSunday = {read=FColorSunday, write=FColorSunday, default=255};
    __property Word DateBeginDay = {read=FDateBeginD, write=SetDateBeginD, nodefault};
    __property Word DateBeginMonth = {read=FDateBeginM, write=SetDateBeginM, nodefault};
    __property Word DateBeginYear = {read=FDateBeginY, write=SetDateBeginY, nodefault};
    __property Word DateEndDay = {read=FDateEndD, write=SetDateEndD, nodefault};
    __property Word DateEndMonth = {read=FDateEndM, write=SetDateEndM, nodefault};
    __property Word DateEndYear = {read=FDateEndY, write=SetDateEndY, nodefault};
    __property System::AnsiString DateFormatList = {read=FDateFormatList, write=FDateFormatList, nodefault
        };
    __property DropDownOn ;
    __property List ;
    __property OnListClick ;
    __property OnListMouseMove ;
    __property OnDrawListItem ;
    __property OnPopup ;
    __property OnSetFieldValue ;
    __property OnShutup ;
public:
    /* TCustomPopupBox.Destroy */ __fastcall virtual ~TPopupBoxDates(void) { }
    
public:
    /* TWinControl.CreateParented */ __fastcall TPopupBoxDates(HWND ParentWindow) : Popupbox::TCustomPopupBox(
        ParentWindow) { }
    
};

class __declspec(delphiclass) TDBPopupBox;
class __declspec(pascalimplementation) TDBPopupBox : public TCustomPopupBox
{
    typedef TCustomPopupBox inherited;
    
private:
    Dbtables::TFieldDataLink* FDataLink;
    bool FFocused;
    bool FDBTextLoaded;
    void __fastcall DataChange(System::TObject* p0);
    void __fastcall EditingChange(System::TObject* p0);
    System::AnsiString __fastcall GetDataField(void);
    Db::TDataSource* __fastcall GetDataSource(void);
    Db::TField* __fastcall GetField(void);
    bool __fastcall GetReadOnly(void);
    void __fastcall SetDataField(const System::AnsiString p0);
    void __fastcall SetDataSource(Db::TDataSource* p0);
    HIDESBASE void __fastcall SetReadOnly(bool p0);
    void __fastcall SetFocused(bool p0);
    void __fastcall UpdateData(System::TObject* p0);
    MESSAGE void __fastcall WMCut(Messages::TMessage &p0);
    MESSAGE void __fastcall WMPaste(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall CMEnter(Messages::TWMNoParams &p0);
    HIDESBASE MESSAGE void __fastcall CMExit(Messages::TWMNoParams &p0);
    MESSAGE void __fastcall CMGetDataLink(Messages::TMessage &p0);
    
protected:
    virtual void __fastcall Change(void);
    virtual void __fastcall KeyDown(Word &p0, Classes::TShiftState p1);
    virtual void __fastcall KeyPress(char &p0);
    virtual void __fastcall Loaded(void);
    virtual void __fastcall Notification(Classes::TComponent* p0, Classes::TOperation p1);
    virtual bool __fastcall SetListValueOnField(void);
    
public:
    __fastcall virtual TDBPopupBox(Classes::TComponent* p0);
    __fastcall virtual ~TDBPopupBox(void);
    void __fastcall LoadDBText(void);
    __property Db::TField* Field = {read=GetField, nodefault};
    
__published:
    __property Alignment ;
    __property AutoSelect ;
    __property AutoSize ;
    __property BorderStyle ;
    __property CaretAtEnd ;
    __property CharCase ;
    __property Color ;
    __property ColorFocus ;
    __property Ctl3D ;
    __property System::AnsiString DataField = {read=GetDataField, write=SetDataField, nodefault};
    __property Db::TDataSource* DataSource = {read=GetDataSource, write=SetDataSource, nodefault};
    __property DoOnReturnKey ;
    __property DragCursor ;
    __property DragMode ;
    __property DropDownOn ;
    __property Enabled ;
    __property Font ;
    __property IgnoreArrowKeys ;
    __property List ;
    __property MaxLength ;
    __property OEMConvert ;
    __property ParentColor ;
    __property ParentCtl3D ;
    __property ParentFont ;
    __property ParentShowHint ;
    __property PopupMenu ;
    __property bool ReadOnly = {read=GetReadOnly, write=SetReadOnly, default=0};
    __property ShowButton ;
    __property ShowButtonWidth ;
    __property ShowHint ;
    __property Style ;
    __property TabOrder ;
    __property TabStop ;
    __property Visible ;
    __property OnChange ;
    __property OnClick ;
    __property OnDblClick ;
    __property OnDragDrop ;
    __property OnDragOver ;
    __property OnDrawListItem ;
    __property OnEndDrag ;
    __property OnEnter ;
    __property OnExit ;
    __property OnKeyDown ;
    __property OnKeyPress ;
    __property OnKeyUp ;
    __property OnListClick ;
    __property OnListMouseMove ;
    __property OnMouseDown ;
    __property OnMouseMove ;
    __property OnMouseUp ;
    __property OnPopup ;
    __property OnSetFieldValue ;
    __property OnShutup ;
    __property OnStartDrag ;
public:
    /* TWinControl.CreateParented */ __fastcall TDBPopupBox(HWND ParentWindow) : Popupbox::TCustomPopupBox(
        ParentWindow) { }
    
};

//-- var, const, procedure ---------------------------------------------------
extern bool __fastcall PrxStrIComp(char * p0, char * p1, int &p2);
extern void __fastcall GetGermanPublicHolidays(int p0, System::TDateTime * p1, const int p1_Size);
extern void __fastcall Register(void);

}   /* namespace Popupbox */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Popupbox;
#endif
//-- end unit ----------------------------------------------------------------
#endif  // PopUpBox
