unit Fdemo02;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Grids, Buttons, ExtCtrls, PrnWin,
  DBTables, CB_Types, Totals, Mask, DBPrnWin, CB_MFunc;

type
  TForm02 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Table2: TTable;
    DataSource2: TDataSource;
    DataSource3: TDataSource;
    Table3: TTable;
    Table3OrderNo: TFloatField;
    Table3ItemNo: TFloatField;
    Table3PartNo: TFloatField;
    Table3Description: TStringField;
    Table3Qty: TIntegerField;
    Table3ListPrice: TCurrencyField;
    Table3Discount: TFloatField;
    Table3Total: TCurrencyField;
    Table4: TTable;
    Table4PartNo: TFloatField;
    Table4VendorNo: TFloatField;
    Table4Description: TStringField;
    Table4OnHand: TFloatField;
    Table4OnOrder: TFloatField;
    Table4Cost: TCurrencyField;
    Table4ListPrice: TCurrencyField;
    DataSource4: TDataSource;
    Panel1: TPanel;
    DBNavigator: TDBNavigator;
    Print: TBitBtn;
    Exit: TBitBtn;
    Preview: TBitBtn;
    ScrollBox1: TScrollBox;
    Panel2: TPanel;
    DBGrid1: TDBGrid;
    SubTotal: TShowTotal;
    Shape2: TShape;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    EditShipToPhone: TDBEdit;
    EditOrderNo: TDBEdit;
    EditCustNo: TDBEdit;
    Panel4: TPanel;
    DBEdit2: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBEdit6: TDBEdit;
    DBEdit7: TDBEdit;
    DBEdit8: TDBEdit;
    Panel5: TPanel;
    DBEdit9: TDBEdit;
    DBEdit10: TDBEdit;
    DBEdit11: TDBEdit;
    DBEdit12: TDBEdit;
    DBEdit13: TDBEdit;
    DBEdit14: TDBEdit;
    DBEdit15: TDBEdit;
    Edit4: TEdit;
    EditShipVIA: TDBEdit;
    Edit5: TEdit;
    EditPO: TDBEdit;
    Edit6: TEdit;
    EditTerms: TDBEdit;
    Edit7: TEdit;
    EditSaleDate: TDBEdit;
    Edit8: TEdit;
    EditShipDate: TDBEdit;
    Edit9: TEdit;
    EditPaymentMethod: TDBEdit;
    Shape3: TShape;
    Label6: TLabel;
    Memo2: TMemo;
    Edit19: TEdit;
    Edit20: TEdit;
    DBEdit1: TDBEdit;
    Edit21: TEdit;
    Image1: TImage;
    ShowTotal2: TShowTotal;
    ShowTotal3: TShowTotal;
    ShowTotal4: TShowTotal;
    ShowTotal5: TShowTotal;
    ShowTotal6: TShowTotal;
    Label5: TLabel;
    Label4: TLabel;
    Label7: TLabel;
    Label3: TLabel;
    Label8: TLabel;
    Label2: TLabel;
    Tax: TShowTotal;
    Freight: TShowTotal;
    Miscellaneous: TShowTotal;
    Total: TShowTotal;
    ShowTotal1: TShowTotal;
    ShowTotal7: TShowTotal;
    DBPrintWin1: TDBPrintWin;
    procedure FormCreate(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure Table3CalcFields(DataSet: TDataset);
    procedure PrintWin1PrintHeader(Sender: TObject);
    procedure PrintClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form02: TForm02;

implementation

{$R *.DFM}

procedure TForm02.FormCreate(Sender: TObject);
begin
  Table1.Open;
  Table2.Open;
  ScrollBox1.VertScrollBar.Position := 0;
end;

procedure TForm02.PreviewClick(Sender: TObject);
begin
  ScrollBox1.VertScrollBar.Position := 0;
  DBPrintWin1.OutputTo := poViewer;
  DBPrintWin1.BeginPrint;
  DBPrintWin1.DrawWindowMultiple( 1, 1, Panel2);

  DBPrintWin1.EndPrint;

end;

procedure TForm02.Table3CalcFields(DataSet: TDataset);
var
	St: Boolean;
begin

  Table3ListPrice.Value := Table4ListPrice.Value;
  Table3Total.Value := Table3ListPrice.Value * Table3Qty.Value;

 	Table4.Active := True;
 	Table4.GoToKey;
  Table4.FindKey([Table3PartNo.AsString]);
 	Table3Description.Value := Table4Description.Value;

end;

procedure TForm02.PrintWin1PrintHeader(Sender: TObject);
var
	Tot: Real;
	Cur: Real;
begin
	if DBPrintWin1.IsLastPage then begin
      Tot := 0.00;
      Cur := 0.00;
		Tot := DBPrintWin1.GetRunningTotal(DBGrid1, 'Total');

		{ Say tax = 10% }
		Cur := Tot * 0.1;
		Tax.Text := FormatFloat('$ #,##0.00',Cur);
		Tot := Tot + Cur;

		{ Add Freight say fixed }
		Cur := 100.0;
		Freight.Text := FormatFloat('$ #,##0.00',Cur);
		Tot := Tot + Cur;

		{ Misc = 0 }
		Cur := 0.00;
		Miscellaneous.Text := FormatFloat('$ #,##0.00',Cur);
		Total.Text := FormatFloat('$ #,##0.00',Tot);
  end;
end;

procedure TForm02.PrintClick(Sender: TObject);
begin
	DBPrintWin1.OutputTo := poPrinter;
	DBPrintWin1.BeginPrint;
   ScrollBox1.VertScrollBar.Position := 0;

  DBPrintWin1.DrawWindowMultiple( 1, 1, ScrollBox1);

  DBPrintWin1.EndPrint;
end;

procedure TForm02.ExitClick(Sender: TObject);
begin
	Close;
end;

end.