{ ****************************************************************** }
{                                                                    }
{   Delphi component TRomanNum                                       }
{                                                                    }
{   Copyright  1995 by Indigo Software                              }
{                                                                    }
{ ****************************************************************** }

(*---------------------------------------------------------------------|
Description:

This component returns the string equivalent of a roman numeral for any
value between 1 and 3999.

Properties:

Number: Integer
      Any number between 1 and 3999.

RomanNumeral: String
      The roman numeral string equivalent for the above number, or the
      words 'Too Big' if the number exceeds 3999.
|---------------------------------------------------------------------*)
unit RomanNum;

interface

{$IFDEF WIN32}
uses Messages, Windows, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ELSE}
uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ENDIF}


type
  TRomanNum = class(TComponent)
    private
        FNumber : Integer;
        FRomanNumeral : String;
        procedure AutoInitialize;
        procedure AutoDestroy;
        procedure SetNumber(Value : Integer);
        function GetRomanNumeral : String;
        procedure SetRomanNumeral(Value : String);
        function Roman(Number:integer):string;

    protected
    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
        property Number : Integer read FNumber write SetNumber default 0;
        property RomanNumeral : String
             read GetRomanNumeral write SetRomanNumeral;

  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Indigo Widgets', [TRomanNum]);
end;

{ Method to set variable and property values and create objects }
procedure TRomanNum.AutoInitialize;
begin
     FNumber := 0;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TRomanNum.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Write method for property Number }
procedure TRomanNum.SetNumber(Value : Integer);
begin
     FNumber := Value;
end;

{ Read method for property RomanNumeral }
function TRomanNum.GetRomanNumeral : String;
begin
     GetRomanNumeral := roman(fNumber);
end;

{ Write method for property RomanNumeral }
procedure TRomanNum.SetRomanNumeral(Value : String);
begin
     
end;

constructor TRomanNum.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
end;

destructor TRomanNum.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

function TRomanNum.Roman(Number:integer):string;
   var
      i,j,l: integer;
      digit,valtest: integer;
      numstr: string[4];
      romtab: array[1..4] of string[3];
      romnum: string;
begin { roman }
   {The maximum size for this control is 3,999}
   if number > 3999 then begin
      roman := 'toobig';
      exit;
   end; {endif}
   romtab[1] := 'XVI';
   romtab[2] := 'CLX';
   romtab[3] := 'MDC';
   romtab[4] := '  M';
   romnum := ''; 
   str(number,numstr);
   l := length(numstr);
   for i := 1 to l do begin
      val(numstr[(l-i)+1],digit,valtest);
      case digit of
         0..3:
         for j := 0 to digit-1 do begin
            romnum := romtab[i][3] + romnum;
         end; {end for}
         4: romnum := romtab[i][3] + romtab[i][2] + romnum; 
         5..8:
         begin
            for j := 5 to digit-1 do begin
               romnum := romtab[i][3] + romnum; 
            end; {end for}
            romnum := romtab[i][2] + romnum
         end;
         9: romnum := romtab[i][3] + romtab[i][1] + romnum; 
      end; {end case}
   end; {end for}
roman:=romnum;
end; { roman }



end.
