unit ShowIcon;

{$IFNDEF WIN32}
         ERROR ! This unit only available on Win32!
{$ENDIF}


interface

uses
  Windows, Messages, SysUtils,Classes, Graphics, Forms,Dialogs,
  Controls,DsgnIntf,ExtCtrls;

{$IFDEF VER90}
CONST  SIJustOne    = 'Ein TShowIcon reicht..';
       SIOnlyInForm = 'Nicht in DataModule plazieren..';
{$ELSE}
ResourceString
       SIJustOne    = 'Ein TShowIcon reicht..';
       SIOnlyInForm = 'Nicht in DataModule plazieren..';
{$ENDIF}



type
  TShowIcon = Class;
  TShowIcon = class(TComponent)
  private
    FOwnerForm: TForm;
    FAbout    : string;
    FIconText : String;
    FImage1   : TImage;
    FImage2   : TImage;
    FImage3   : TImage;
    FImage4   : TImage;
    SaveAppIcon : TIcon;
    SaveIconText: String;

    FunTimer   : TTimer;
    CurrentState : Byte; {Which Icon to display next 1 through 4}
    procedure SetEnabled(Value: Boolean);
    Function GetEnabled: Boolean;
    procedure SetInterval(Value: Cardinal);
    Function GetInterval: Cardinal;

    procedure FunTimerTimer(Sender: TObject);
    procedure SetPicture1(Value: TPicture);
    Function  GetPicture1 : TPicture;
    procedure SetPicture2(Value: TPicture);
    Function  GetPicture2 : TPicture;
    procedure SetPicture3(Value: TPicture);
    Function  GetPicture3 : TPicture;
    procedure SetPicture4(Value: TPicture);
    Function  GetPicture4 : TPicture;
    Procedure SetIconText(Const Value : String);
  public
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    procedure ShowAbout;
  published
    property IconText: String read FIconText write SetIconText;
    property Enabled: Boolean read GetEnabled write SetEnabled default True;
    property Interval: Cardinal read GetInterval write SetInterval Default 500;
    property Picture1: TPicture read GetPicture1 write SetPicture1;
    property Picture2: TPicture read GetPicture2 write SetPicture2;
    property Picture3: TPicture read GetPicture3 write SetPicture3;
    property Picture4: TPicture read GetPicture4 write SetPicture4;
    property About: string read FAbout write FAbout stored False;
  end;

procedure Register;

implementation

{########################################################################}
type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

{#############################################################################}
procedure Register;
begin
  RegisterComponents('System', [TShowIcon]);
  {register the 'About' property editor}
  RegisterPropertyEditor(TypeInfo(String), TShowIcon, 'About',
  	TAboutProperty);
end;

{########################################################################}
procedure TAboutProperty.Edit;
{call the 'About' dialog window when clicking on ... in the Object Inspector}
begin
  TShowIcon(GetComponent(0)).ShowAbout;
end;

{########################################################################}
function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

{########################################################################}
function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About)';
end;

{########################################################################}
procedure TShowIcon.ShowAbout;
var msg: string;
const
  cr = chr(13);
begin
  msg := 'TShowIcon v1.01' + cr + 'A Freeware component' + cr;
  msg := msg + '(32 bit version)' + cr + cr;
  msg := msg + 'Copyright  1997,Ralf Loga' + cr;
  msg := msg + 'e-mail 100451.2507@compuserve.com' + cr;
  ShowMessage(msg);
end;

{########################################################################}
constructor TShowIcon.Create(AOwner: TComponent);
VAR F : TForm;
    I : Integer;
begin
  inherited Create(AOwner);
  FOwnerForm:=NIL;
   if AOwner is TForm then
   F := TForm(AOwner) else
 if AOwner is TControl then
{$IFDEF VER90}
   F := GetParentForm(TControl(AOwner))
{$ELSE}
   F := TFORM(GetParentForm(TControl(AOwner)))
{$ENDIF}
 else
   F := nil;
 if F<>nil then
 begin
   for i := 0 to F.ComponentCount-1 do
     if (F.Components[i] is TShowIcon) and
        (F.Components[i]<>Self) then
     begin
       MessageBeep(0);
       raise Exception.Create(SIJustOne);
     end;
 end else
 begin
   MessageBeep(0);
   raise Exception.Create(SIOnlyInForm);
 end;

  FOwnerForm:=F;
  SaveAppIcon:=TIcon.Create;
  SaveAppIcon.Assign(Application.Icon);
  SaveIconText:=Application.Title;
  FImage1:=TImage.Create(Application);
  FImage2:=TImage.Create(Application);
  FImage3:=TImage.Create(Application);
  FImage4:=TImage.Create(Application);
  FunTimer:=TTimer.Create(Application);
  SetInterval(500);
  FunTimer.OnTimer:=FunTimerTimer;
  SetEnabled(TRUE);
  CurrentState:=1;
  SetIconText('-> 10 %');
end;

{########################################################################}
destructor TShowIcon.Destroy;
begin
{
  IF Assigned(FOwnerForm) THEN
  SetEnabled(FALSE);
}
  inherited Destroy;
end;


{########################################################################}
procedure TShowIcon.SetEnabled(Value: Boolean);
begin
  Funtimer.Enabled := Value;
end;

{########################################################################}
Function TShowIcon.GetEnabled: Boolean;
BEGIN
   Result:=Funtimer.Enabled;
END;

{########################################################################}
procedure TShowIcon.SetInterval(Value: Cardinal);
begin
  Funtimer.Interval:= Value;
end;

{########################################################################}
Function TShowIcon.GetInterval: Cardinal;
BEGIN
  Result:=Funtimer.Interval;
END;

{########################################################################}
procedure TShowIcon.FunTimerTimer(Sender: TObject);
BEGIN
  if IsIconic(Application.Handle) then
    Begin
     Application.Title :=SaveIconText + ' '+FIconText;
     case CurrentState Of
      1:IF Not FImage1.Picture.Icon.Empty THEN
         Application.Icon.Assign(FImage1.Picture.Icon);
      2:IF Not FImage2.Picture.Icon.Empty THEN
         Application.Icon.Assign(FImage2.Picture.Icon);
      3:IF Not FImage3.Picture.Icon.Empty THEN
         Application.Icon.Assign(FImage3.Picture.Icon);
      4:IF Not FImage4.Picture.Icon.Empty THEN
         Application.Icon.Assign(FImage4.Picture.Icon);
      end;{case}
     InvalidateRect(Application.Handle, nil, True);
     inc(CurrentState);
     if CurrentState>4 then
       CurrentState:=1;
    End
   ELSE
    BEGIN
     Application.Title := SaveIconText;
     Application.Icon.Assign(SaveAppIcon);
    END;
end;


{########################################################################}
procedure TShowIcon.SetPicture1(Value: TPicture);
BEGIN
  FImage1.Picture.Assign(Value);
END;

{########################################################################}
Function TShowIcon.GetPicture1 : TPicture;
BEGIN
   Result:=FImage1.Picture;
END;

{########################################################################}
procedure TShowIcon.SetPicture2(Value: TPicture);
BEGIN
  FImage2.Picture.Assign(Value);
END;

{########################################################################}
Function TShowIcon.GetPicture2 : TPicture;
BEGIN
   Result:=FImage2.Picture;
END;

{########################################################################}
procedure TShowIcon.SetPicture3(Value: TPicture);
BEGIN
  FImage3.Picture.Assign(Value);
END;

{########################################################################}
Function TShowIcon.GetPicture3 : TPicture;
BEGIN
   Result:=FImage3.Picture;
END;

{########################################################################}
procedure TShowIcon.SetPicture4(Value: TPicture);
BEGIN
  FImage4.Picture.Assign(Value);
END;

{########################################################################}
Function TShowIcon.GetPicture4 : TPicture;
BEGIN
   Result:=FImage4.Picture;
END;

{########################################################################}
Procedure TShowIcon.SetIconText(Const Value : String);
BEGIN
 IF Value <> FIconText THEN
 FIconText:=VALUE;
END;

end.



