unit Example;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TASKMAN, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    TaskMan1: TTaskMan;
    ComboBox1: TComboBox;
    ListBox2: TListBox;
    ComboBox2: TComboBox;
    TaskMan2: TTaskMan;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label4: TLabel;
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure GetActiveControlTask(var actTask: TTaskInfo_t);
    procedure Button3Click(Sender: TObject);
    procedure TaskMan2Fail(Sender: TObject);
    procedure TaskMan1Fail(Sender: TObject);
    procedure TaskMan2ExecuteTaskFail(Sender: TObject);
    procedure TaskMan2EndTaskFail(Sender: TObject);
    procedure TaskMan2DrawFail(Sender: TObject);
    procedure TaskMan2MeasureFail(Sender: TObject);
    procedure TaskMan1DrawFail(Sender: TObject);
    procedure TaskMan1EndTaskFail(Sender: TObject);
    procedure TaskMan1ExecuteTaskFail(Sender: TObject);
    procedure TaskMan1MeasureFail(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  myTask: TTaskInfo_t;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  Taskman1.ShowVisibleOnly:=CheckBox2.Checked;
  Taskman2.ShowVisibleOnly:=CheckBox2.Checked;

  Taskman1.IncludeCurrentTask:=CheckBox2.Checked;
  Taskman2.IncludeCurrentTask:=CheckBox2.Checked;

  TaskMan1.FillTaskList;
  TaskMan2.FillTaskList;
  ComboBox1.ItemIndex:=0;
  ComboBox2.ItemIndex:=0;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var
  myIcon: TIcon;
begin
  myIcon:=TIcon.Create;
  TaskMan1.GetTaskProperties(ListBox1,myTask);
  Edit1.Text:=myTask.TaskName;
  Edit2.Text:=myTask.TaskExeName;
  Label4.Caption:='Window class '+myTask.TaskWindowClass;
  myIcon.Handle:=myTask.TaskIcon;
  Image1.Picture.Icon:=myIcon;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var
  myIcon: TIcon;
begin
  myIcon:=TIcon.Create;
  TaskMan1.GetTaskProperties(ComboBox1,myTask);
  Edit1.Text:=myTask.TaskName;
  Edit2.Text:=myTask.TaskExeName;
  Label4.Caption:='Window class '+myTask.TaskWindowClass;
  myIcon.Handle:=myTask.TaskIcon;
  Image1.Picture.Icon:=myIcon;
end;

procedure TForm1.ListBox2Click(Sender: TObject);
var
  myIcon: TIcon;
begin
  myIcon:=TIcon.Create;
  TaskMan1.GetTaskProperties(ListBox2,myTask);
  Edit1.Text:=myTask.TaskName;
  Edit2.Text:=myTask.TaskExeName;
  Label4.Caption:='Window class '+myTask.TaskWindowClass;
  myIcon.Handle:=myTask.TaskIcon;
  Image1.Picture.Icon:=myIcon;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
var
  myIcon: TIcon;
begin
  myIcon:=TIcon.Create;
  TaskMan1.GetTaskProperties(ComboBox2,myTask);
  Edit1.Text:=myTask.TaskName;
  Edit2.Text:=myTask.TaskExeName;
  Label4.Caption:='Window class '+myTask.TaskWindowClass;
  myIcon.Handle:=myTask.TaskIcon;
  Image1.Picture.Icon:=myIcon;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Taskman1.ShowVisibleOnly:=CheckBox1.Checked;
  Taskman2.ShowVisibleOnly:=CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  Taskman1.IncludeCurrentTask:=CheckBox2.Checked;
  Taskman2.IncludeCurrentTask:=CheckBox2.Checked;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TaskMan1.FillTaskList;
  TaskMan2.FillTaskList;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   TaskMan1.GetTaskProperties(ActiveControl,myTask);
   TaskMan1.ExecuteTask(myTask);
end;

procedure TForm1.GetActiveControlTask(var actTask: TTaskInfo_t);
begin
{  if ActiveControl.Name = 'ListBox1' then}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   TaskMan1.GetTaskProperties(ActiveControl,myTask);
   TaskMan1.EndTask(myTask);

   TaskMan1.FillTaskList;
   TaskMan2.FillTaskList;
end;

procedure TForm1.TaskMan2Fail(Sender: TObject);
begin
   MessageDlg('Taskman2: '+TaskMan2.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan1Fail(Sender: TObject);
begin
   MessageDlg('Taskman1: '+TaskMan1.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan2ExecuteTaskFail(Sender: TObject);
begin
 MessageDlg('Taskman2: '+TaskMan2.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan2EndTaskFail(Sender: TObject);
begin
 MessageDlg('Taskman2: '+TaskMan2.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan2DrawFail(Sender: TObject);
begin
 MessageDlg('Taskman2: '+TaskMan2.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan2MeasureFail(Sender: TObject);
begin
 MessageDlg('Taskman2: '+TaskMan2.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan1DrawFail(Sender: TObject);
begin
 MessageDlg('Taskman1: '+TaskMan1.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan1EndTaskFail(Sender: TObject);
begin
 MessageDlg('Taskman1: '+TaskMan1.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan1ExecuteTaskFail(Sender: TObject);
begin
 MessageDlg('Taskman1: '+TaskMan1.ErrorString,mtError,[mbOK],0);
end;

procedure TForm1.TaskMan1MeasureFail(Sender: TObject);
begin
 MessageDlg('Taskman1: '+TaskMan1.ErrorString,mtError,[mbOK],0);
end;

end.
