{K&J Tray Icon Demo           }
{by Joseph C. Keller          }
{ 1996                       }
{Version: 1.0 / UN-Registered }

unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, Buttons, ComCtrls, KJTrayIcon;

type
  TfrmMain = class(TForm)
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Image8: TImage;
    edtIconHint: TEdit;
    Label1: TLabel;
    Image9: TImage;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    spdOpenIcon1: TSpeedButton;
    spdOpenIcon2: TSpeedButton;
    spdOpenIcon3: TSpeedButton;
    spdOpenIcon4: TSpeedButton;
    spdOpenIcon5: TSpeedButton;
    OpenDialog1: TOpenDialog;
    btnDisplayIcon: TButton;
    btnRemoveIcon: TButton;
    cboDisplayIcon: TComboBox;
    btnStartAnimation: TButton;
    btnStopAnimation: TButton;
    cboAnimation: TComboBox;
    Label2: TLabel;
    TrackBar1: TTrackBar;
    btnDone: TBitBtn;
    btnReadMe: TBitBtn;
    PopupMenu1: TPopupMenu;
    componentwillallow1: TMenuItem;
    youtoeasilyattach1: TMenuItem;
    anystandardDelphi1: TMenuItem;
    TheKJTrayIconcomponent1: TMenuItem;
    N1: TMenuItem;
    Itsaseasyassettinga1: TMenuItem;
    propertyvalue1: TMenuItem;
    KJTrayIcon1: TKJTrayIcon;
    pnlMainIcon1: TPanel;
    imgIcon1: TImage;
    pnlSubIcon1: TPanel;
    pnlMainIcon2: TPanel;
    imgIcon2: TImage;
    pnlSubIcon2: TPanel;
    pnlMainIcon3: TPanel;
    imgIcon3: TImage;
    pnlSubIcon3: TPanel;
    pnlMainIcon4: TPanel;
    imgIcon4: TImage;
    pnlSubIcon4: TPanel;
    pnlMainIcon5: TPanel;
    imgIcon5: TImage;
    pnlSubIcon5: TPanel;
    procedure btnDisplayIconClick(Sender: TObject);
    procedure btnRemoveIconClick(Sender: TObject);
    procedure btnStopAnimationClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure spdOpenIcon1Click(Sender: TObject);
    procedure spdOpenIcon2Click(Sender: TObject);
    procedure spdOpenIcon3Click(Sender: TObject);
    procedure spdOpenIcon4Click(Sender: TObject);
    procedure spdOpenIcon5Click(Sender: TObject);
    procedure btnStartAnimationClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure edtIconHintChange(Sender: TObject);
    procedure btnDoneClick(Sender: TObject);
    procedure btnReadMeClick(Sender: TObject);
  private
    { Private declarations }
    procedure GroupBox2State(AState: boolean);
    procedure GroupBox1State(AState: boolean);
  public
    { Public declarations }
  end;

var frmMain: TfrmMain;

implementation

uses uReadMe;

{$R *.DFM}

procedure TfrmMain.GroupBox1State(AState: Boolean);
begin
  btnDisplayIcon.Enabled:=AState;
  cboDisplayIcon.Enabled:=AState;
  btnRemoveIcon.Enabled:= AState;
end;

procedure TfrmMain.GroupBox2State(AState: boolean);
begin
  btnStartAnimation.Enabled:=AState;
  btnStopAnimation.Enabled:= AState;
  cboAnimation.Enabled:=     AState;
  TrackBar1.Enabled:=        AState;
end;

procedure TfrmMain.btnDisplayIconClick(Sender: TObject);
begin
  GroupBox2State(False);

  KJTrayIcon1.Icon1:=imgIcon1.Picture.Icon;
  KJTrayIcon1.Icon2:=imgIcon2.Picture.Icon;
  KJTrayIcon1.Icon3:=imgIcon3.Picture.Icon;
  KJTrayIcon1.Icon4:=imgIcon4.Picture.Icon;
  KJTrayIcon1.Icon5:=imgIcon5.Picture.Icon;

  KJTrayIcon1.DisplayIcon(cboDisplayIcon.ItemIndex + 1);
end;

procedure TfrmMain.btnRemoveIconClick(Sender: TObject);
begin
  KJTrayIcon1.RemoveIcon;
  GroupBox2State(True);
end;

procedure TfrmMain.btnStopAnimationClick(Sender: TObject);
begin
  KJTrayIcon1.StopAnimation;
  KJTrayIcon1.RemoveIcon;

  GroupBox1State(True);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  // Note that the first line of the popup menu's contents
  // contains the "*" character.  This tells the K&J Tray Icon
  // component to bold the line.  The "*" character is not
  // displayed within the text.
  cboDisplayIcon.ItemIndex:=0;
  cboAnimation.ItemIndex:=0;
  TrackBar1Change(Sender);
  edtIconHintChange(Sender);
end;

procedure TfrmMain.spdOpenIcon1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    imgIcon1.Picture.LoadFromFile(OpenDialog1.Filename);
end;

procedure TfrmMain.spdOpenIcon2Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    imgIcon2.Picture.LoadFromFile(OpenDialog1.Filename);
end;

procedure TfrmMain.spdOpenIcon3Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    imgIcon3.Picture.LoadFromFile(OpenDialog1.Filename);
end;

procedure TfrmMain.spdOpenIcon4Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    imgIcon4.Picture.LoadFromFile(OpenDialog1.Filename);
end;

procedure TfrmMain.spdOpenIcon5Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    imgIcon5.Picture.LoadFromFile(OpenDialog1.Filename);
end;

procedure TfrmMain.btnStartAnimationClick(Sender: TObject);
begin
  GroupBox1State(False);

  if cboAnimation.ItemIndex = 0 then begin
    KJTrayIcon1.Icon1:=Image4.Picture.Icon;
    KJTrayIcon1.Icon2:=Image5.Picture.Icon;
    KJTrayIcon1.Icon3:=Image6.Picture.Icon;
    KJTrayIcon1.Icon4:=Image7.Picture.Icon;
    KJTrayIcon1.Icon5:=Image8.Picture.Icon;
    KJTrayIcon1.StartAnimation(1,5);
  end else if cboAnimation.ItemIndex = 1 then begin
    KJTrayIcon1.Icon1:=Image9.Picture.Icon;
    KJTrayIcon1.Icon2:=Image1.Picture.Icon;
    KJTrayIcon1.Icon3:=Image2.Picture.Icon;
    KJTrayIcon1.Icon4:=Image3.Picture.Icon;
    KJTrayIcon1.StartAnimation(1,4);
  end;
end;

procedure TfrmMain.TrackBar1Change(Sender: TObject);
begin
  TrackBar1.SelEnd:=TrackBar1.Position;
  KJTrayIcon1.Interval:=TrackBar1.Position;
end;

procedure TfrmMain.edtIconHintChange(Sender: TObject);
begin
  KJTrayIcon1.Hint:=edtIconHint.Text;
end;

procedure TfrmMain.btnDoneClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.btnReadMeClick(Sender: TObject);
var frmReadMe: TFrmReadMe;
begin
  frmReadMe:=TFrmReadMe.Create(Self);
  frmReadMe.ShowModal;
  frmReadMe.Free;
end;

end.
