unit Vtmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Valid, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Validator: TValidator;
    Panel1: TPanel;
    ValidateButton: TSpeedButton;
    ExitButton: TSpeedButton;
    Memo1: TMemo;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ValidateButtonClick(Sender: TObject);
    procedure ValidatorVldFailed(Sender: TObject);
    procedure ValidatorVldOk(Sender: TObject);
  private
    { Private declarations }
    ValidationOk : boolean;
    procedure UpdateControls;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.UpdateControls;
begin
  if Validator.IsValidated then
  begin
    ValidationOk:=true;
    Memo1.ReadOnly:=false;
    with ValidateButton do
    begin
      Glyph.Handle:=LoadBitmap(hInstance,'BBCANCEL');
      NumGlyphs:=2;
      Hint:='Devalidate';
    end;
  end
  else
  begin
    ValidationOk:=false;
    Memo1.ReadOnly:=true;
    with ValidateButton do
    begin
      Glyph.Handle:=LoadBitmap(hInstance,'BBOK');
      NumGlyphs:=2;
      Hint:='Validate';
    end;
  end;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ValidationOk:=Validator.IsValidated;
  UpdateControls;
end;

procedure TForm1.ValidateButtonClick(Sender: TObject);
begin
  if ValidationOk then
  begin
    Validator.Devalidate;
    ValidationOk:=false;
  end
  else
  begin
    Validator.Validate;
    ValidationOk:=Validator.IsValidated;
  end;
  UpdateControls;
end;

procedure TForm1.ValidatorVldFailed(Sender: TObject);
begin
  MessageBeep(MB_ICONSTOP);
  MessageDlg('Validation Failed',mtError,[mbOk],0);
end;

procedure TForm1.ValidatorVldOk(Sender: TObject);
begin
  MessageBeep(MB_ICONASTERISK);
  MessageDlg('Validation Successful',mtInformation,
              [mbOk],0);
end;

end.
