//
// Support Library
//
{$A-,S-,O+,F+,H+}
unit DosLib;

interface

Uses
  Windows,
  SysUtils;

Function GetEnv(const ev : string):String;
Function FindProcessFile(cmd : string; Const ExeFirst: Boolean):string;
Function PathBackSlash(const s : string) : string;

implementation

//
// return environment string given environment variable
//

Function GetEnv(const ev : string):String;
  begin
    SetLength(result,1024);
    SetLength(result,GetEnvironmentVariable(pChar(ev),pchar(result),1024));
  end;

//
// Return Fully Qualified File Name (searches path). ExeFirst allows
// the search to check EXE files first. If false, COM files are searched
// first.
//

Function FindProcessFile(cmd : string; Const ExeFirst: Boolean):string;
Var longPath : String;
  begin
    result := '';
    if cmd = '' then exit;
    if pos(' ',cmd) > 0 then cmd := copy(cmd,1,pos(' ',cmd)-1);
    LongPath := ExtractFilePath(Paramstr(0))+';'+GetEnv('PATH');
    if ExtractFileExt(cmd)='' then
       begin
         if Not ExeFirst then
            result := FileSearch(ChangeFileExt(cmd,'.COM'),LongPath);
         if result = '' then
            result := FileSearch(ChangeFileExt(cmd,'.EXE'),LongPath);
         if ExeFirst and (Result = '') then
            result := FileSearch(ChangeFileExt(cmd,'.COM'),LongPath);
         if result = '' then
            result := FileSearch(ChangeFileExt(cmd,'.BAT'),LongPath);
       end
    else
       result := FileSearch(cmd,LongPath);
  end;

//
// add a backslash to the path given
//

Function PathBackSlash(const s : string) : string;
  begin
    result := s;
    if s = '' then exit;
    if not (s[length(s)] in ['\', ':',#0]) then result := result + '\';
  end;

end.
