(*	Description:	A Simple Example demonstrating the creation of a Mail Merge
									document in	Microsoft Word 97.

    Author:				Brian Armstrong
    Company:			ZBA International Ent.
    Date:					June 4, 1997

    Delphi Ver:		2.x/3.x
    Components:		[Standard Delphi components]
    							[RX Library VCL Extensions Ver 2.31]
    							Filename: RXLIT231.ZIP
                  Web Download Location: Delphi Super Page (http://sunsite.icm.edu.pl/delphi/)

                  NOTE: For usage in Delphi 2.x remove the unit ComObj in the USES clause,
                  			and replace it with OleAuto.

*)


{NOTE:	I haven't yet created a Template document for Word to further test the creation of
				Print jobs and New Documents resulting from a Merge, but investigate the Destination
        property in the Word VBA help file [VBAWRD8.HLP] found in the Office directory for
        your Office97 installation, which gives an example of using to format a document for
        completing the merge operation.
}


unit UnitMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComObj, Buttons, Mask, ToolEdit, DBTables;

type
  TfrmWordVBA = class(TForm)
    dataFile: TFilenameEdit;
    btnClose: TBitBtn;
    cmDocType: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    memSQLQuery: TMemo;
    Label3: TLabel;
    cmDSN: TComboBox;
    Label4: TLabel;
    btnMerge: TBitBtn;
    templateFile: TFilenameEdit;
    Label5: TLabel;
    procedure btnMergeClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure memSQLQueryChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWordVBA: TfrmWordVBA;

implementation
var
	WordDoc: Variant;
  Document, WordMailMerge,
  ActiveDocument: Variant;
  Connection, SQLStatement: Variant;
  constr: string;
  SQLText: WideString;
const
	wdCatalog = 0;
  wdEnvelopes = 1;
  wdFormLetters = 2;
  wdMailingLabels = 3;
  wdNotAMergeDocument = 4;

{$R *.DFM}

procedure TfrmWordVBA.btnMergeClick(Sender: TObject);
begin
	Application.ProcessMessages;
  btnMerge.Enabled := False;

	try
  	WordDoc := GetActiveOleObject ('Word.Application');
  except
	  //Create Word Ole Object
		WordDoc := CreateOleObject ('Word.Application');
  end;
  
	//Assign Documents collection to Document Variant
  Document := WordDoc.Documents;
  //Create New Document
  Document.Add;

  //Assign ActiveDocument Variant to the ActiveDocument [Main Document] in Word
  ActiveDocument := WordDoc.ActiveDocument;
  //Assign ActiveDocument's MailMerge property to the WordMailMerge Variant
	WordMailMerge := ActiveDocument.MailMerge;

  //Assign MainDocumentType constant
	With cmDocType do
  begin
  	CASE ItemIndex of
    	0: WordMailMerge.MainDocumentType := wdCatalog;
      1: WordMailMerge.MainDocumentType := wdEnvelopes;
      2: WordMailMerge.MainDocumentType := wdFormLetters;
      3: WordMailMerge.MainDocumentType := wdMailingLabels;
      4: WordMailMerge.MainDocumentType := wdNotAMergeDocument;
    end;
  end;

  //Assign DSN [DataSourceName] from ODBC
  constr :='DSN=' + cmDSN.Text;

  //Assign SQLText from memSQLQuery.Lines
  SQLText := memSQLQuery.Text;

  //Open Mail Merge Datasource
  WordMailMerge.OpenDataSource (Name := dataFile.Text, Connection := constr,
  	SQLStatement := SQLText);

  //Make Word Visible
  WordDoc.Visible := True;
  btnMerge.Enabled := True;  
end;

procedure TfrmWordVBA.btnCloseClick(Sender: TObject);
begin
	Close;
end;

procedure TfrmWordVBA.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;



procedure TfrmWordVBA.FormCreate(Sender: TObject);
begin
  with cmDSN do
  begin
    Items.Clear;
    Session.GetAliasNames(Items);
  end;

	//Set the cmDocType.ItemIndex to 'Form Letter'
	cmDocType.ItemIndex := 2;
end;

procedure TfrmWordVBA.memSQLQueryChange(Sender: TObject);
begin
	btnMerge.Enabled := True;
end;


end.
