unit Filefunc;

{ File functions}

interface

uses WinTypes, WinProcs, SysUtils;

  const
  DateTimeFormat = 'mmm d, yy  hh:mm:ss';

  function GetFileInfo(const FN: string; var F: TSearchRec): boolean;

  function ShowFileStats(const F: TSearchRec): string;

implementation

function GetFileInfo(const FN: string; var F: TSearchRec): boolean;
{-Returns True if file is found}
begin
  Result := FindFirst(FN, faAnyFile, F) = 0;
  FindClose(F);
  if not Result then
    MessageBeep(MB_ICONASTERISK);
end;

function ShowFileStats(const F: TSearchRec): string;
{-Return formatted string w/ file info}
var
  AttrStr, S: string;
begin
  try
    S := FormatDateTime(DateTimeFormat, FileDateToDateTime(F.Time));
  except {illegal date or time}
    S := 'BAD FILE DATE';
  end;
 { Formatting for attribute string }
  with F do
  begin
    AttrStr := '----';
    if Attr and faReadOnly <> 0 then
      attrstr[1] := 'R';
    if Attr and faArchive <> 0 then
      attrstr[2] := 'A';
    if Attr and faSysFile <> 0 then
      attrstr[3] := 'S';
    if Attr and faHidden <> 0 then
      attrstr[4] := 'H';
  end;
  Result := Format('%12s  Size: %6s  Date: %s  %s',
    [F.Name, FormatFloat(',##########0', F.Size), S, AttrStr]);
end;

end.
