unit Textclip;
(*-----
    File: TEXTCLIP.PAS for Project CODEAPP.DPR
-----*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Grids, Buttons;

type
  TTextClips = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Memo1: TMemo;
    Label1: TLabel;
    CopyButton: TButton;
    AllBtn: TButton;
    ClearBtn: TButton;
    BtnHelp: TBitBtn;
    CloseBtn: TBitBtn;
    procedure CopyButtonClick(Sender: TObject);
    procedure AllBtnClick(Sender: TObject);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Memo1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
  private
    { Private declarations }
    HasSelection: boolean;
    procedure CheckEnableCopy;
  public
    { Public declarations }
    LinesCopied: integer; {the Total}
  end;

var
  TextClips: TTextClips;

implementation

{$R *.DFM}

procedure TTextClips.CheckEnableCopy;
begin
  with Memo1 do
  begin
    AllBtn.Enabled := True;
    HasSelection := SelLength <> 0;
    if HasSelection then
    begin
      CopyButton.Enabled := True;
      ClearBtn.Enabled := True;
    end
    else
      CopyButton.Enabled := False;
  end;
end;

procedure TTextClips.Memo1Change(Sender: TObject);
begin
  CheckEnableCopy;
end;

procedure TTextClips.Memo1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  CheckEnableCopy;
end;

procedure TTextClips.Memo1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  CheckEnableCopy;
end;

procedure TTextClips.CopyButtonClick(Sender: TObject);
{-Copies contents of memo to ClipBoard}
begin
  Memo1.CopyToClipboard;
end;

procedure TTextClips.AllBtnClick(Sender: TObject);
{-Selects all text in memo}
begin
  Memo1.SelectAll;
  CheckEnableCopy;
end;

procedure TTextClips.FormCreate(Sender: TObject);
{-Readies this TMemo window}
begin
  HasSelection := False;
  Left := 0;
  Top := Screen.Height - Height;
  LinesCopied := 0;
  Memo1.SelStart := 0;
end;

procedure TTextClips.ClearBtnClick(Sender: TObject);
{-User probably wants to start over}
begin
  Memo1.ClearSelection;
  ClearBtn.Enabled := False;
  AllBtn.Enabled := False;
  LinesCopied := 0;
  Label1.Caption := Format('%d Lines total', [LinesCopied]);
end;

procedure TTextClips.BtnHelpClick(Sender: TObject);
begin
  MessageDlg('Whenever text is placed in this buffer'+#13+
  'the entire contents is copied to the Windows ClipBoard.'+#13+
  'The contents can be edited, then Copy To ClipBoard used.',
  mtInformation, [mbCancel], 0);
end;

procedure TTextClips.CloseBtnClick(Sender: TObject);
begin
  Close
end;

end.
